/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import rnadesign.rnacontrol.PackageConstants;
import tools3d.CoordinateSystem;
import tools3d.Matrix4D;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.symmetry2.SymCopies;
import tools3d.symmetry2.SymCopySingleton;

public class SymmetryController {
    SymCopies symCopies = SymCopySingleton.getInstance();

    public SymmetryController() {
        this.init();
    }

    private void init() {
        this.symCopies.add(new CoordinateSystem3D(new Vector3D(0.0, 0.0, 0.0)));
    }

    public int size() {
        return this.symCopies.size();
    }

    public void add(CoordinateSystem cs) {
        this.symCopies.add(new CoordinateSystem3D(cs));
    }

    public void add(Vector3D base, Vector3D x, Vector3D y) {
        this.symCopies.add(new CoordinateSystem3D(base, x, y));
    }

    public void add(Matrix4D matrix) {
        this.symCopies.add(new CoordinateSystem3D(matrix));
    }

    public void clear() {
        this.symCopies.clear();
        this.init();
    }

    public SymCopies getSymCopies() {
        return this.symCopies;
    }

    public String infoString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Number coordinate systems: " + this.size() + PackageConstants.NEWLINE);
        for (int i = 0; i < this.size(); ++i) {
            buf.append("Coordinate system " + (i + 1) + PackageConstants.NEWLINE);
            buf.append(((CoordinateSystem)this.symCopies.get(i)).toString() + PackageConstants.NEWLINE);
        }
        return buf.toString();
    }
}

