/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import chemistrytools.ChemicalElement;
import chemistrytools.PeriodicTableImp;
import freeware.PrintfFormat;
import generaltools.StringTools;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.PackageConstants;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DTester;
import tools3d.objects3d.Object3DWriter;

public abstract class AbstractPdbWriter
implements Object3DWriter {
    public static final int RESIDUE_PDB_NUMBER = 1;
    public static final int RESIDUE_RECOUNTED_NUMBER = 2;
    public static final int RESIDUE_NAMED_NUMBER = 3;
    public static final int RESIDUE_TOTAL_COUNT = 4;
    public static final int DIALECT_DEFAULT = 1;
    public static final int DIALECT_SIGNATURE = 2;
    public static final String REMARK_HEADER = "REMARK";
    protected int dialect = 1;
    protected Object3DTester objectTester = null;
    protected int lineCounter = 1;
    protected boolean junctionMode = true;
    protected boolean remarkMode = false;
    public static boolean debugMode = false;
    protected int originalMode = 2;

    private static String atomNameToPdb(String name) {
        String result = name;
        if (name.length() > 4) {
            result = name.substring(0, 4);
        } else if (name.length() < 4) {
            result = " " + name;
            result = StringTools.fillRight(result, 4, " ");
        }
        return result;
    }

    public Object3DTester getObjectTester() {
        return this.objectTester;
    }

    public void setObjectTester(Object3DTester tester) {
        this.objectTester = tester;
    }

    public void setRemarkMode(boolean b) {
        this.remarkMode = b;
    }

    public void setOriginalMode(int mode) {
        this.originalMode = mode;
    }

    public void setJunctionMode(boolean b) {
        this.junctionMode = b;
    }

    private String writeAtom(String atomName, double x, double y, double z, String residueName, char strandChar, int residueCount, String recordName, ChemicalElement element) {
        PrintfFormat serialFormat = new PrintfFormat("%5d");
        PrintfFormat residueCountFormat = new PrintfFormat("%4d");
        PrintfFormat positionFormat = new PrintfFormat("%8.3f");
        if (this.dialect == 2) {
            positionFormat = new PrintfFormat("%10.5f");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.setLength(0);
        buffer.append(recordName);
        buffer.append(serialFormat.sprintf(this.lineCounter++));
        buffer.append(' ');
        if (this.dialect == 2) {
            buffer.append(" " + atomName + "    ");
        } else {
            buffer.append(AbstractPdbWriter.atomNameToPdb(atomName));
        }
        buffer.append(' ');
        buffer.append(StringTools.fillLeft(residueName, 3, " "));
        buffer.append(' ');
        buffer.append(strandChar);
        if (this.dialect == 2) {
            buffer.append(' ');
        }
        buffer.append(residueCountFormat.sprintf(residueCount));
        if (this.dialect == 2) {
            buffer.append(" ");
        } else {
            buffer.append("    ");
        }
        buffer.append(positionFormat.sprintf(x));
        buffer.append(positionFormat.sprintf(y));
        buffer.append(positionFormat.sprintf(z));
        if (this.dialect == 1) {
            buffer.append("  1.00  0.00  ");
        } else if (this.dialect == 2) {
            buffer.append(" " + element.getShortName() + "_     " + PeriodicTableImp.findDefaultValency(element) + " 0  0.00000");
        }
        String result = buffer.toString();
        return result;
    }

    protected List<String> extractRemarks(Object3D node) {
        Properties properties = node.getProperties();
        ArrayList<String> result = new ArrayList<String>();
        if (properties != null) {
            Enumeration<?> emu = properties.propertyNames();
            while (emu.hasMoreElements()) {
                String s = (String)emu.nextElement();
                if (!s.startsWith(REMARK_HEADER)) continue;
                result.add("REMARK    " + properties.getProperty(s) + PackageConstants.SLASH);
            }
        }
        return result;
    }

    protected List<String> extractPropertiesAsRemarks(Object3D node) {
        Properties properties = node.getProperties();
        ArrayList<String> result = new ArrayList<String>();
        if (properties != null) {
            Enumeration<?> emu = properties.propertyNames();
            while (emu.hasMoreElements()) {
                String s = (String)emu.nextElement();
                result.add("REMARK    " + s + "=" + properties.getProperty(s) + PackageConstants.SLASH);
            }
        }
        return result;
    }

    private String writeAtom(String atomName, double x, double y, double z, String residueName, char strandChar, int residueCount, ChemicalElement element) {
        return this.writeAtom(atomName, x, y, z, residueName, strandChar, residueCount, "ATOM  ", element);
    }

    private String writeHeteroAtom(String atomName, double x, double y, double z, String residueName, char strandChar, int residueCount, ChemicalElement element) {
        return this.writeAtom(atomName, x, y, z, residueName, strandChar, residueCount, "HETATM", element);
    }

    public String writeAtom(Atom3D atom, String residueName, char strandChar, int residueCount) {
        Vector3D pos = atom.getPosition();
        double x = pos.getX();
        double y = pos.getY();
        double z = pos.getZ();
        atom.setProperty("pdb_atom_id", "" + this.lineCounter);
        return this.writeAtom(atom.getName(), x, y, z, residueName, strandChar, residueCount, atom.getElement());
    }

    public String writeHeteroAtom(Atom3D atom, String residueName, char strandChar, int residueCount) {
        Vector3D pos = atom.getPosition();
        double x = pos.getX();
        double y = pos.getY();
        double z = pos.getZ();
        atom.setProperty("pdb_atom_id", "" + this.lineCounter);
        return this.writeHeteroAtom(atom.getName(), x, y, z, residueName, strandChar, residueCount, atom.getElement());
    }
}

