/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.Optimizer;
import generaltools.PropertyTools;
import generaltools.Randomizer;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;
import numerictools.DoubleTools;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.HelixParameters;
import rnadesign.rnamodel.InteractionLink;
import rnadesign.rnamodel.JunctionDBConstraintLink;
import rnadesign.rnamodel.JunctionMultiConstraintLink;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideDBTools;
import rnadesign.rnamodel.RnaLinkTools;
import rnadesign.rnamodel.RnaModelException;
import rnasecondary.RnaInteractionType;
import sequence.LetterSymbol;
import tools3d.CoordinateSystem;
import tools3d.GaussianOrientableMutator;
import tools3d.Vector3D;
import tools3d.objects3d.AngleLink;
import tools3d.objects3d.ConstraintLink;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DSetTools;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleObject3DSet;
import tools3d.objects3d.TorsionLink;
import tools3d.symmetry2.SymCopies;

public class BasepairOptimizer
implements Optimizer {
    public static final double INITIAL_ERROR = 1.0E30;
    public static final double TRANSLATION_STEP = 4.0;
    public static final double ANGLE_STEP = 0.2617993877991494;
    private HelixParameters defaultHelixParameters = new HelixParameters();
    private boolean addHelicesMode = false;
    private double annealingFactor = 0.95;
    private int annealingInterval = 10000;
    private int chosen = 0;
    private boolean keepFirstFixedMode = false;
    protected int outputInterval = 10000;
    private Object3D root;
    private boolean firstPass = true;
    private double scaleLimit = 10.0;
    private double scaleMult = 0.02;
    private Map<Object3D, Integer> objectGroupIdMap = new HashMap<Object3D, Integer>();
    private List<InteractionLink> basepairConstraints;
    private List<ConstraintLink> distanceConstraints;
    private List<AngleLink> angleConstraints;
    private List<TorsionLink> torsionConstraints;
    private List<JunctionMultiConstraintLink> junctionConstraints;
    private List<JunctionDBConstraintLink> junctionDBConstraints;
    private LinkSet allLinks;
    private LinkSet basePairDB;
    private double scoreMinimumLimit = 0.5;
    private List<Object3DSet> objectBlocks;
    private Vector3D[][] objectResidueBlocksOrig;
    private Vector3D[][] objectResidueBlocksCurr;
    private String refAtomName = "C4*";
    private double[] lastScores;
    private double[] currScores;
    private int[] groupConstraintCounts;
    protected List<CoordinateSystem> origCoordinateSystems;
    protected List<CoordinateSystem> optCoordinateSystems;
    private double[] coordScoreAverages;
    private double[] coordScoreAveragesTmp;
    private double[] coordScoreAveragesSaved;
    private boolean[] moveFlags;
    private int numberSteps;
    private double ktOrig = 2.0;
    protected static Logger log = Logger.getLogger("NanoTiler_debug");
    private double electrostaticLength = 5.0;
    private double vdwLength = 4.5;
    private double vdwLength2 = 4.5;
    private int electroStride = 1;
    private double electrostaticWeight = 0.0;
    private double vdwWeight = 0.0;
    private double vdwWeight2 = 0.0;
    private double errorScoreLimit;
    private GaussianOrientableMutator mutator = new GaussianOrientableMutator(4.0, 0.2617993877991494);
    private GaussianOrientableMutator mutatorOrig = new GaussianOrientableMutator(4.0, 0.2617993877991494);
    private List<Vector3D> axisList;
    private static SymCopies symCopies;
    private int[] symVdwActive;
    private int verboseLevel = 1;

    public BasepairOptimizer(LinkSet links, List<Object3DSet> objectBlocks, int numberSteps, double errorScoreLimit, LinkSet basePairDB, int[] _symVdwActive, SymCopies _symCopies) {
        this.init(links, objectBlocks, numberSteps, errorScoreLimit, basePairDB, _symVdwActive, _symCopies);
        log.info("Successfully created constraint optimizer object.");
    }

    protected void init(LinkSet links, List<Object3DSet> objectBlocks, int numberSteps, double errorScoreLimit, LinkSet basePairDB, int[] _symVdwActive, SymCopies _symCopies) {
        int i;
        String objBlockString = "";
        for (i = 0; i < objectBlocks.size(); ++i) {
            for (int j = 0; j < objectBlocks.get(i).size(); ++j) {
                objBlockString = objBlockString + objectBlocks.get(i).get(j).getFullName();
                if (j + 1 >= objectBlocks.get(i).size()) continue;
                objBlockString = objBlockString + ",";
            }
            objBlockString = objBlockString + ";";
        }
        log.info("Starting to initialize constraint optimizer object: " + objBlockString);
        symCopies = _symCopies;
        this.numberSteps = numberSteps;
        this.errorScoreLimit = errorScoreLimit;
        this.basepairConstraints = new ArrayList<InteractionLink>();
        this.distanceConstraints = new ArrayList<ConstraintLink>();
        this.angleConstraints = new ArrayList<AngleLink>();
        this.torsionConstraints = new ArrayList<TorsionLink>();
        this.junctionConstraints = new ArrayList<JunctionMultiConstraintLink>();
        this.junctionDBConstraints = new ArrayList<JunctionDBConstraintLink>();
        this.allLinks = links;
        this.objectBlocks = objectBlocks;
        this.basePairDB = basePairDB;
        this.symVdwActive = _symVdwActive;
        if (_symVdwActive == null) {
            this.symVdwActive = new int[symCopies.size()];
            for (i = 0; i < this.symVdwActive.length; ++i) {
                this.symVdwActive[i] = i;
            }
        }
        assert (basePairDB != null);
        assert (objectBlocks != null);
        assert (objectBlocks.size() > 0);
        for (i = 0; i < links.size(); ++i) {
            Link link = links.get(i);
            if (RnaLinkTools.isBasePairLink(link) && this.checkLinkRelevant(link)) {
                this.basepairConstraints.add((InteractionLink)link);
                continue;
            }
            if (link instanceof JunctionMultiConstraintLink) {
                System.out.println("Hey " + link);
                if (this.checkJunctionLinkRelevant((JunctionMultiConstraintLink)link)) {
                    this.junctionConstraints.add((JunctionMultiConstraintLink)link);
                    log.info("Junction constraint added to BasepairOptimizer: " + ((Object)link).toString());
                    continue;
                }
                log.info("Junction constraint not relevant: " + ((Object)link).toString());
                continue;
            }
            if (link instanceof JunctionDBConstraintLink) {
                this.junctionDBConstraints.add((JunctionDBConstraintLink)link);
                continue;
            }
            if (link instanceof ConstraintLink) {
                if (this.checkLinkRelevant(link)) {
                    this.distanceConstraints.add((ConstraintLink)link);
                    continue;
                }
                log.info("Link is not relevant: " + link);
                continue;
            }
            if (link instanceof AngleLink && this.checkLinkRelevant(link)) {
                this.angleConstraints.add((AngleLink)link);
                continue;
            }
            if (link instanceof TorsionLink) {
                if (this.checkTorsionRelevant((TorsionLink)link)) {
                    this.torsionConstraints.add((TorsionLink)link);
                    continue;
                }
                log.info("Torsion constraint not relevant: " + ((Object)link).toString());
                continue;
            }
            log.finest("Did not recognize type of link: " + ((Object)link).toString());
        }
        if (this.basepairConstraints.size() == 0 && this.distanceConstraints.size() == 0 && this.angleConstraints.size() == 0 && this.torsionConstraints.size() == 0 && this.junctionConstraints.size() == 0 && this.junctionDBConstraints.size() == 0) {
            log.warning("No constraints defined! Use command genbasepair or gendistconstraint or gentorsionconstraintbefore start optimize_basepairs");
        } else {
            this.origCoordinateSystems = this.generateCoordinateSystems(objectBlocks.size());
            this.optCoordinateSystems = this.generateCoordinateSystems(objectBlocks.size());
            this.coordScoreAverages = new double[objectBlocks.size()];
            this.coordScoreAveragesTmp = new double[objectBlocks.size()];
            this.coordScoreAveragesSaved = new double[objectBlocks.size()];
            this.lastScores = new double[objectBlocks.size()];
            this.currScores = new double[objectBlocks.size()];
            this.resetCoordScoreAverages();
            this.moveFlags = new boolean[this.coordScoreAverages.length];
            for (i = 0; i < this.moveFlags.length; ++i) {
                this.moveFlags[i] = true;
            }
            this.groupConstraintCounts = new int[this.origCoordinateSystems.size()];
            String outCount = "";
            int counter = 0;
            for (int i2 = 0; i2 < this.groupConstraintCounts.length; ++i2) {
                this.groupConstraintCounts[i2] = this.countGroupConstraints(i2);
                outCount = outCount + this.groupConstraintCounts[i2] + " ";
                counter += this.groupConstraintCounts[i2];
            }
            this.initObjectResidueBlocks();
            assert (counter > 0);
            if (this.optCoordinateSystems.size() < 2) {
                this.keepFirstFixedMode = false;
            }
            log.info("Group constraint counts: " + outCount);
        }
        log.info("Successfully initialized constraint optimizer object.");
    }

    private void storeScores() {
        for (int i = 0; i < this.lastScores.length; ++i) {
            this.lastScores[i] = this.currScores[i];
            this.currScores[i] = 0.0;
        }
    }

    private boolean checkLinkRelevant(Link link) {
        ConstraintLink cLink;
        Object3D obj1 = link.getObj1();
        Object3D obj2 = link.getObj2();
        int g1 = this.findObjectGroupId(obj1);
        int g2 = this.findObjectGroupId(obj2);
        if (g1 < 0 || g2 < 0) {
            return false;
        }
        if (g1 != g2) {
            return true;
        }
        return link instanceof ConstraintLink && (cLink = (ConstraintLink)link).getSymId1() != cLink.getSymId2();
    }

    private boolean checkTorsionRelevant(TorsionLink link) {
        Object3D obj1 = link.getObj1();
        Object3D obj2 = link.getObj2();
        Object3D obj3 = link.getObj3();
        Object3D obj4 = link.getObj4();
        int g1 = this.findObjectGroupId(obj1);
        int g2 = this.findObjectGroupId(obj2);
        int g3 = this.findObjectGroupId(obj3);
        int g4 = this.findObjectGroupId(obj4);
        if (g1 < 0 || g2 < 0 || g3 < 0 || g4 < 0) {
            return false;
        }
        return g1 != g2 || g1 != g2 || g1 != g3 || g1 != g4;
    }

    private boolean checkJunctionLinkRelevant(JunctionMultiConstraintLink link) {
        log.info("Starting checkJunctionLinkRelevant: " + link.getBranchCount() + " branches.");
        assert (link.size() > 0);
        int g1 = this.findObjectGroupId(link.getObj(0));
        System.out.println("g1: " + g1);
        for (int i = 1; i < link.size(); ++i) {
            int g2 = this.findObjectGroupId(link.getObj(i));
            System.out.println("g2: " + link.getObj(i).getFullName());
            if (g1 == g2 && link.getSymId(0) == link.getSymId(i)) continue;
            return true;
        }
        return false;
    }

    private List<CoordinateSystem> generateCoordinateSystems(int n) {
        ArrayList<CoordinateSystem> result = new ArrayList<CoordinateSystem>();
        for (int i = 0; i < n; ++i) {
            result.add(new CoordinateSystem3D(new Vector3D(0.0, 0.0, 0.0)));
        }
        return result;
    }

    private int findObjectGroupId(Object3D object) {
        assert (this.objectGroupIdMap != null);
        Integer nObj = this.objectGroupIdMap.get(object);
        if (nObj == null) {
            nObj = new Integer(this._findObjectGroupId(object));
            this.objectGroupIdMap.put(object, nObj);
        }
        return nObj;
    }

    private int _findObjectGroupId(Object3D object) {
        for (int i = 0; i < this.objectBlocks.size(); ++i) {
            Object3DSet objSet = this.objectBlocks.get(i);
            for (int j = 0; j < objSet.size(); ++j) {
                if (!Object3DTools.isAncestor(objSet.get(j), object)) continue;
                return i;
            }
        }
        return -1;
    }

    private void setMovableObject(Object3D object) {
        int id = this.findObjectGroupId(object);
        if (id >= 0) {
            this.moveFlags[id] = true;
            log.fine("Setting object " + object.getName() + " to movable group: " + (id + 1));
        } else {
            log.warning("Could not find suitable parent object for " + object.getName());
            assert (false);
        }
    }

    public void setMovableObjects(Object3DSet objects) {
        int i;
        assert (objects != null);
        assert (objects.size() > 0);
        for (i = 0; i < this.moveFlags.length; ++i) {
            this.moveFlags[i] = false;
        }
        for (i = 0; i < objects.size(); ++i) {
            this.setMovableObject(objects.get(i));
        }
    }

    private void resetCoordScoreAverages() {
        for (int i = 0; i < this.coordScoreAverages.length; ++i) {
            this.coordScoreAverages[i] = 1.0;
            this.coordScoreAveragesTmp[i] = 1.0;
        }
    }

    private void saveCoordScoreAverages() {
        for (int i = 0; i < this.coordScoreAverages.length; ++i) {
            this.coordScoreAveragesSaved[i] = this.coordScoreAverages[i];
        }
    }

    private void restoreCoordScoreAverages() {
        for (int i = 0; i < this.coordScoreAverages.length; ++i) {
            this.coordScoreAverages[i] = this.coordScoreAveragesSaved[i];
        }
    }

    protected void applyTransformations(List<CoordinateSystem> coords) {
        ArrayList<Object3D> appliedObjects = new ArrayList<Object3D>();
        assert (coords.size() == this.objectBlocks.size());
        assert (this.moveFlags.length == this.objectBlocks.size());
        assert (this.moveFlags.length == coords.size());
        for (int i = 0; i < this.objectBlocks.size(); ++i) {
            if (!this.moveFlags[i]) continue;
            for (int j = 0; j < this.objectBlocks.get(i).size(); ++j) {
                Object3D newRoot = this.objectBlocks.get(i).get(j);
                if (newRoot == null || Object3DTools.findAncestorOrEqual(newRoot, appliedObjects) != null) continue;
                newRoot.activeTransform(coords.get(i));
                appliedObjects.add(newRoot);
            }
        }
    }

    protected static double computeBasePairError(Vector3D[] n1, Vector3D[] n2, Vector3D[] refNt1, Vector3D[] refNt2) {
        assert (n1.length == refNt1.length);
        assert (n2.length == refNt2.length);
        assert (n1.length > 0);
        assert (n2.length > 0);
        double sum = 0.0;
        for (int i = 0; i < n1.length; ++i) {
            for (int j = 0; j < n2.length; ++j) {
                double dd = n1[i].distance(n2[j]) - refNt1[i].distance(refNt2[j]);
                sum += dd * dd;
            }
        }
        assert (sum > 0.0);
        return Math.sqrt(sum / (double)(n1.length * n2.length));
    }

    private static void applyCoordinateTransformation(Vector3D[] v, CoordinateSystem cs) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = cs.activeTransform(v[i]);
        }
    }

    protected static double computeBasePairError(CoordinateSystem cs1, CoordinateSystem cs2, Nucleotide3D n1, Nucleotide3D n2, Nucleotide3D refNt1, Nucleotide3D refNt2) throws RnaModelException {
        Object3DSet n1Set = NucleotideDBTools.extractAtomMultipod(n1);
        Object3DSet n2Set = NucleotideDBTools.extractAtomMultipod(n2);
        Object3DSet refN1Set = NucleotideDBTools.extractAtomMultipod(refNt1);
        Object3DSet refN2Set = NucleotideDBTools.extractAtomMultipod(refNt2);
        Vector3D[] n1v = Object3DSetTools.getCoordinates(n1Set);
        Vector3D[] n2v = Object3DSetTools.getCoordinates(n2Set);
        Vector3D[] refN1v = Object3DSetTools.getCoordinates(refN1Set);
        Vector3D[] refN2v = Object3DSetTools.getCoordinates(refN2Set);
        BasepairOptimizer.applyCoordinateTransformation(n1v, cs1);
        BasepairOptimizer.applyCoordinateTransformation(n2v, cs2);
        double result = BasepairOptimizer.computeBasePairError(n1v, n2v, refN1v, refN2v);
        assert (result > 0.0);
        return result;
    }

    protected static double computeDistanceConstraintError(CoordinateSystem cs1, CoordinateSystem cs2, ConstraintLink cLink) {
        Object3D obj1 = cLink.getObj1();
        Object3D obj2 = cLink.getObj2();
        Vector3D pos1 = obj1.getPosition();
        Vector3D pos2 = obj2.getPosition();
        Vector3D pos1b = cs1.activeTransform(pos1);
        if (cLink.getSymId1() > 0) {
            pos1b = ((CoordinateSystem)symCopies.get(cLink.getSymId1())).activeTransform(pos1b);
        }
        Vector3D pos2b = cs2.activeTransform(pos2);
        if (cLink.getSymId2() > 0) {
            pos2b = ((CoordinateSystem)symCopies.get(cLink.getSymId2())).activeTransform(pos2b);
        }
        return cLink.getConstraint().getDiff(pos1b.distance(pos2b));
    }

    protected static double computeAngleConstraintError(CoordinateSystem cs1, CoordinateSystem cs2, CoordinateSystem cs3, AngleLink cLink) {
        Object3D obj1 = cLink.getObj1();
        Object3D obj2 = cLink.getObj2();
        Object3D obj3 = cLink.getObj3();
        Vector3D pos1 = obj1.getPosition();
        Vector3D pos2 = obj2.getPosition();
        Vector3D pos3 = obj3.getPosition();
        Vector3D pos1b = cs1.activeTransform(pos1);
        Vector3D pos2b = cs2.activeTransform(pos2);
        Vector3D pos3b = cs3.activeTransform(pos3);
        return cLink.computeError(pos1b, pos2b, pos3b);
    }

    protected static double computeTorsionConstraintError(CoordinateSystem cs1, CoordinateSystem cs2, CoordinateSystem cs3, CoordinateSystem cs4, TorsionLink cLink) {
        Object3D obj1 = cLink.getObj1();
        Object3D obj2 = cLink.getObj2();
        Object3D obj3 = cLink.getObj3();
        Object3D obj4 = cLink.getObj4();
        Vector3D pos1 = obj1.getPosition();
        Vector3D pos2 = obj2.getPosition();
        Vector3D pos3 = obj3.getPosition();
        Vector3D pos4 = obj4.getPosition();
        Vector3D pos1b = cs1.activeTransform(pos1);
        Vector3D pos2b = cs2.activeTransform(pos2);
        Vector3D pos3b = cs3.activeTransform(pos3);
        Vector3D pos4b = cs4.activeTransform(pos4);
        return Math.toDegrees(cLink.computeError(pos1b, pos2b, pos3b, pos4b));
    }

    protected double computeBasePairError(CoordinateSystem cs1, CoordinateSystem cs2, InteractionLink basepairConstraint) throws RnaModelException {
        Nucleotide3D n1 = (Nucleotide3D)basepairConstraint.getObj1();
        Nucleotide3D n2 = (Nucleotide3D)basepairConstraint.getObj2();
        log.fine("Starting computeBasePairError for " + n1.getFullName() + " " + n2.getFullName());
        LetterSymbol symbol1 = n1.getSymbol();
        LetterSymbol symbol2 = n2.getSymbol();
        RnaInteractionType interactionType = (RnaInteractionType)basepairConstraint.getInteraction().getInteractionType();
        boolean interactionFound = false;
        double bestError = 1.0E30;
        for (int i = 0; i < this.basePairDB.size(); ++i) {
            InteractionLink link = (InteractionLink)this.basePairDB.get(i);
            Nucleotide3D refN1 = (Nucleotide3D)link.getObj1();
            Nucleotide3D refN2 = (Nucleotide3D)link.getObj2();
            LetterSymbol s1 = refN1.getSymbol();
            LetterSymbol s2 = refN2.getSymbol();
            RnaInteractionType dbInteraction = (RnaInteractionType)link.getInteraction().getInteractionType();
            if (dbInteraction.getSubTypeId() != interactionType.getSubTypeId()) continue;
            double error = 1.0E30;
            if (s1.getCharacter() == symbol1.getCharacter() && s2.getCharacter() == symbol2.getCharacter()) {
                interactionFound = true;
                error = BasepairOptimizer.computeBasePairError(cs1, cs2, n1, n2, refN1, refN2);
                assert (error > 0.0);
            } else if (s1.getCharacter() == symbol2.getCharacter() && s2.getCharacter() == symbol1.getCharacter()) {
                interactionFound = true;
                error = BasepairOptimizer.computeBasePairError(cs1, cs2, n1, n2, refN2, refN1);
                assert (error > 0.0);
            }
            if (!(error < bestError)) continue;
            bestError = error;
            break;
        }
        if (!interactionFound) {
            throw new RnaModelException("Could not find " + interactionType + " " + symbol1 + " " + symbol2 + " in base pair database!");
        }
        log.fine("Finished computeBasePairError for " + n1.getFullName() + " " + n2.getFullName() + " with score: " + bestError);
        assert (bestError > 0.0);
        return bestError;
    }

    private double scoreBasepairConstraint(InteractionLink basepairConstraint, List<CoordinateSystem> coordinateSystems) throws RnaModelException {
        Nucleotide3D n1 = (Nucleotide3D)basepairConstraint.getObj1();
        Nucleotide3D n2 = (Nucleotide3D)basepairConstraint.getObj2();
        int g1 = this.findObjectGroupId(n1);
        int g2 = this.findObjectGroupId(n2);
        if (g1 < 0) {
            throw new RnaModelException("Nucleotide " + n1.getFullName() + " is not part of movable block! Use option blocks=subtree1;subtree2...");
        }
        if (g2 < 0) {
            throw new RnaModelException("Nucleotide " + n2.getFullName() + " is not part of movable block! Use option blocks=subtree1;subtree2...");
        }
        assert (g1 >= 0);
        assert (g2 >= 0);
        assert (n1 != n2);
        assert (coordinateSystems.get(g1).isValid());
        assert (coordinateSystems.get(g2).isValid());
        double result = this.computeBasePairError(coordinateSystems.get(g1), coordinateSystems.get(g2), basepairConstraint);
        assert (!Double.isNaN(result));
        assert (!Double.isInfinite(result));
        if (result > 0.0) {
            int n = g1;
            this.coordScoreAveragesTmp[n] = this.coordScoreAveragesTmp[n] * result;
            int n3 = g2;
            this.coordScoreAveragesTmp[n3] = this.coordScoreAveragesTmp[n3] * result;
            assert (DoubleTools.isValidAndPositive(this.coordScoreAveragesTmp[g1]));
            assert (DoubleTools.isValidAndPositive(this.coordScoreAveragesTmp[g2]));
        } else {
            log.finest("Zero constraint score between " + result + " " + n1.getFullName() + " and " + n2.getFullName());
        }
        return result;
    }

    private double scoreDistanceConstraint(ConstraintLink cLink, List<CoordinateSystem> coordinateSystems) throws RnaModelException {
        Object3D n1 = cLink.getObj1();
        Object3D n2 = cLink.getObj2();
        int g1 = this.findObjectGroupId(n1);
        int g2 = this.findObjectGroupId(n2);
        if (g1 < 0) {
            throw new RnaModelException("Nucleotide " + n1.getFullName() + " is not part of movable block! Use option blocks=subtree1;subtree2...");
        }
        if (g2 < 0) {
            throw new RnaModelException("Nucleotide " + n2.getFullName() + " is not part of movable block! Use option blocks=subtree1;subtree2...");
        }
        assert (g1 >= 0);
        assert (g2 >= 0);
        assert (n1 != n2);
        assert (coordinateSystems.get(g1).isValid());
        assert (coordinateSystems.get(g2).isValid());
        double result = BasepairOptimizer.computeDistanceConstraintError(coordinateSystems.get(g1), coordinateSystems.get(g2), cLink);
        assert (!Double.isNaN(result));
        assert (!Double.isInfinite(result));
        if (result > 0.0) {
            int n = g1;
            this.coordScoreAveragesTmp[n] = this.coordScoreAveragesTmp[n] * result;
            int n3 = g2;
            this.coordScoreAveragesTmp[n3] = this.coordScoreAveragesTmp[n3] * result;
            assert (DoubleTools.isValidAndPositive(this.coordScoreAveragesTmp[g1]));
            assert (DoubleTools.isValidAndPositive(this.coordScoreAveragesTmp[g2]));
        } else {
            log.finest("Zero constraint score between " + result + " " + n1.getFullName() + " and " + n2.getFullName());
        }
        return result;
    }

    private double scoreAngleConstraint(AngleLink cLink, List<CoordinateSystem> coordinateSystems) throws RnaModelException {
        Object3D n1 = cLink.getObj1();
        Object3D n2 = cLink.getObj2();
        Object3D n3 = cLink.getObj3();
        int g1 = this.findObjectGroupId(n1);
        int g2 = this.findObjectGroupId(n2);
        int g3 = this.findObjectGroupId(n3);
        if (g1 < 0) {
            throw new RnaModelException("Nucleotide " + n1.getFullName() + " is not part of movable block! Use option blocks=subtree1;subtree2...");
        }
        if (g2 < 0) {
            throw new RnaModelException("Nucleotide " + n2.getFullName() + " is not part of movable block! Use option blocks=subtree1;subtree2...");
        }
        if (g3 < 0) {
            throw new RnaModelException("Nucleotide " + n3.getFullName() + " is not part of movable block! Use option blocks=subtree1;subtree2...");
        }
        assert (g1 >= 0);
        assert (g2 >= 0);
        assert (g3 >= 0);
        assert (n1 != n2);
        assert (n1 != n3);
        assert (coordinateSystems.get(g1).isValid());
        assert (coordinateSystems.get(g2).isValid());
        assert (coordinateSystems.get(g3).isValid());
        double result = BasepairOptimizer.computeAngleConstraintError(coordinateSystems.get(g1), coordinateSystems.get(g2), coordinateSystems.get(g3), cLink);
        assert (!Double.isNaN(result));
        assert (!Double.isInfinite(result));
        return result;
    }

    private double scoreTorsionConstraint(TorsionLink cLink, List<CoordinateSystem> coordinateSystems) throws RnaModelException {
        Object3D n1 = cLink.getObj1();
        Object3D n2 = cLink.getObj2();
        Object3D n3 = cLink.getObj3();
        Object3D n4 = cLink.getObj4();
        int g1 = this.findObjectGroupId(n1);
        int g2 = this.findObjectGroupId(n2);
        int g3 = this.findObjectGroupId(n3);
        int g4 = this.findObjectGroupId(n4);
        if (g1 < 0) {
            throw new RnaModelException("Nucleotide " + n1.getFullName() + " is not part of movable block! Use option blocks=subtree1;subtree2...");
        }
        if (g2 < 0) {
            throw new RnaModelException("Nucleotide " + n2.getFullName() + " is not part of movable block! Use option blocks=subtree1;subtree2...");
        }
        if (g3 < 0) {
            throw new RnaModelException("Nucleotide " + n3.getFullName() + " is not part of movable block! Use option blocks=subtree1;subtree2...");
        }
        if (g4 < 0) {
            throw new RnaModelException("Nucleotide " + n4.getFullName() + " is not part of movable block! Use option blocks=subtree1;subtree2...");
        }
        assert (g1 >= 0);
        assert (g2 >= 0);
        assert (g3 >= 0);
        assert (g4 >= 0);
        assert (n1 != n2);
        assert (n1 != n3);
        assert (n1 != n4);
        assert (coordinateSystems.get(g1).isValid());
        assert (coordinateSystems.get(g2).isValid());
        assert (coordinateSystems.get(g3).isValid());
        assert (coordinateSystems.get(g4).isValid());
        double result = BasepairOptimizer.computeTorsionConstraintError(coordinateSystems.get(g1), coordinateSystems.get(g2), coordinateSystems.get(g3), coordinateSystems.get(g4), cLink);
        assert (!Double.isNaN(result));
        assert (!Double.isInfinite(result));
        return result;
    }

    private double scoreJunctionConstraint(JunctionMultiConstraintLink cLink, List<CoordinateSystem> coordinateSystems) throws RnaModelException {
        ArrayList<CoordinateSystem> csUsed = new ArrayList<CoordinateSystem>();
        for (int i = 0; i < cLink.getBranchCount(); ++i) {
            CoordinateSystem3D cs;
            Object3D obj = cLink.getThreePrimeObject(i);
            int g = this.findObjectGroupId(obj);
            if (g < 0) {
                throw new RnaModelException("Nucleotide " + obj.getFullName() + " is not part of movable block! Use option blocks=subtree1;subtree2...");
            }
            CoordinateSystem3D csClone = cs = (CoordinateSystem3D)coordinateSystems.get(g);
            if (cLink.getSymId(i) > 0) {
                csClone = (CoordinateSystem3D)cs.cloneDeep();
                assert (cLink.getSymId(i) < symCopies.size());
                csClone.activeTransform((CoordinateSystem)symCopies.get(cLink.getSymId(i)));
            }
            csUsed.add(csClone);
        }
        assert (csUsed.size() == cLink.getBranchCount());
        double result = cLink.getDiff(csUsed);
        assert (!Double.isNaN(result));
        assert (!Double.isInfinite(result));
        return result;
    }

    private Properties scoreJunctionDBConstraint(JunctionDBConstraintLink cLink, List<CoordinateSystem> coordinateSystems) throws RnaModelException {
        ArrayList<CoordinateSystem> csUsed = new ArrayList<CoordinateSystem>();
        for (int i = 0; i < cLink.getBranchCount(); ++i) {
            CoordinateSystem3D cs;
            BranchDescriptor3D obj = cLink.getBranch(i);
            int g = this.findObjectGroupId(obj);
            if (g < 0) {
                throw new RnaModelException("Nucleotide " + obj.getFullName() + " is not part of movable block! Use option blocks=subtree1;subtree2...");
            }
            CoordinateSystem3D csClone = cs = (CoordinateSystem3D)coordinateSystems.get(g);
            if (cLink.getSymId(i) > 0) {
                csClone = (CoordinateSystem3D)cs.cloneDeep();
                csClone.activeTransform((CoordinateSystem)symCopies.get(cLink.getSymId(i)));
            }
            csUsed.add(csClone);
        }
        assert (csUsed.size() == cLink.getBranchCount());
        Properties properties = new Properties();
        properties = cLink.computeScore(csUsed);
        assert (properties != null);
        return properties;
    }

    private double computeElectrostaticTerm(double residueDistance) {
        if (this.electrostaticWeight == 0.0) {
            return 0.0;
        }
        if (residueDistance < this.electrostaticLength) {
            return this.electrostaticWeight * Math.exp(-(residueDistance * residueDistance) / (this.electrostaticLength * this.electrostaticLength));
        }
        return this.electrostaticWeight * Math.exp(-1.0) * this.electrostaticLength / residueDistance;
    }

    private double computeVdwTerm(double residueDistance) {
        if (this.vdwWeight == 0.0 || residueDistance > 5.0 * this.vdwLength) {
            return 0.0;
        }
        return this.vdwWeight * Math.exp(-(residueDistance * residueDistance) / (this.vdwLength * this.vdwLength));
    }

    private double computeVdwTerm2(double residueDistance) {
        if (this.vdwWeight2 == 0.0 || residueDistance > 5.0 * this.vdwLength2) {
            return 0.0;
        }
        return this.vdwWeight2 * Math.exp(-(residueDistance * residueDistance) / (this.vdwLength2 * this.vdwLength2));
    }

    public void setFixedRotationAxis(List<Vector3D> _axisList) {
        this.axisList = _axisList;
    }

    private double scoreRepulsion(List<CoordinateSystem> coordinateSystems) {
        this.updateObjectResidueBlocks(coordinateSystems);
        double result = 0.0;
        int scn = this.symVdwActive.length;
        int blockOff = 1;
        double dist = 0.0;
        if (scn > 1) {
            blockOff = 0;
        }
        for (int block = 0; block < this.objectResidueBlocksCurr.length; ++block) {
            for (int block2 = block + blockOff; block2 < this.objectResidueBlocksCurr.length; ++block2) {
                for (int res1 = 0; res1 < this.objectResidueBlocksCurr[block].length; res1 += this.electroStride) {
                    for (int res2 = 0; res2 < this.objectResidueBlocksCurr[block2].length; res2 += this.electroStride) {
                        if (symCopies.size() < 2) {
                            dist = this.objectResidueBlocksCurr[block][res1].distance(this.objectResidueBlocksCurr[block2][res2]);
                            result += this.computeElectrostaticTerm(dist);
                            result += this.computeVdwTerm(dist);
                            continue;
                        }
                        for (int sc1 = 0; sc1 < scn; ++sc1) {
                            Vector3D v1 = this.objectResidueBlocksCurr[block][res1];
                            if (sc1 > 0) {
                                assert (this.symVdwActive[sc1] < symCopies.size());
                                v1 = ((CoordinateSystem)symCopies.get(this.symVdwActive[sc1])).activeTransform(v1);
                            }
                            for (int sc2 = 0; sc2 < scn; ++sc2) {
                                if (block == block2 && sc1 == sc2) continue;
                                Vector3D v2 = this.objectResidueBlocksCurr[block2][res2];
                                if (sc2 > 0) {
                                    v2 = ((CoordinateSystem)symCopies.get(this.symVdwActive[sc2])).activeTransform(v2);
                                }
                                dist = v1.distance(v2);
                                result += this.computeElectrostaticTerm(dist);
                                result += this.computeVdwTerm(dist);
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    private void initObjectResidueBlocks() {
        assert (this.objectBlocks.size() > 0);
        this.objectResidueBlocksOrig = new Vector3D[this.objectBlocks.size()][];
        this.objectResidueBlocksCurr = new Vector3D[this.objectBlocks.size()][];
        for (int block = 0; block < this.objectBlocks.size(); ++block) {
            SimpleObject3DSet blockResidues = new SimpleObject3DSet();
            for (int blockItem = 0; blockItem < this.objectBlocks.get(block).size(); ++blockItem) {
                blockResidues.merge(Object3DTools.collectByClassName(this.objectBlocks.get(block).get(blockItem), "Nucleotide3D"));
            }
            assert (this.objectResidueBlocksOrig != null);
            assert (block < this.objectResidueBlocksOrig.length);
            assert (blockResidues != null);
            assert (blockResidues.size() > 0);
            this.objectResidueBlocksOrig[block] = new Vector3D[blockResidues.size()];
            this.objectResidueBlocksCurr[block] = new Vector3D[blockResidues.size()];
            for (int res = 0; res < blockResidues.size(); ++res) {
                assert (this.objectResidueBlocksOrig != null);
                assert (block < this.objectResidueBlocksOrig.length);
                assert (res < this.objectResidueBlocksOrig[block].length);
                assert (res < blockResidues.size());
                assert (blockResidues.get(res) != null);
                if (blockResidues.get(res).getChild(this.refAtomName) == null) {
                    System.out.println("Error while initializing base pair constraint optimization: a residue did not have an atom of type " + this.refAtomName);
                    System.exit(1);
                }
                this.objectResidueBlocksOrig[block][res] = blockResidues.get(res).getChild(this.refAtomName).getPosition();
                this.objectResidueBlocksCurr[block][res] = new Vector3D(this.objectResidueBlocksOrig[block][res]);
            }
        }
        assert (this.objectResidueBlocksOrig.length == this.objectBlocks.size());
    }

    private void updateObjectResidueBlocks(List<CoordinateSystem> coordinateSystems) {
        assert (this.objectResidueBlocksOrig.length == coordinateSystems.size());
        for (int block = 0; block < this.objectResidueBlocksOrig.length; ++block) {
            if (this.chosen >= 0 && block != this.chosen) continue;
            for (int res = 0; res < this.objectResidueBlocksOrig[block].length; ++res) {
                this.objectResidueBlocksCurr[block][res] = coordinateSystems.get(block).activeTransform(this.objectResidueBlocksOrig[block][res]);
            }
        }
    }

    protected double scoreCoordinateSystems(List<CoordinateSystem> coordinateSystems, Properties properties) throws RnaModelException {
        double term;
        double score = 0.0;
        this.resetCoordScoreAverages();
        for (InteractionLink interactionLink : this.basepairConstraints) {
            term = this.scoreBasepairConstraint(interactionLink, coordinateSystems);
            if (term > 0.0) {
                log.info("Added interactionLink score term " + term + " " + term * term);
            }
            score += term * term;
        }
        for (ConstraintLink constraintLink : this.distanceConstraints) {
            term = this.scoreDistanceConstraint(constraintLink, coordinateSystems);
            if (term > 0.0 && this.verboseLevel > 2) {
                log.info("Added distanceConstraintLink score term " + term + " " + term * term);
            }
            score += term * term;
        }
        for (AngleLink angleLink : this.angleConstraints) {
            term = this.scoreAngleConstraint(angleLink, coordinateSystems);
            if (term > 0.0 && this.verboseLevel > 2) {
                log.info("Added angleLink score term " + term + " " + term * term);
            }
            score += term * term;
        }
        for (TorsionLink torsionLink : this.torsionConstraints) {
            term = this.scoreTorsionConstraint(torsionLink, coordinateSystems);
            if (term > 0.0 && this.verboseLevel > 2) {
                log.info("Added torsionLink score term " + term + " " + term * term);
            }
            score += term * term;
        }
        for (JunctionMultiConstraintLink junctionMultiConstraintLink : this.junctionConstraints) {
            term = this.scoreJunctionConstraint(junctionMultiConstraintLink, coordinateSystems);
            if (term > 0.0 && this.verboseLevel > 2) {
                log.info("Added junctionMultiLink score term " + term + " " + term * term);
            }
            score += term * term;
        }
        for (JunctionDBConstraintLink junctionDBConstraintLink : this.junctionDBConstraints) {
            Properties props = this.scoreJunctionDBConstraint(junctionDBConstraintLink, coordinateSystems);
            double term2 = Double.parseDouble(props.getProperty("score"));
            if (properties != null) {
                PropertyTools.mergeProperties(properties, props, junctionDBConstraintLink.getName() + ".");
            }
            if (term2 > 0.0 && this.verboseLevel > 2) {
                log.info("Added junctionDBConstraintLink score term " + term2 + " " + term2 * term2);
            }
            score += term2 * term2;
        }
        if (this.electrostaticWeight != 0.0 || this.vdwWeight != 0.0) {
            double repTerm = this.scoreRepulsion(coordinateSystems);
            if (repTerm > 0.0 && this.verboseLevel > 2) {
                log.info("Added electrostatic repulsion score term " + repTerm);
            }
            score += repTerm;
        }
        for (int i = 0; i < this.coordScoreAverages.length; ++i) {
            if (this.groupConstraintCounts[i] <= 0) {
                this.coordScoreAverages[i] = 1.0;
                continue;
            }
            assert (this.groupConstraintCounts[i] > 0);
            this.coordScoreAveragesTmp[i] = Math.pow(this.coordScoreAveragesTmp[i], 1.0 / (double)this.groupConstraintCounts[i]);
            assert (DoubleTools.isValidAndPositive(this.coordScoreAveragesTmp[i]));
            this.coordScoreAverages[i] = this.coordScoreAveragesTmp[i];
        }
        this.firstPass = false;
        if (this.verboseLevel > 1) {
            log.info("Current score of coordinate systems: " + score);
        }
        return score;
    }

    private Object3DSet convertToObject3DSet(List<Object3D> objects) {
        SimpleObject3DSet result = new SimpleObject3DSet();
        for (int i = 0; i < objects.size(); ++i) {
            result.add(objects.get(i));
        }
        return result;
    }

    protected List<CoordinateSystem> cloneCoordinateSystems(List<CoordinateSystem> coords) {
        ArrayList<CoordinateSystem> result = new ArrayList<CoordinateSystem>();
        for (int i = 0; i < coords.size(); ++i) {
            CoordinateSystem3D csClone = (CoordinateSystem3D)coords.get(i).cloneDeep();
            assert (csClone.size() == ((CoordinateSystem3D)coords.get(i)).size());
            assert (csClone.size() == 3);
            result.add(csClone);
        }
        return result;
    }

    protected void copyCoordinateSystems(List<CoordinateSystem> optCoords, List<CoordinateSystem> origCoords) {
        assert (optCoords != null);
        assert (origCoords != null);
        assert (optCoords.size() == origCoords.size());
        for (int i = 0; i < origCoords.size(); ++i) {
            CoordinateSystem3D cs = (CoordinateSystem3D)optCoords.get(i);
            optCoords.get(i).copy(origCoords.get(i));
        }
    }

    private int countGroupConstraints(int n) {
        Object3D obj;
        Object3D obj2;
        Object3D obj1;
        int i;
        int count = 0;
        for (i = 0; i < this.basepairConstraints.size(); ++i) {
            obj1 = this.basepairConstraints.get(i).getObj1();
            obj2 = this.basepairConstraints.get(i).getObj2();
            if (this.findObjectGroupId(obj1) != n && this.findObjectGroupId(obj2) != n) continue;
            ++count;
        }
        for (i = 0; i < this.distanceConstraints.size(); ++i) {
            obj1 = this.distanceConstraints.get(i).getObj1();
            obj2 = this.distanceConstraints.get(i).getObj2();
            if (this.findObjectGroupId(obj1) != n && this.findObjectGroupId(obj2) != n) continue;
            ++count;
        }
        for (i = 0; i < this.distanceConstraints.size(); ++i) {
            obj1 = this.distanceConstraints.get(i).getObj1();
            obj2 = this.distanceConstraints.get(i).getObj2();
            if (this.findObjectGroupId(obj1) != n && this.findObjectGroupId(obj2) != n) continue;
            ++count;
        }
        block3: for (i = 0; i < this.junctionConstraints.size(); ++i) {
            for (int j = 0; j < this.junctionConstraints.get(i).size(); ++j) {
                obj = this.junctionConstraints.get(i).getObj(j);
                if (this.findObjectGroupId(obj) != n) continue;
                ++count;
                continue block3;
            }
        }
        block5: for (i = 0; i < this.junctionDBConstraints.size(); ++i) {
            for (int j = 0; j < this.junctionDBConstraints.get(i).size(); ++j) {
                obj = this.junctionDBConstraints.get(i).getObj(j);
                if (this.findObjectGroupId(obj) != n) continue;
                ++count;
                continue block5;
            }
        }
        return count;
    }

    private void mutateCoordinateSystems(List<CoordinateSystem> coords, double annealingMult) {
        assert (coords != null);
        assert (!Double.isInfinite(annealingMult));
        assert (!Double.isNaN(annealingMult));
        boolean startId = false;
        if (this.keepFirstFixedMode) {
            startId = true;
        }
        this.assertMovables();
        this.mutator.copy(this.mutatorOrig);
        double totalScale = annealingMult;
        assert (DoubleTools.isReasonable(totalScale));
        log.fine("Initial scale for mutator: " + totalScale + " " + annealingMult + " " + this.scaleMult);
        if (totalScale > this.scaleLimit) {
            totalScale = this.scaleLimit;
        }
        assert (!Double.isInfinite(totalScale));
        assert (!Double.isNaN(totalScale));
        this.mutator.scaleAngleStep(totalScale);
        this.mutator.scaleTranslationStep(totalScale);
        Random rand = Randomizer.getInstance();
        do {
            this.chosen = rand.nextInt(coords.size());
        } while (!this.moveFlags[this.chosen]);
        if (this.axisList != null) {
            this.mutator.setFixedAxis(this.axisList.get(this.chosen));
        }
        this.mutator.mutate(coords.get(this.chosen));
        this.assertMovables();
    }

    private void printCoordinateSystems(PrintStream ps, List<CoordinateSystem> coords) {
        for (int i = 0; i < coords.size(); ++i) {
            ps.println("" + (i + 1) + " " + coords.get(i).toString());
        }
    }

    private boolean hasComplexGroups() {
        return true;
    }

    private String boolFlagString(boolean[] flags) {
        String s = "";
        for (int i = 0; i < flags.length; ++i) {
            s = s + flags[i] + " ";
        }
        return s;
    }

    public double getScoreMinimumLimit() {
        return this.scoreMinimumLimit;
    }

    public void setKeepFirstFixedMode(boolean flag) {
        this.keepFirstFixedMode = flag;
    }

    public void setScoreMinimumLimit(double x) {
        this.scoreMinimumLimit = x;
    }

    @Override
    public Properties optimize() {
        assert (this.basepairConstraints != null);
        assert (this.torsionConstraints != null);
        assert (this.distanceConstraints != null);
        assert (this.optCoordinateSystems != null);
        log.info("Starting optimization! Base pair constraints: " + this.basepairConstraints.size() + " distance constraints: " + this.distanceConstraints.size() + " angle constraints: " + this.angleConstraints.size() + " torsion constraints: " + this.torsionConstraints.size() + " junction constraints: " + this.junctionConstraints.size() + " junction DB constraints: " + this.junctionDBConstraints.size() + " number of blocks: " + this.optCoordinateSystems.size() + " number of defined symmetry operations: " + symCopies.size());
        log.info("Weight of repulsion term: " + this.electrostaticWeight + " kT: " + this.ktOrig);
        Properties properties = new Properties();
        this.chosen = -1;
        try {
            double bestScore2;
            Random rand = Randomizer.getInstance();
            if (this.optCoordinateSystems == null || this.optCoordinateSystems.size() == 0) {
                String errMsg = "No coordinate systems defined for optimization. Maybe add helix constraints?";
                log.info(errMsg);
                properties.setProperty("message", errMsg);
                return properties;
            }
            log.info("Number of relevant coordinate systems: " + this.origCoordinateSystems.size());
            log.info("Movable coordinate systems: " + this.boolFlagString(this.moveFlags));
            String s2 = "";
            this.firstPass = true;
            this.copyCoordinateSystems(this.optCoordinateSystems, this.origCoordinateSystems);
            List<CoordinateSystem> saveCoords = this.cloneCoordinateSystems(this.optCoordinateSystems);
            List<CoordinateSystem> bestCoords = this.cloneCoordinateSystems(this.optCoordinateSystems);
            double oldScore = this.scoreCoordinateSystems(this.optCoordinateSystems, null);
            this.saveCoordScoreAverages();
            double bestScore = oldScore;
            double kt = this.ktOrig;
            double oldScoreMul = 0.1;
            if (oldScoreMul * oldScore > kt) {
                kt = oldScoreMul * oldScore;
            }
            properties.setProperty("start_score", "" + bestScore);
            int iter = 0;
            this.assertMovables();
            for (iter = 0; iter < this.numberSteps; ++iter) {
                double annealingMult = Math.pow(this.annealingFactor, iter / this.annealingInterval);
                assert (!Double.isNaN(annealingMult));
                kt = this.ktOrig * annealingMult;
                if (iter % this.outputInterval == 0) {
                    String scoreString = "";
                    for (int i = 0; i < this.coordScoreAverages.length; ++i) {
                        scoreString = scoreString + Math.sqrt(this.coordScoreAverages[i]) + " ";
                    }
                    log.info("Iteration: " + iter + " Best score so far: " + bestScore + " . Annealing parameters: " + annealingMult + " , " + kt + " mutator: " + this.mutator.toString());
                }
                this.copyCoordinateSystems(saveCoords, this.optCoordinateSystems);
                this.mutateCoordinateSystems(this.optCoordinateSystems, annealingMult);
                double newScore = this.scoreCoordinateSystems(this.optCoordinateSystems, null);
                if (Math.exp(-((newScore - oldScore) / kt)) > rand.nextDouble()) {
                    oldScore = newScore;
                    this.saveCoordScoreAverages();
                    if (newScore < bestScore) {
                        bestScore = newScore;
                        this.copyCoordinateSystems(bestCoords, this.optCoordinateSystems);
                        if (this.verboseLevel > 0) {
                            log.info("New best score found: " + bestScore + " at iteration " + (iter + 1) + " annealing factor: " + annealingMult + " kt: " + kt);
                        }
                        if (newScore < this.scoreMinimumLimit) {
                            log.info("Quitting optimization, because score is lower than minimum score cutoff: " + this.scoreMinimumLimit);
                            break;
                        }
                    }
                } else {
                    log.fine("Rejecting step : " + newScore + " with so far best score: " + bestScore + " at iteration " + iter);
                    this.copyCoordinateSystems(this.optCoordinateSystems, saveCoords);
                    this.restoreCoordScoreAverages();
                }
                if (newScore < this.errorScoreLimit) {
                    log.info("Optimization goal achieved!");
                    break;
                }
                if (this.hasComplexGroups()) continue;
                log.info("Quitting optimization loop, because all coordinate systems could be placed analytically.");
                break;
            }
            if (Math.abs((bestScore2 = this.scoreCoordinateSystems(bestCoords, properties)) - bestScore) >= 0.01) {
                log.warning("Constraint score not reproducible: " + bestScore2 + " " + bestScore);
            }
            this.applyTransformations(bestCoords);
            properties.setProperty("number_steps", "" + (iter + 1));
            properties.setProperty("final_score", "" + bestScore);
        }
        catch (RnaModelException ex) {
            properties.setProperty("error", ex.getMessage());
        }
        log.info("Optimization finished: " + properties);
        this.assertMovables();
        return properties;
    }

    void outputCoordinateSystems(PrintStream ps, List<CoordinateSystem> coords) {
        ps.println("Coordinate systems: ");
        for (int i = 0; i < coords.size(); ++i) {
            ps.println("" + i + " " + coords.get(i));
        }
    }

    public void setElectrostaticWeight(double value) {
        this.electrostaticWeight = value;
    }

    public void setKT(double value) {
        this.ktOrig = value;
    }

    public void setOutputInterval(int interval) {
        this.outputInterval = interval;
    }

    public void setVdwWeight(double value) {
        this.vdwWeight = value;
    }

    public void setVdwLength(double value) {
        this.vdwLength = value;
    }

    public void setVerboseLevel(int level) {
        this.verboseLevel = level;
    }

    protected void assertMovables() {
        for (int i = 0; i < this.moveFlags.length; ++i) {
            if (this.origCoordinateSystems.get(i) == this.optCoordinateSystems.get(i)) assert (false);
            if (!this.moveFlags[i] && this.origCoordinateSystems.get(i).distance(this.optCoordinateSystems.get(i)) > 0.1) assert (false);
        }
    }
}

