/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.AlgorithmFailureException;
import generaltools.PropertyTools;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import rnadesign.rnamodel.AtomTools;
import rnadesign.rnamodel.BioPolymer;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.DBElementConnectionDescriptor;
import rnadesign.rnamodel.DBElementDescriptor;
import rnadesign.rnamodel.FitParameters;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.GeneralPdbWriter;
import rnadesign.rnamodel.GrowConnectivity;
import rnadesign.rnamodel.HelixOptimizer;
import rnadesign.rnamodel.HelixOptimizerTools;
import rnadesign.rnamodel.JunctionGraph3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.RnaStrandTools;
import rnadesign.rnamodel.SignatureTranslatorCanonizer;
import rnadesign.rnamodel.SimpleHelixConstraintLink;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunctionDB;
import rnadesign.rnamodel.StrandJunctionTools;
import tools3d.AxisAngle;
import tools3d.Matrix3D;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.ForbiddenObject3DTester;
import tools3d.objects3d.GraphWriter;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLink;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import tools3d.objects3d.SimpleObject3DSet;

public class BuildingBlockGrower {
    public boolean forbidRinglessCollisionMode = false;
    public static final double HELIX_INITIAL_SCORE = 1.0E8;
    public static final String ROOT_DEFAULT_NAME = "root";
    private static final String FOUND_AGAIN = "found_again";
    private static final String DB_ELEMENT = "db_element";
    private double atomCollisionDistance = 3.5;
    private int junctionCoreOffset = 2;
    private final StrandJunctionDB junctionDB;
    private final StrandJunctionDB kissingLoopDB;
    private final Object3D nucleotideDB;
    public static final double RING_NOT_CLOSED_SCORE = 1000.0;
    public boolean addStemsFlag = true;
    public static boolean debugMode = false;
    public boolean avoidCollisionsMode = true;
    private boolean firstFixedMode = true;
    private int fuseStrandsMode = 0;
    private double ringClosureExportLimit = 10.0;
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private double stemRmsLimit = 5.0;
    private double stemAngleLimit = Math.PI;
    private JunctionGraph3D targetGraph;
    private Object3D root;
    private LinkSet links;

    public BuildingBlockGrower(StrandJunctionDB junctionDB, StrandJunctionDB kissingLoopDB, Object3D nucleotideDB) {
        this.junctionDB = junctionDB;
        this.kissingLoopDB = kissingLoopDB;
        this.nucleotideDB = nucleotideDB;
        this.init();
    }

    public void clear() {
        this.init();
    }

    public Object3D getRoot() {
        return this.root;
    }

    public void init() {
        this.root = new SimpleObject3D();
        this.root.setName(ROOT_DEFAULT_NAME);
        this.links = new SimpleLinkSet();
    }

    private DBElementDescriptor extractDBElementDescriptor(Object3D obj) {
        String s = obj.getProperty(DB_ELEMENT);
        if (s == null) {
            return null;
        }
        return DBElementDescriptor.parse(s);
    }

    public Object3DLinkSetBundle getBundle() {
        return new SimpleObject3DLinkSetBundle(this.root, this.links);
    }

    public double getStemRmsLimit() {
        return this.stemRmsLimit;
    }

    public JunctionGraph3D getTargetGraph() {
        return this.targetGraph;
    }

    private StrandJunction3D findPlacedJunction(List<List<Object3D>> placedBlocks, DBElementDescriptor dbe) {
        assert (dbe != null);
        String dbes = dbe.toString();
        assert (dbes != null && dbes.length() > 0);
        for (List<Object3D> row : placedBlocks) {
            for (Object3D obj : row) {
                if (!(obj instanceof StrandJunction3D) || !dbes.equals(obj.getProperty(DB_ELEMENT))) continue;
                return (StrandJunction3D)obj;
            }
        }
        return null;
    }

    public StrandJunction3D placeKissingLoop(DBElementDescriptor dbe, String rootName, String newName, Vector3D position, String strandEnding, List<List<Object3D>> placedBlocks, boolean graphFlag) throws FittingException {
        assert (dbe != null);
        int n = dbe.getId();
        StrandJunction3D dbJunction = this.kissingLoopDB.getJunction(dbe.getOrder(), n);
        if (dbJunction == null) {
            throw new FittingException("No junction of order " + dbe.getOrder() + " and id " + (n + 1) + " is currently loaded.");
        }
        assert (StrandJunctionTools.isHelixEndFree((Object3D)dbJunction, "(hxend)1"));
        StrandJunction3D junction = null;
        if (graphFlag) {
            junction = this.findPlacedJunction(placedBlocks, dbe);
        }
        if (junction == null) {
            junction = (StrandJunction3D)dbJunction.cloneDeep();
            junction.setPosition(position);
            junction.setName(newName);
            if (strandEnding != null && strandEnding.length() > 0) {
                HashSet<String> allowedNames = new HashSet<String>();
                allowedNames.add("RnaStrand");
                HashSet<String> forbiddenNames = new HashSet<String>();
                Object3DTools.addEnding(junction, strandEnding, allowedNames, forbiddenNames);
            }
            this.root.insertChild(junction);
        } else {
            junction.setProperty(FOUND_AGAIN, "true");
        }
        return junction;
    }

    public StrandJunction3D placeJunction(DBElementDescriptor dbe, String rootName, String newName, Vector3D position, String strandEnding, List<List<Object3D>> placedBlocks, boolean graphFlag) throws FittingException {
        int order = dbe.getOrder();
        int n = dbe.getId();
        StrandJunction3D dbJunction = this.junctionDB.getJunction(dbe.getOrder(), dbe.getId());
        if (dbJunction == null) {
            throw new FittingException("No junction of order " + order + " and id " + (n + 1) + " is currently loaded.");
        }
        assert (StrandJunctionTools.isHelixEndFree((Object3D)dbJunction, "(hxend)1"));
        StrandJunction3D junction = null;
        if (graphFlag) {
            junction = this.findPlacedJunction(placedBlocks, dbe);
        }
        if (junction == null) {
            junction = (StrandJunction3D)dbJunction.cloneDeep();
            junction.setPosition(position);
            junction.setName(newName);
            if (strandEnding != null && strandEnding.length() > 0) {
                HashSet<String> allowedNames = new HashSet<String>();
                allowedNames.add("RnaStrand");
                HashSet<String> forbiddenNames = new HashSet<String>();
                Object3DTools.addEnding(junction, strandEnding, allowedNames, forbiddenNames);
            }
            this.root.insertChild(junction);
        } else {
            junction.setProperty(FOUND_AGAIN, "true");
        }
        return junction;
    }

    public StrandJunction3D placeBuildingBlock(DBElementDescriptor element, String rootName, String newName, Vector3D position, String strandEnding, List<List<Object3D>> placedBlocks, boolean graphFlag) throws FittingException {
        StrandJunction3D result;
        switch (element.getType()) {
            case 1: {
                result = this.placeJunction(element, rootName, newName, position, strandEnding, placedBlocks, graphFlag);
                break;
            }
            case 2: {
                result = this.placeKissingLoop(element, rootName, newName, position, strandEnding, placedBlocks, graphFlag);
                break;
            }
            default: {
                throw new FittingException("placeBuildingBlock: Database type not implemented: " + element);
            }
        }
        assert (result != null);
        result.setProperty(DB_ELEMENT, element.toString());
        return result;
    }

    private boolean hasFreeHelixEnds(List<List<Object3D>> placedBlocks) {
        for (int i = 0; i < placedBlocks.size(); ++i) {
            for (int j = 0; j < placedBlocks.get(i).size(); ++j) {
                if (!StrandJunctionTools.hasFreeHelixEnds(placedBlocks.get(i).get(j))) continue;
                return true;
            }
        }
        return false;
    }

    private CoordinateSystem3D getBuildingBlockCoordinateSystem(Object3D block) {
        Object3D obj = block.getChild("(hxend)1");
        if (obj == null) {
            System.out.println("Problem: cannot find helix end descriptor in object " + block.getName());
            for (int i = 0; i < block.size(); ++i) {
                System.out.println(block.getChild(i).getName() + " " + block.getChild(i).getClassName());
            }
        }
        assert (obj != null);
        assert (obj instanceof BranchDescriptor3D);
        BranchDescriptor3D b = (BranchDescriptor3D)obj;
        return (CoordinateSystem3D)b.getCoordinateSystem();
    }

    private void storeCoordinateSystem(Object3D block, DBElementDescriptor elementDescriptor, List<CoordinateSystem3D> storedOrientations) {
        CoordinateSystem3D cs = this.getBuildingBlockCoordinateSystem(block);
        cs.setProperty(DB_ELEMENT, elementDescriptor.toString());
        storedOrientations.add(cs);
    }

    private double computeRingClosureScore(CoordinateSystem3D cs, DBElementDescriptor dbe, CoordinateSystem3D storedOrientation, double distWeight, double angleWeight) {
        assert (dbe != null);
        assert (cs != null);
        assert (storedOrientation != null);
        String prop = storedOrientation.getProperty(DB_ELEMENT);
        assert (prop != null);
        if (!dbe.equals(DBElementDescriptor.parse(prop))) {
            return 1000.0;
        }
        double dist = cs.distance(storedOrientation);
        CoordinateSystem3D storedClone = (CoordinateSystem3D)storedOrientation.cloneDeep();
        storedClone.passiveTransform3(cs);
        double angle = AxisAngle.toAxisAngle(new Matrix3D(storedClone.generateMatrix4D())).getAngle();
        double score = distWeight * dist + angleWeight * angle;
        if (score > 1000.0) {
            score = 1000.0;
        }
        return score;
    }

    private int findRingClosureIndex(Object3D block, DBElementDescriptor dbe, List<CoordinateSystem3D> storedOrientations, double distWeight, double angleWeight) {
        double bestScore = 1000.0;
        CoordinateSystem3D cs = this.getBuildingBlockCoordinateSystem(block);
        int bestId = -1;
        for (int i = 0; i < storedOrientations.size(); ++i) {
            double score = this.computeRingClosureScore(cs, dbe, storedOrientations.get(i), distWeight, angleWeight);
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestId = i;
        }
        return bestId;
    }

    private void exportPdb(String fileName) throws IOException {
        if (!fileName.endsWith(".pdb")) {
            fileName = fileName + ".pdb";
        }
        FileOutputStream fos = new FileOutputStream(fileName);
        boolean format = false;
        GeneralPdbWriter writer = new GeneralPdbWriter();
        writer.write((OutputStream)fos, this.root);
        fos.close();
    }

    private void exportPdbNoHelices(String fileName) throws IOException {
        if (!fileName.endsWith(".pdb")) {
            fileName = fileName + ".pdb";
        }
        Object3DSet helixStrands = RnaStrandTools.findPureHelicalStrands(this.root, this.links);
        log.info("Writing PDB structure to file " + fileName + " excluding " + helixStrands.size() + " helical strands.");
        ForbiddenObject3DTester forbiddenStrandTester = new ForbiddenObject3DTester(helixStrands.getAsList());
        FileOutputStream fos = new FileOutputStream(fileName);
        boolean format = false;
        GeneralPdbWriter writer = new GeneralPdbWriter();
        writer.setObjectTester(forbiddenStrandTester);
        writer.write((OutputStream)fos, this.root);
        fos.close();
    }

    void printBuildStatus(PrintStream ps, List<List<Object3D>> placedBlocks) {
        for (int i = 0; i < placedBlocks.size(); ++i) {
            ps.print("Generation " + (i + 1) + " ");
            for (int j = 0; j < placedBlocks.get(i).size(); ++j) {
                ps.print(placedBlocks.get(i).get(j).getFullName() + " : " + placedBlocks.get(i).get(j).getProperties());
            }
            ps.println();
        }
    }

    private Object3DSet extractCoreAtoms(BioPolymer strand, int offset) {
        assert (strand != null);
        assert (offset >= 0);
        SimpleObject3DSet result = new SimpleObject3DSet();
        int i = offset;
        while (i + offset < strand.getResidueCount()) {
            result.merge(Object3DTools.collectByClassName(strand.getResidue3D(i), "Atom3D"));
            ++i;
        }
        return result;
    }

    private Object3DSet extractCoreAtoms(StrandJunction3D junction, int offset) {
        assert (junction != null);
        assert (offset >= 0);
        SimpleObject3DSet result = new SimpleObject3DSet();
        for (int i = 0; i < junction.getStrandCount(); ++i) {
            result.merge(this.extractCoreAtoms(junction.getStrand(i), offset));
        }
        assert (result != null);
        return result;
    }

    private Object3DSet extractStrandCoreAtoms(Object3D obj, int offset) {
        assert (obj != null);
        assert (offset >= 0);
        Object3DSet strands = Object3DTools.collectByClassName(obj, "RnaStrand");
        assert (strands.size() > 0);
        SimpleObject3DSet result = new SimpleObject3DSet();
        for (int i = 0; i < strands.size(); ++i) {
            result.merge(this.extractCoreAtoms((RnaStrand)strands.get(i), offset));
        }
        assert (result != null);
        return result;
    }

    String[] findNewElements(String[] words1, String[] words2) {
        if (words1 == null || words1.length == 0) {
            return words2;
        }
        int lenDiff = words2.length - words1.length;
        String[] result = new String[lenDiff];
        for (int i = words1.length; i < words2.length; ++i) {
            result[i - words1.length] = words2[i];
        }
        return result;
    }

    private int countExternalCollisions(Object3DSet newAtoms, Object3D newBlock, Object3D root, Object3DSet avoidSet, double atomCollisionDistance) {
        int result = AtomTools.countExternalCollisions(newAtoms, newBlock, root, avoidSet, atomCollisionDistance);
        log.fine("Counting collisions between " + newAtoms.size() + " and " + Object3DTools.collectByClassName(root, "Atom3D").size() + " atoms: " + result);
        return result;
    }

    private Object3DSet growBuildingBlock(Object3D placedBlock, List<List<Object3D>> placedBlocks, List<DBElementDescriptor> blockList, List<DBElementConnectionDescriptor> connections, List<CoordinateSystem3D> storedOrientations, String rootName, String nameBase, int blockCounter, String exportPdbFileNameBase, Object3DSet tabooSet, int delayStage, boolean graphFlag) throws FittingException {
        assert (placedBlock != null);
        log.fine("Starting growBuildingBlock core with " + connections.size() + " connections, rootname " + rootName + " name base " + nameBase + " graph=" + graphFlag + " ; so far placed generations: " + placedBlocks.size() + " using placed block: " + placedBlock.getFullName() + " blockCounter=" + blockCounter + " delay=" + delayStage);
        if (debugMode) {
            this.printBuildStatus(System.out, placedBlocks);
        }
        if (blockList.size() == 0) {
            throw new FittingException("No building blocks defined!");
        }
        int collisionCountTot = 0;
        double ringDistWeight = 1.0;
        double ringAngleWeight = 0.5 * Math.toDegrees(1.0);
        SimpleObject3DSet result = new SimpleObject3DSet();
        String helixPrefix = "h_";
        DBElementDescriptor element = this.extractDBElementDescriptor(placedBlock);
        assert (element != null);
        log.fine("Descriptor of placed block: " + element + " Properties: " + placedBlock.getProperties());
        int ringlessCollision = 0;
        FitParameters stemFitParameters = null;
        double bestRingClosureScore = 1000.0;
        int ringCounter = 0;
        if (this.addStemsFlag) {
            stemFitParameters = new FitParameters(this.stemRmsLimit, this.stemAngleLimit);
        }
        assert (element != null);
        for (int i = 0; i < connections.size(); ++i) {
            StrandJunction3D ringJunction;
            CoordinateSystem3D csRing;
            double ringClosureScore;
            int ringCsIndex;
            boolean ringClosedFlag;
            int collisionCountTmp;
            Object3DSet helixAtomCore;
            HashSet<String> forbiddenNames;
            Object3D addedHelix;
            String helixFullName;
            int collisionCount;
            Properties optProperties;
            SimpleHelixConstraintLink constraintLink;
            double rms;
            BranchDescriptor3D bd2;
            Object3D b2;
            String helixendNameNew;
            BranchDescriptor3D bd1;
            Object3D b1;
            StrandJunction3D newBlock;
            String helixendNamePlaced;
            String name;
            String ending;
            if (connections.get(i).getDelayStage() > delayStage) {
                log.fine("Delaying connection " + (i + 1) + " : " + connections.get(i));
                continue;
            }
            log.fine("Testing connection " + (i + 1) + " : " + connections.get(i));
            if (connections.get(i).getDescriptor1().equals(element)) {
                log.fine("" + (i + 1) + " Found hit for first descriptor of connection: " + connections.get(i));
                ending = "b" + (blockCounter + 1);
                name = nameBase + "_" + ending;
                helixendNamePlaced = connections.get(i).getHelixendName1();
                if (StrandJunctionTools.isHelixEndFree(placedBlock, helixendNamePlaced)) {
                    newBlock = this.placeBuildingBlock(connections.get(i).getDescriptor2(), rootName, name, Vector3D.ZVEC, "_" + ending, placedBlocks, graphFlag);
                    assert (newBlock != null);
                    b1 = placedBlock.getChild(helixendNamePlaced);
                    if (b1 == null || !(b1 instanceof BranchDescriptor3D)) {
                        throw new FittingException("Illegal helix end descriptor name: " + connections.get(i).getHelixendName1());
                    }
                    bd1 = (BranchDescriptor3D)b1;
                    helixendNameNew = connections.get(i).getHelixendName2();
                    if (!StrandJunctionTools.isHelixEndFree((Object3D)newBlock, helixendNameNew)) {
                        throw new FittingException("Strange error in building block grower: helix of building block was unexpectantly occupied! Check graph definition: " + newBlock.getFullName());
                    }
                    b2 = newBlock.getChild(helixendNameNew);
                    if (b2 == null || !(b2 instanceof BranchDescriptor3D)) {
                        throw new FittingException("Illegal helix end descriptor name: " + connections.get(i).getHelixendName2());
                    }
                    bd2 = (BranchDescriptor3D)b2;
                    rms = 1.0;
                    constraintLink = new SimpleHelixConstraintLink(bd1, bd2, connections.get(i).getBasePairCount(), connections.get(i).getBasePairCount(), rms);
                    optProperties = new Properties();
                    if (!"true".equals(newBlock.getProperty(FOUND_AGAIN))) {
                        this.links.add(constraintLink);
                        optProperties = HelixOptimizerTools.optimizeHelices(10, 1.0, 1.0E8, 10.0, stemFitParameters, null, null, this.root, this.links, this.nucleotideDB, 3, this.fuseStrandsMode, this.firstFixedMode, 0);
                        this.links.remove(constraintLink);
                    } else if (graphFlag) {
                        double error = HelixOptimizer.computeBranchDescriptorError(bd1, bd2, constraintLink);
                        if (error > 2.0 * stemFitParameters.getRmsLimit()) {
                            throw new FittingException("Could not place helix from " + b1.getFullName() + " to already placed building block " + b2.getFullName());
                        }
                        optProperties = HelixOptimizerTools.generateHelix(constraintLink, 4, stemFitParameters, this.nucleotideDB, this.root, this.links, this.fuseStrandsMode);
                        log.fine("Ring closing in graph mode(1): " + constraintLink + " " + optProperties);
                        StrandJunctionTools.setHelixEndUsed(placedBlock, helixendNamePlaced);
                        StrandJunctionTools.setHelixEndUsed(newBlock, helixendNameNew);
                        this.links.remove(constraintLink);
                    } else assert (false);
                    collisionCount = 0;
                    if (this.avoidCollisionsMode) {
                        SimpleObject3DSet avoidSet = new SimpleObject3DSet();
                        String[] addedHelixNames = PropertyTools.getIndividualProperties(optProperties, "generated_helices");
                        if (addedHelixNames != null) {
                            log.fine("Checking " + addedHelixNames.length + " new helices for steric clashes.");
                            for (int j = 0; j < addedHelixNames.length; ++j) {
                                helixFullName = rootName + "." + addedHelixNames[j];
                                addedHelix = Object3DTools.findByFullName(this.root, helixFullName);
                                if (addedHelix == null) {
                                    log.severe("Internal error: could not find helix " + helixFullName);
                                    forbiddenNames = new HashSet<String>();
                                    forbiddenNames.add("Atom3D");
                                    Object3DTools.printFullNameTree(System.out, this.root, null, forbiddenNames);
                                    continue;
                                }
                                assert (addedHelix != null);
                                assert (Object3DTools.collectByClassName(addedHelix, "RnaStrand").size() == 2);
                                helixAtomCore = this.extractStrandCoreAtoms(addedHelix, this.junctionCoreOffset);
                                collisionCountTmp = this.countExternalCollisions(helixAtomCore, addedHelix, this.root, avoidSet, this.atomCollisionDistance);
                                if (collisionCountTmp > 0) {
                                    log.fine("Helix " + addedHelix.getFullName() + " has " + collisionCountTmp + " collisions!");
                                } else {
                                    log.fine("Helix " + addedHelix.getFullName() + " has no collisions!");
                                }
                                collisionCountTot += collisionCountTmp;
                            }
                        }
                        Object3DSet junctionAtomCore = this.extractCoreAtoms(newBlock, this.junctionCoreOffset);
                        assert (junctionAtomCore.size() > 0);
                        collisionCount += this.countExternalCollisions(junctionAtomCore, newBlock, this.root, avoidSet, this.atomCollisionDistance);
                    }
                    ringClosedFlag = false;
                    ringCsIndex = -1;
                    if (!graphFlag) {
                        ringCsIndex = this.findRingClosureIndex(newBlock, connections.get(i).getDescriptor2(), storedOrientations, ringDistWeight, ringAngleWeight);
                    }
                    ringClosureScore = 1000.0;
                    if (ringCsIndex >= 0) {
                        ringClosureScore = this.computeRingClosureScore(this.getBuildingBlockCoordinateSystem(newBlock), connections.get(i).getDescriptor2(), storedOrientations.get(ringCsIndex), ringDistWeight, ringAngleWeight);
                        if (ringClosureScore < bestRingClosureScore) {
                            bestRingClosureScore = ringClosureScore;
                        }
                        if (ringClosureScore <= this.ringClosureExportLimit) {
                            csRing = storedOrientations.get(ringCsIndex);
                            if (csRing.getParent() == null || csRing.getParent().getParent() == null || !(csRing.getParent().getParent() instanceof StrandJunction3D)) {
                                log.warning("Internal error: expect a junction to be in found ring structure");
                            } else {
                                ringJunction = (StrandJunction3D)csRing.getParent().getParent();
                                if (StrandJunctionTools.isHelixEndFree((Object3D)ringJunction, helixendNameNew)) {
                                    this.links.add(new SimpleLink(placedBlock, ringJunction));
                                    ringClosedFlag = true;
                                    StrandJunctionTools.setHelixEndUsed(placedBlock, helixendNamePlaced);
                                    log.fine("Adding ring-closing link from " + Object3DTools.getFullName(placedBlock) + " to " + Object3DTools.getFullName(ringJunction));
                                    StrandJunctionTools.setHelixEndUsed(ringJunction, helixendNameNew);
                                    ++ringCounter;
                                } else {
                                    log.warning("Strange: ring has already been closed concerning placed junction " + Object3DTools.getFullName(placedBlock) + " and ring junction " + Object3DTools.getFullName(ringJunction));
                                }
                            }
                            tabooSet.add(newBlock);
                        }
                    }
                    if (collisionCount == 0 && !ringClosedFlag && this.checkCompatibleWithTargetGraph() && StrandJunctionTools.isHelixEndFree(placedBlock, helixendNamePlaced)) {
                        newBlock.setProperty("ring_closure_score", "" + ringClosureScore);
                        StrandJunctionTools.setHelixEndUsed(placedBlock, helixendNamePlaced);
                        result.add(newBlock);
                        this.links.add(new SimpleLink(placedBlock, newBlock));
                        StrandJunctionTools.setHelixEndUsed(newBlock, helixendNameNew);
                        this.storeCoordinateSystem(newBlock, connections.get(i).getDescriptor2(), storedOrientations);
                        ++blockCounter;
                        log.fine("Properties of placed and new block: " + placedBlock.getFullName() + " : " + placedBlock.getProperties() + " ; " + newBlock.getFullName() + " : " + newBlock.getProperties());
                    } else {
                        log.fine("Removing new block because of collision or ring closure: " + newBlock.getFullName());
                        if (!"true".equals(newBlock.getProperty(FOUND_AGAIN))) {
                            Object3DTools.remove(newBlock);
                            if (graphFlag) {
                                throw new FittingException("Could not place block " + newBlock.getFullName() + " because of collisions!");
                            }
                        }
                        if (ringClosureScore > this.ringClosureExportLimit) {
                            ++ringlessCollision;
                            collisionCountTot += collisionCount;
                        }
                    }
                } else {
                    log.fine("Helixend is already used: " + Object3DTools.getFullName(placedBlock) + " " + helixendNamePlaced + " " + placedBlock.getProperty("used_helixends"));
                }
            }
            if (!connections.get(i).getDescriptor2().equals(element)) continue;
            log.fine("" + (i + 1) + " Found hit for second descriptor of connection(2): " + connections.get(i));
            ending = "b" + (blockCounter + 1);
            name = nameBase + "_" + ending;
            helixendNamePlaced = connections.get(i).getHelixendName2();
            if (StrandJunctionTools.isHelixEndFree(placedBlock, helixendNamePlaced)) {
                newBlock = this.placeBuildingBlock(connections.get(i).getDescriptor1(), rootName, name, Vector3D.ZVEC, "_" + ending, placedBlocks, graphFlag);
                b1 = placedBlock.getChild(connections.get(i).getHelixendName2());
                if (b1 == null || !(b1 instanceof BranchDescriptor3D)) {
                    throw new FittingException("Illegal helix end descriptor name: " + connections.get(i).getHelixendName2());
                }
                bd1 = (BranchDescriptor3D)b1;
                helixendNameNew = connections.get(i).getHelixendName1();
                log.fine("new block properties(2): " + newBlock.getFullName() + " " + newBlock.getProperties());
                if (!StrandJunctionTools.isHelixEndFree((Object3D)newBlock, helixendNameNew)) {
                    throw new FittingException("Strange error in building block grower: helix of building block was unexpectantly occupied! Check graph definition: " + newBlock.getFullName());
                }
                assert (StrandJunctionTools.isHelixEndFree((Object3D)newBlock, helixendNameNew));
                b2 = newBlock.getChild(helixendNameNew);
                if (b2 == null || !(b2 instanceof BranchDescriptor3D)) {
                    throw new FittingException("Illegal helix end descriptor name: " + connections.get(i).getHelixendName1());
                }
                bd2 = (BranchDescriptor3D)b2;
                rms = 1.0;
                constraintLink = new SimpleHelixConstraintLink(bd1, bd2, connections.get(i).getBasePairCount(), connections.get(i).getBasePairCount(), rms);
                optProperties = new Properties();
                if (!"true".equals(newBlock.getProperty(FOUND_AGAIN))) {
                    this.links.add(constraintLink);
                    optProperties = HelixOptimizerTools.optimizeHelices(10, 1.0, 1.0E8, 10.0, stemFitParameters, null, null, this.root, this.links, this.nucleotideDB, 3, this.fuseStrandsMode, this.firstFixedMode, 0);
                    this.links.remove(constraintLink);
                } else if (graphFlag) {
                    double error = HelixOptimizer.computeBranchDescriptorError(bd1, bd2, constraintLink);
                    assert (false);
                    if (error > 2.0 * stemFitParameters.getRmsLimit()) {
                        throw new FittingException("Could not place helix from " + b1.getFullName() + " to already placed building block " + b2.getFullName());
                    }
                    optProperties = HelixOptimizerTools.generateHelix(constraintLink, 4, stemFitParameters, this.nucleotideDB, this.root, this.links, this.fuseStrandsMode);
                    log.fine("Ring closing in graph mode(2): " + constraintLink + " " + optProperties);
                    StrandJunctionTools.setHelixEndUsed(placedBlock, helixendNamePlaced);
                    StrandJunctionTools.setHelixEndUsed(newBlock, helixendNameNew);
                    this.links.remove(constraintLink);
                } else assert (false);
                collisionCount = 0;
                if (this.avoidCollisionsMode) {
                    SimpleObject3DSet avoidSet = new SimpleObject3DSet();
                    String[] addedHelixNames = PropertyTools.getIndividualProperties(optProperties, "generated_helices");
                    if (addedHelixNames != null) {
                        for (int j = 0; j < addedHelixNames.length; ++j) {
                            helixFullName = rootName + "." + addedHelixNames[j];
                            addedHelix = Object3DTools.findByFullName(this.root, helixFullName);
                            log.fine("Added helix with name " + helixFullName + " avoid set.(2)");
                            assert (addedHelix != null);
                            if (addedHelix == null) {
                                log.severe("Internal error: could not find helix " + helixFullName);
                                forbiddenNames = new HashSet();
                                forbiddenNames.add("Atom3D");
                                Object3DTools.printFullNameTree(System.out, this.root, null, forbiddenNames);
                                continue;
                            }
                            assert (addedHelix != null);
                            assert (Object3DTools.collectByClassName(addedHelix, "RnaStrand").size() == 2);
                            helixAtomCore = this.extractStrandCoreAtoms(addedHelix, this.junctionCoreOffset);
                            collisionCountTmp = this.countExternalCollisions(helixAtomCore, addedHelix, this.root, avoidSet, this.atomCollisionDistance);
                            if (collisionCountTmp > 0) {
                                log.fine("Helix " + addedHelix.getFullName() + " has " + collisionCountTmp + " collisions!");
                            } else {
                                log.fine("Helix " + addedHelix.getFullName() + " has no collisions!");
                            }
                            collisionCountTot += collisionCountTmp;
                        }
                    }
                    Object3DSet junctionAtomCore = this.extractCoreAtoms(newBlock, this.junctionCoreOffset);
                    assert (junctionAtomCore.size() > 0);
                    collisionCount += this.countExternalCollisions(junctionAtomCore, newBlock, this.root, avoidSet, this.atomCollisionDistance);
                }
                ringClosedFlag = false;
                ringCsIndex = -1;
                if (!graphFlag) {
                    ringCsIndex = this.findRingClosureIndex(newBlock, connections.get(i).getDescriptor1(), storedOrientations, ringDistWeight, ringAngleWeight);
                }
                ringClosureScore = 1000.0;
                if (ringCsIndex >= 0) {
                    ringClosureScore = this.computeRingClosureScore(this.getBuildingBlockCoordinateSystem(newBlock), connections.get(i).getDescriptor1(), storedOrientations.get(ringCsIndex), ringDistWeight, ringAngleWeight);
                    if (ringClosureScore < bestRingClosureScore) {
                        bestRingClosureScore = ringClosureScore;
                    }
                    if (ringClosureScore <= this.ringClosureExportLimit) {
                        csRing = storedOrientations.get(ringCsIndex);
                        if (csRing.getParent() == null || csRing.getParent().getParent() == null || !(csRing.getParent().getParent() instanceof StrandJunction3D)) {
                            log.warning("Internal error: expect a junction to be in found ring structure");
                        } else {
                            ringJunction = (StrandJunction3D)csRing.getParent().getParent();
                            if (StrandJunctionTools.isHelixEndFree((Object3D)ringJunction, helixendNameNew)) {
                                this.links.add(new SimpleLink(placedBlock, ringJunction));
                                ringClosedFlag = true;
                                StrandJunctionTools.setHelixEndUsed(placedBlock, helixendNamePlaced);
                                log.fine("Adding ring-closing link from " + Object3DTools.getFullName(placedBlock) + " to " + Object3DTools.getFullName(ringJunction) + " (2)");
                                StrandJunctionTools.setHelixEndUsed(ringJunction, helixendNameNew);
                                ++ringCounter;
                            } else {
                                log.warning("Strange: ring has already been closed concerning placed junction " + Object3DTools.getFullName(placedBlock) + " and ring junction " + Object3DTools.getFullName(ringJunction));
                            }
                        }
                        tabooSet.add(newBlock);
                    }
                }
                if (collisionCount == 0 && !ringClosedFlag && this.checkCompatibleWithTargetGraph() && StrandJunctionTools.isHelixEndFree(placedBlock, helixendNamePlaced)) {
                    newBlock.setProperty("ring_closure_score", "" + ringClosureScore);
                    result.add(newBlock);
                    this.links.add(new SimpleLink(placedBlock, newBlock));
                    StrandJunctionTools.setHelixEndUsed(placedBlock, helixendNamePlaced);
                    StrandJunctionTools.setHelixEndUsed(newBlock, helixendNameNew);
                    this.storeCoordinateSystem(newBlock, connections.get(i).getDescriptor1(), storedOrientations);
                    ++blockCounter;
                    log.fine("Properties of placed and new block (2): " + placedBlock.getFullName() + " : " + placedBlock.getProperties() + " ; " + newBlock.getFullName() + " : " + newBlock.getProperties());
                    continue;
                }
                log.fine("Removing new block because of collision (2)! " + newBlock.getFullName());
                if (!"true".equals(newBlock.getProperty(FOUND_AGAIN))) {
                    Object3DTools.remove(newBlock);
                    if (graphFlag) {
                        throw new FittingException("Could not place block " + newBlock.getFullName() + " because of collisions!");
                    }
                }
                if (!(ringClosureScore > this.ringClosureExportLimit)) continue;
                ++ringlessCollision;
                collisionCountTot += collisionCount;
                continue;
            }
            log.fine("Helixend is already used (2): " + Object3DTools.getFullName(placedBlock) + " " + helixendNamePlaced + " " + placedBlock.getProperty("used_helixends"));
        }
        result.setProperty("ring_closure_score", "" + bestRingClosureScore);
        result.setProperty("ring_count", "" + ringCounter);
        result.setProperty("ringless_collisions", "" + ringlessCollision);
        PropertyTools.plusProperty(result.getProperties(), "collision_count", collisionCountTot);
        log.fine("Finished growBuildingBlock core with building blocks: " + result.size());
        return result;
    }

    private Properties growBuildingBlocks(List<List<Object3D>> placedBlocks, List<DBElementDescriptor> blockList, List<DBElementConnectionDescriptor> connections, List<CoordinateSystem3D> storedOrientations, String rootName, String nameBase, String ringClosureExportFileNameBase, Object3DSet tabooSet, int delayStage, int sizeMax, boolean graphFlag) throws FittingException {
        log.fine("Starting growBuildingBlocks with " + blockList.size() + " blocks, " + connections.size() + " connections, rootname " + rootName + " name base " + nameBase);
        if (blockList.size() == 0) {
            throw new FittingException("No building blocks defined!");
        }
        Properties resultProperties = new Properties();
        resultProperties.setProperty("ringless_collisions", "0");
        int blockCounter = 0;
        for (int i = 0; i < placedBlocks.size(); ++i) {
            blockCounter += placedBlocks.get(i).size();
        }
        int genNumber = placedBlocks.size();
        ArrayList<Object3D> newBlockList = new ArrayList<Object3D>();
        List<Object3D> lastPlacedList = placedBlocks.get(placedBlocks.size() - 1);
        String name = nameBase + "_g" + genNumber;
        double bestRingClosureScore = 1000.0;
        int ringCountTot = 0;
        int collisionCountTot = 0;
        for (int i = 0; i < lastPlacedList.size(); ++i) {
            Object3DSet newObjects = this.growBuildingBlock(lastPlacedList.get(i), placedBlocks, blockList, connections, storedOrientations, rootName, name, blockCounter, ringClosureExportFileNameBase, tabooSet, delayStage, graphFlag);
            assert (newObjects != null);
            collisionCountTot += PropertyTools.parseInt(newObjects.getProperties(), "collision_count");
            String ringlessCollisionString = newObjects.getProperty("ringless_collisions");
            assert (ringlessCollisionString != null);
            if (this.forbidRinglessCollisionMode && ringlessCollisionString != null && !ringlessCollisionString.equals("0")) {
                System.out.println("Detecting ringless collision! Quitting loop!");
                resultProperties.setProperty("ringless_collisions", ringlessCollisionString);
                break;
            }
            String ringClosureScoreText = newObjects.getProperty("ring_closure_score");
            assert (ringClosureScoreText != null);
            double ringClosureScore = Double.parseDouble(ringClosureScoreText);
            ringCountTot += PropertyTools.parseInt(newObjects.getProperties(), "ring_count");
            if (ringClosureScore < bestRingClosureScore) {
                bestRingClosureScore = ringClosureScore;
            }
            for (int j = 0; j < newObjects.size(); ++j) {
                newBlockList.add(newObjects.get(j));
            }
            if (sizeMax <= 0 || (blockCounter += newObjects.size()) < sizeMax) continue;
            log.info("Quitting growth loop because maximum size exceeded!");
            break;
        }
        placedBlocks.add(newBlockList);
        resultProperties.setProperty("collision_count", "" + collisionCountTot);
        resultProperties.setProperty("placed_blocks", "" + blockCounter);
        resultProperties.setProperty("ring_count", "" + ringCountTot);
        resultProperties.setProperty("ring_closure_score", "" + bestRingClosureScore);
        log.fine("Finished growBuildingBlocks!");
        return resultProperties;
    }

    private int findDelayMaximum(List<DBElementConnectionDescriptor> connections) {
        int result = 0;
        for (int i = 0; i < connections.size(); ++i) {
            if (connections.get(i).getDelayStage() <= result) continue;
            result = connections.get(i).getDelayStage();
        }
        return result;
    }

    private boolean computeIsGraphAllowedTopology(Set<String> allowedTopologies, String topology) {
        return allowedTopologies == null || allowedTopologies.size() == 0 || allowedTopologies.contains(topology);
    }

    public static int extractTopologySize(String topology) {
        String[] words = topology.split(";");
        assert (words.length > 0);
        String connections = words[words.length - 1].replace(">", "");
        String[] pairs = connections.split("%");
        HashSet<Integer> blocks = new HashSet<Integer>();
        for (String s : pairs) {
            String[] pair = s.split("-");
            if (pair.length != 2) continue;
            try {
                blocks.add(new Integer(Integer.parseInt(pair[0])));
            }
            catch (NumberFormatException nfe) {
                log.severe("Internal parsing error at word " + s + " for topology " + topology);
                assert (false);
            }
        }
        return blocks.size();
    }

    public static int extractTopologyMaxSize(Set<String> allowedTopologies, int sizeMax) {
        if (allowedTopologies == null || allowedTopologies.size() == 0) {
            return sizeMax;
        }
        int bestSize = 0;
        for (String s : allowedTopologies) {
            int n = BuildingBlockGrower.extractTopologySize(s);
            if (n <= bestSize) continue;
            bestSize = n;
        }
        if (sizeMax > 0 && sizeMax < bestSize) {
            bestSize = sizeMax;
        }
        return bestSize;
    }

    public Properties growBuildingBlocks(List<DBElementDescriptor> blockList, List<DBElementConnectionDescriptor> connections, String rootName, String nameBase, Vector3D startPosition, int numGenerations, String ringClosureExportFileNameBase, Set<String> allowedTopologies, int sizeMax, boolean graphFlag) throws FittingException, IOException {
        String ringlessCollisionsString;
        log.info("Starting growBuildingBlocks with " + blockList.size() + " blocks, " + connections.size() + " connections, rootname " + rootName + " name base " + nameBase + " and start position " + startPosition);
        if (blockList.size() == 0) {
            throw new FittingException("No building blocks defined!");
        }
        Properties resultProperties = new Properties();
        resultProperties.setProperty("ringless_collisions", "0");
        int blockCounter = 1;
        String newName = nameBase + "_seed";
        String fullName = rootName + "." + newName;
        ArrayList<List<Object3D>> placedBlocks = new ArrayList<List<Object3D>>();
        StrandJunction3D firstBlock = this.placeBuildingBlock(blockList.get(0), rootName, newName, startPosition, "_b0", placedBlocks, graphFlag);
        log.fine("Properties of first placed block: " + firstBlock.getProperties());
        assert (firstBlock.getProperty("used_helixends") == null);
        Properties tmpProperties = new Properties();
        placedBlocks.add(new ArrayList());
        ((List)placedBlocks.get(0)).add(firstBlock);
        ArrayList<CoordinateSystem3D> storedOrientations = new ArrayList<CoordinateSystem3D>();
        SimpleObject3DSet tabooSet = new SimpleObject3DSet();
        double bestRingClosureScore = 1000.0;
        int ringCountTot = 0;
        int delayMax = this.findDelayMaximum(connections);
        int collisionCountTot = 0;
        sizeMax = BuildingBlockGrower.extractTopologyMaxSize(allowedTopologies, sizeMax);
        for (int delayStage = 0; delayStage <= delayMax; ++delayStage) {
            for (int gen = 1; gen <= numGenerations; ++gen) {
                log.fine("Building block grow generation: " + gen);
                tmpProperties = this.growBuildingBlocks(placedBlocks, blockList, connections, storedOrientations, rootName, nameBase, ringClosureExportFileNameBase, tabooSet, delayStage, sizeMax, graphFlag);
                if (debugMode) {
                    log.info("Resulting properties after grow generation " + gen + " : " + tmpProperties);
                }
                String ringlessCollisionString = tmpProperties.getProperty("ringless_collisions");
                if (this.forbidRinglessCollisionMode && ringlessCollisionString != null && !ringlessCollisionString.equals("0")) {
                    System.out.println("Detecting ringless collision! Quitting loop over generations!");
                    resultProperties.setProperty("ringless_collisions", ringlessCollisionString);
                    break;
                }
                collisionCountTot += PropertyTools.parseInt(tmpProperties, "collision_count");
                ringCountTot += PropertyTools.parseInt(tmpProperties, "ring_count");
                String ringClosureScoreText = tmpProperties.getProperty("ring_closure_score");
                assert (ringClosureScoreText != null);
                double ringClosureScore = Double.parseDouble(ringClosureScoreText);
                if (ringClosureScore < bestRingClosureScore) {
                    bestRingClosureScore = ringClosureScore;
                }
                int numPlaced = ((List)placedBlocks.get(placedBlocks.size() - 1)).size();
                blockCounter += numPlaced;
                log.fine("Placed " + numPlaced + " building blocks in generation " + gen);
                if (numPlaced != 0) continue;
                log.fine("No further placements possible!");
                break;
            }
            if (ringCountTot != 0) continue;
            log.fine("Quitting delay loop, because no rings were found so far.");
            break;
        }
        int cageCount = 0;
        if (!this.hasFreeHelixEnds(placedBlocks)) {
            log.info("Finished structure (cage or ring) found!");
            cageCount = 1;
        }
        if ((ringlessCollisionsString = resultProperties.getProperty("ringless_collisions")) == null) {
            ringlessCollisionsString = "0";
        }
        boolean ringlessCollisionFree = ringlessCollisionsString == null || ringlessCollisionsString.equals("0");
        Object3DLinkSetBundle extractedGraph = StrandJunctionTools.extractJunctionGraph(this.root, this.links, "graph", tabooSet);
        GraphWriter graphWriter = new GraphWriter();
        log.info("Extracted graph: " + graphWriter.toString(extractedGraph));
        SignatureTranslatorCanonizer canonizer = new SignatureTranslatorCanonizer();
        String canonicString = "not_canonizable";
        try {
            if (ringlessCollisionFree) {
                canonicString = canonizer.generateCanonizedRepresentation(extractedGraph);
            }
        }
        catch (AlgorithmFailureException afe) {
            log.warning("Cannot canonize graph: " + afe.getMessage());
        }
        boolean graphCompatible = this.computeIsGraphAllowedTopology(allowedTopologies, canonicString);
        if (this.ringClosureExportLimit < 0.0 || ringCountTot > 0 && ringClosureExportFileNameBase != null && !ringClosureExportFileNameBase.equals("") && (ringlessCollisionFree || !this.forbidRinglessCollisionMode)) {
            if (graphCompatible) {
                if (!this.avoidCollisionsMode || collisionCountTot == 0) {
                    String filename = ringClosureExportFileNameBase;
                    int s = filename.lastIndexOf("/");
                    String sub1 = filename.substring(0, s + 1);
                    String sub2 = filename.substring(s + 1);
                    for (int i = 0; i < placedBlocks.size(); ++i) {
                        List completed = (List)placedBlocks.get(i);
                        for (int j = 0; j < completed.size(); ++j) {
                            Object3D currJunc = (Object3D)completed.get(j);
                            if (i + j > 0) {
                                sub1 = sub1 + "_";
                            }
                            sub1 = sub1 + currJunc.getFilename();
                        }
                    }
                    filename = sub1 + sub2 + ".pdb";
                    String filenameNoHelices = sub1 + sub2 + "_nohelices.pdb";
                    log.info("Exporting ring structure to file names: " + filename + " " + filenameNoHelices);
                    this.exportPdb(filename);
                    this.exportPdbNoHelices(filenameNoHelices);
                } else {
                    log.info("No exporting structure because of atomic clashes!");
                }
            } else {
                String inf = "Graph was not compatible with target topologies: " + canonicString + " : " + allowedTopologies;
                log.info(inf);
                throw new FittingException(inf);
            }
        }
        resultProperties.setProperty("canonized", canonicString);
        resultProperties.setProperty("graph_compatible", "" + graphCompatible);
        resultProperties.setProperty("cage_count", "" + cageCount);
        resultProperties.setProperty("placed_blocks", "" + blockCounter);
        resultProperties.setProperty("ring_closure_score", "" + bestRingClosureScore);
        resultProperties.setProperty("ring_count", "" + ringCountTot);
        resultProperties.setProperty("collision_count", "" + collisionCountTot);
        log.info("Finished growBuildingBlocks! Total number of placed building blocks: " + blockCounter + " Ring closure score: " + bestRingClosureScore + " ring_count: " + ringCountTot + " cage_count: " + cageCount + " canonized_graph: " + canonicString + " ringless_collisions: " + ringlessCollisionsString + " collision_count: " + collisionCountTot);
        return resultProperties;
    }

    public Properties growBuildingBlocks(GrowConnectivity connectivity, String rootName, String nameBase, Vector3D startPosition, String ringClosureExportFileNameBase) throws FittingException, IOException {
        return this.growBuildingBlocks(connectivity.getBuildingBlocks(), connectivity.getConnections(), rootName, nameBase, startPosition, connectivity.getNumGenerations(), ringClosureExportFileNameBase, connectivity.getTopologies(), connectivity.getSizeMax(), connectivity.isGraphFlag());
    }

    public void setFuseStrandsMode(int fuseMode) {
        this.fuseStrandsMode = fuseMode;
    }

    public void setRingClosureExportLimit(double limit) {
        this.ringClosureExportLimit = limit;
    }

    public void setStemRmsLimit(double d) {
        this.stemRmsLimit = d;
    }

    public void setTargetGraph(JunctionGraph3D graph) {
        this.targetGraph = graph;
    }

    private boolean checkCompatibleWithTargetGraph() {
        return true;
    }
}

