/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.Randomizer;
import graphtools.PermutationGenerator;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;
import numerictools.DoubleArrayTools;
import org.testng.annotations.Test;
import rnadesign.designapp.rnagui.NanoTiler;
import rnadesign.rnamodel.ConnectingStemGenerator;
import rnadesign.rnamodel.FitParameters;
import rnadesign.rnamodel.InteractionLink;
import rnadesign.rnamodel.PackageConstants;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.SimpleStrandJunction3D;
import rnadesign.rnamodel.StatisticsGridTiler;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunctionDB;
import rnadesign.rnamodel.StrandJunctionTools;
import rnadesign.rnamodel.TilingStatistics;
import tools3d.MCSuperposeCollinear;
import tools3d.SuperpositionResult;
import tools3d.Vector3D;
import tools3d.Vector3DTools;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.LinkTools;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import tools3d.objects3d.SimpleObject3DSet;

public class FragmentGridTiler
implements StatisticsGridTiler {
    private static final double ANGLE_LIMIT_DEFAULT = 0.3490658503988659;
    private static final double NO_JUNCTION_PLACED_PENALTY = 100.0;
    private static final double NO_STEM_PLACED_PENALTY = 10.0;
    private static final int GENERATE_ALL_STEMS_INDEX = -1;
    private static final double RMS_LIMIT_DEFAULT = 3.0;
    private static final NumberFormat THREE_DECIMALS = new DecimalFormat(".000");
    private static final String JUNCTION_ENDING = "_jnc";
    private static List[] oldSymmetryJunctions = new ArrayList[6];
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private static Random random = Randomizer.getInstance();
    private static StrandJunction3D[] symmetryJunctions = new StrandJunction3D[6];
    private int appendStrandsMode = 2;
    private int axialSteps = 36;
    private boolean junctionPlaceMode = true;
    private int connectionAlgorithm = 3;
    private int rerunMax = 5;
    private boolean connectJunctionsMode = true;
    private boolean forbiddenMode = false;
    private boolean fuseJunctionStrandsMode = false;
    private double fuseStrandCutoff = 12.0;
    private FitParameters junctionFitParameters = new FitParameters(3.0, 0.3490658503988659);
    private int junctionMinOrder = 1;
    private TilingStatistics junctionStatistics = new TilingStatistics();
    private StrandJunctionDB kissingLoopDB;
    private boolean kissingLoopJunctionMode = false;
    private boolean kissingLoopMode = false;
    private TilingStatistics kissingLoopStatistics = new TilingStatistics();
    private Object3D nucleotideDB;
    private int optimizeJunctionChoiceIterMax = 0;
    private FitParameters stemFitParameters = new FitParameters(3.0, 0.6981317007977318);
    private TilingStatistics stemStatistics = new TilingStatistics();
    private StrandJunctionDB strandJunctionDB;
    private double scaleFactor = 1.0;
    private boolean symmetryMode = false;

    public FragmentGridTiler() {
    }

    public FragmentGridTiler(StrandJunctionDB strandJunctionDB, StrandJunctionDB kissingLoopDB) {
        this.strandJunctionDB = strandJunctionDB;
        this.kissingLoopDB = kissingLoopDB;
    }

    public FragmentGridTiler(FragmentGridTiler other) {
        this.copy(other);
    }

    double computeJunctionFitScore(Object3DSet placedJunctions, int index, Object3DSet vertexObjectSet, LinkSet links) {
        double result = 0.0;
        double stemFitTerm = 0.0;
        if (placedJunctions.get(index) == null) {
            stemFitTerm += 100.0;
        } else {
            String baseName = new String("DummyStems");
            Object3DLinkSetBundle stemBundle = new ConnectingStemGenerator(this, placedJunctions, baseName, vertexObjectSet, links, index, 0).generate();
            Object3DSet stemSet = Object3DTools.collectByClassName(stemBundle.getObject3D(), "RnaStem3D");
            int stemFitCount = 0;
            assert (stemSet.size() > 0);
            for (int i = 0; i < stemSet.size(); ++i) {
                if (stemSet.get(i) instanceof RnaStem3D) {
                    Properties properties = stemSet.get(i).getProperties();
                    assert (properties != null);
                    String fitScoreString = properties.getProperty("fit_score");
                    assert (fitScoreString != null);
                    assert (fitScoreString.length() > 0);
                    double fitScore = Double.parseDouble(fitScoreString);
                    stemFitTerm += fitScore;
                    ++stemFitCount;
                    continue;
                }
                log.severe("Strange class found: " + stemSet.get(i).getClassName() + " " + stemSet.get(i).getName());
                assert (false);
            }
            stemFitTerm = stemFitCount > 0 ? (stemFitTerm /= (double)stemFitCount) : (stemFitTerm += 10.0);
        }
        return result += stemFitTerm;
    }

    @Test
    public void testComputeJunctionFitScore() {
    }

    double[] computeJunctionFitScores(Object3DSet placedJunctions, Object3DSet vertexObjectSet, LinkSet links) {
        assert (placedJunctions.size() > 0);
        double[] result = new double[placedJunctions.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.computeJunctionFitScore(placedJunctions, i, vertexObjectSet, links);
            log.fine("Fit score of junction " + (i + 1) + " " + result[i]);
        }
        return result;
    }

    @Test
    public void testComputeJunctionFitScores() {
    }

    private Vector3D[] generateDirectionVectors(Vector3D vertexPos, Object3DSet neighbors, int[] perm) {
        Vector3D[] result = new Vector3D[neighbors.size()];
        for (int i = 0; i < neighbors.size(); ++i) {
            result[i] = neighbors.get(perm[i]).getPosition().minus(vertexPos);
            assert (result[i].length() > 0.0);
            result[i].normalize();
        }
        return result;
    }

    private Vector3D[] generateDirectionVectors(Vector3D vertexPos, Object3DSet neighbors) {
        Vector3D[] result = new Vector3D[neighbors.size()];
        for (int i = 0; i < neighbors.size(); ++i) {
            result[i] = neighbors.get(i).getPosition().minus(vertexPos);
            assert (result[i].length() > 0.0);
            result[i].normalize();
        }
        return result;
    }

    @Test
    public void testGenerateDirectionVectors() {
    }

    static Vector3D[] generateJunctionBranchDirections(StrandJunction3D junction) {
        Vector3D[] result = new Vector3D[junction.getBranchCount()];
        for (int i = 0; i < junction.getBranchCount(); ++i) {
            result[i] = junction.getBranch(i).getDirection();
        }
        return result;
    }

    @Test
    public void testGenerateJunctionBranchDirections() {
    }

    private Vector3D[] generateJunctionBranchVectors(StrandJunction3D junction) {
        Vector3D[] result = new Vector3D[junction.getBranchCount()];
        for (int i = 0; i < junction.getBranchCount(); ++i) {
            result[i] = junction.getBranch(i).getPosition();
        }
        return result;
    }

    @Test
    public void testGenerateJunctionBranchVectors() {
    }

    private Object3DSet generateSymmetries(Object3DSet vertexSet, Object3D objectTree, Object3DSet placedJunctions) {
        log.info("Started generateSymmetries!");
        assert (vertexSet != null);
        assert (objectTree != null);
        assert (placedJunctions != null);
        assert (placedJunctions.size() > 0);
        SimpleObject3DSet plJunc = new SimpleObject3DSet();
        for (int i = 0; i < placedJunctions.size(); ++i) {
            if (placedJunctions.get(i) == null) continue;
            StrandJunction3D tmpStr = (StrandJunction3D)placedJunctions.get(i);
            plJunc.add((StrandJunction3D)tmpStr.cloneDeep());
        }
        assert (plJunc.size() > 0);
        Object tmpObject = null;
        SimpleObject3DSet result = new SimpleObject3DSet();
        log.severe("getNumSymmetries method was removed!! Outdated method. CEV");
        log.info("Ended generateSymmetries!");
        return result;
    }

    @Test
    public void testGenerateSymmetries() {
    }

    static LinkSet generateJunctionLinks(Object3DSet junctions) {
        SimpleLinkSet result = new SimpleLinkSet();
        for (int i = 0; i < junctions.size(); ++i) {
            if (junctions.get(i) == null) continue;
            result.merge(StrandJunctionTools.generateJunctionLinks((StrandJunction3D)junctions.get(i)));
        }
        return result;
    }

    public int countInteractionLinks(LinkSet links) {
        int count = 0;
        for (int i = 0; i < links.size(); ++i) {
            if (!(links.get(i) instanceof InteractionLink)) continue;
            ++count;
        }
        return count;
    }

    public Object3DLinkSetBundle generateTilingRun(Object3D objectTree, LinkSet links, String baseName, char defaultSequenceChar, boolean onlyFirstPathMode) {
        String statText;
        assert (objectTree != null);
        assert (objectTree.size() > 0);
        assert (links != null);
        assert (links.size() > 0);
        assert (baseName != null);
        assert (this.strandJunctionDB != null);
        this.reset();
        log.severe("CEV: hasSymmetries method was removed!! Outdated");
        log.info("Starting FragmentGridTiler.generateTilingRun");
        SimpleObject3D resultTree = new SimpleObject3D();
        resultTree.setName(baseName);
        resultTree.setPosition(objectTree.getPosition());
        SimpleLinkSet newLinks = new SimpleLinkSet();
        SimpleObject3DSet vertexSet = new SimpleObject3DSet(objectTree);
        for (int i = vertexSet.size() - 1; i >= 0; --i) {
            if (LinkTools.countLinks(vertexSet.get(i), links) != 0) continue;
            vertexSet.remove(vertexSet.get(i));
        }
        Object3DSet junctions = this.placeJunctions(vertexSet, links, baseName);
        int numPlJunc = 0;
        for (int i = 0; i < junctions.size(); ++i) {
            if (junctions.get(i) == null) continue;
            ++numPlJunc;
        }
        if (numPlJunc < 1) {
            log.warning("No junctions were placed so generateTiling was stopped");
            return null;
        }
        if (this.optimizeJunctionChoiceIterMax > 0) {
            double initialScore = this.optimizeJunctionChoice(junctions, vertexSet, links, baseName, 1);
            log.info("Starting to optimize chosen junctions! Initial score: " + initialScore);
            double optScore = this.optimizeJunctionChoice(junctions, vertexSet, links, baseName, this.optimizeJunctionChoiceIterMax);
            log.info("Finished optimize junctions with score: " + optScore + " ( initial score was: " + initialScore + " )");
        }
        LinkSet junctionLinks = FragmentGridTiler.generateJunctionLinks(junctions);
        newLinks.merge(junctionLinks);
        if (this.connectJunctionsMode) {
            log.info("Connect junctions mode is on");
            ConnectingStemGenerator connectingStemGenerator = new ConnectingStemGenerator(this, junctions, baseName, vertexSet, links, -1, this.appendStrandsMode);
            assert (connectingStemGenerator != null);
            Object3DLinkSetBundle stemBundle = connectingStemGenerator.generate();
            Object3D stemRoot = stemBundle.getObject3D();
            Object3DTools.setRecursiveProperty(stemRoot, "sequence_status", "adhoc", "Nucleotide3D");
            log.info("Generated " + stemRoot.size() + " connecting stems with " + stemBundle.getLinks().size() + " links.");
            resultTree.insertChild(stemRoot);
            int interactionLinkCount = this.countInteractionLinks(stemBundle.getLinks());
            log.info("Number of interaction links found: " + interactionLinkCount);
            newLinks.merge(stemBundle.getLinks());
        } else {
            log.info("No interpolating stems generated because of user flag");
        }
        if (this.fuseJunctionStrandsMode) {
            log.info("Fuse junction strands mode is on");
            for (int i = 0; i < junctions.size(); ++i) {
                StrandJunction3D junction = (StrandJunction3D)junctions.get(i);
                if (junction == null) continue;
                StrandJunctionTools.fuseStrands(junction, this.fuseStrandCutoff);
            }
        }
        assert (junctions != null);
        for (int i = 0; i < junctions.size(); ++i) {
            if (junctions.get(i) == null) continue;
            log.finest("Adding junction " + i + ": " + junctions.get(i));
            resultTree.insertChild(junctions.get(i));
        }
        double totalFraction = 0.5 * (this.getJunctionStatistics().getCoverage() + this.getStemStatistics().getCoverage());
        resultTree.setProperty("placement_total_fraction", "" + totalFraction);
        SimpleObject3DLinkSetBundle result = new SimpleObject3DLinkSetBundle(resultTree, newLinks);
        for (int i = 0; i < symmetryJunctions.length; ++i) {
            if (oldSymmetryJunctions[i] != null) {
                oldSymmetryJunctions[i].add(symmetryJunctions[i]);
                continue;
            }
            FragmentGridTiler.oldSymmetryJunctions[i] = new ArrayList();
        }
        log.info("Finished generateTilingRun!");
        NanoTiler.tilingStatisticsString = statText = "Junctions: " + this.getJunctionStatistics().toString() + PackageConstants.ENDL + PackageConstants.ENDL + "Stems: " + this.getStemStatistics().toString() + PackageConstants.ENDL + PackageConstants.ENDL + "Kissing Loops: " + this.getKissingLoopStatistics().toString();
        log.info(statText);
        log.info("Totall coverage fraction of this run: " + totalFraction);
        assert (result != null);
        return result;
    }

    @Override
    public Object3DLinkSetBundle generateTiling(Object3D objectTree, LinkSet links, String baseName, char defaultSequenceChar, boolean onlyFirstPathMode) {
        Object3DLinkSetBundle result = null;
        double bestScore = 0.0;
        double placeLim = 0.999999;
        SimpleObject3DSet objectSet = new SimpleObject3DSet(objectTree);
        log.info("Starting FragmentGridTiler.generateTiling with options: " + this.toString());
        for (int k = -1; k <= 1; ++k) {
            if (this.scaleFactor == 1.0 && k != 0) continue;
            for (int i = 0; i < this.rerunMax; ++i) {
                log.info("Starting tiling run " + (i + 1));
                Object3DLinkSetBundle bundle = this.generateTilingRun(objectTree, links, baseName, defaultSequenceChar, onlyFirstPathMode);
                if (bundle == null) {
                    log.warning("No tiling could be generated at pass " + (i + 1));
                    continue;
                }
                assert (bundle != null);
                String placeFracString = bundle.getObject3D().getProperty("placement_total_fraction");
                assert (placeFracString != null);
                assert (placeFracString.length() > 0);
                double score = Double.parseDouble(placeFracString);
                log.info("Placement score of run " + (i + 1) + " " + score + " ( " + placeFracString + " )");
                if (result == null || score > bestScore) {
                    result = bundle;
                    bestScore = score;
                    log.info("Adopting so far best solution!");
                }
                if (!(bestScore >= placeLim)) continue;
                log.info("Quiting rerun loop, because complete placement found!");
                break;
            }
            if (bestScore >= placeLim) break;
        }
        return result;
    }

    @Test
    public void testGenerateTiling() {
    }

    public int getAppendStrandsMode() {
        return this.appendStrandsMode;
    }

    public int getAxialSteps() {
        return this.axialSteps;
    }

    public boolean getJunctionPlaceMode() {
        return this.junctionPlaceMode;
    }

    public int getConnectionAlgorithm() {
        return this.connectionAlgorithm;
    }

    public boolean getConnectJunctionsMode() {
        return this.connectJunctionsMode;
    }

    public boolean getForbiddenMode() {
        return this.forbiddenMode;
    }

    public boolean getFuseJunctionStrandsMode() {
        return this.fuseJunctionStrandsMode;
    }

    public double getFuseStrandCutoff() {
        return this.fuseStrandCutoff;
    }

    public FitParameters getJunctionFitParameters() {
        return this.junctionFitParameters;
    }

    public int getJunctionMinOrder() {
        return this.junctionMinOrder;
    }

    @Override
    public TilingStatistics getJunctionStatistics() {
        return this.junctionStatistics;
    }

    public StrandJunctionDB getKissingLoopDB() {
        return this.kissingLoopDB;
    }

    public boolean getKissingLoopJunctionMode() {
        return this.kissingLoopJunctionMode;
    }

    public boolean getKissingLoopMode() {
        return this.kissingLoopMode;
    }

    @Override
    public TilingStatistics getKissingLoopStatistics() {
        return this.kissingLoopStatistics;
    }

    public Object3D getNucleotideDB() {
        return this.nucleotideDB;
    }

    public int getOptimizeJunctionChoiceIterMax() {
        return this.optimizeJunctionChoiceIterMax;
    }

    public int getRerunMax() {
        return this.rerunMax;
    }

    public FitParameters getStemFitParameters() {
        return this.stemFitParameters;
    }

    @Override
    public TilingStatistics getStemStatistics() {
        return this.stemStatistics;
    }

    public StrandJunctionDB getStrandJunctionDB() {
        return this.strandJunctionDB;
    }

    public boolean getSymmetryMode() {
        return this.symmetryMode;
    }

    private double optimizeJunctionChoice(Object3DSet placedJunctions, Object3DSet vertexObjectSet, LinkSet links, String baseName, int iterMax) {
        double[] fitScores = this.computeJunctionFitScores(placedJunctions, vertexObjectSet, links);
        double totScore = DoubleArrayTools.computeSum(fitScores) / (double)fitScores.length;
        int iter = 0;
        double bestScore = totScore;
        double optimizeScoreLimit = 0.1;
        int randomIterMax = 10;
        log.fine("Starting FragmentGridTiler.optimizeJunctionChoice with total fitting score: " + bestScore);
        while (iter++ < iterMax && bestScore > optimizeScoreLimit) {
            int choice = DoubleArrayTools.chooseRouletteWheel(fitScores);
            String name = baseName + JUNCTION_ENDING + (choice + 1);
            StrandJunction3D newJunction = this.placeJunction(vertexObjectSet.get(choice), links, baseName, randomIterMax);
            StrandJunction3D savedJunction = (StrandJunction3D)placedJunctions.get(choice);
            placedJunctions.set(choice, newJunction);
            fitScores = this.computeJunctionFitScores(placedJunctions, vertexObjectSet, links);
            double newScore = DoubleArrayTools.computeSum(fitScores) / (double)fitScores.length;
            log.fine("New optimized junction computed. Current fitting score: " + newScore);
            if (newScore <= bestScore) {
                bestScore = newScore;
                log.fine("New optimized junction found. Best fitting score: " + bestScore);
                continue;
            }
            placedJunctions.set(choice, savedJunction);
        }
        log.fine("Finished FragmentGridTiler.optimizeJunctionChoice with total fitting score: " + bestScore);
        return bestScore;
    }

    @Test
    public void testOptimizeJunctionChoice() {
    }

    StrandJunction3D placeJunction(Object3D vertex, LinkSet links, String baseName, int randomTrialsMax) {
        Properties prop;
        assert (vertex != null);
        assert (links != null);
        assert (baseName != null);
        assert (this.strandJunctionDB != null);
        assert (this.strandJunctionDB.isValid());
        log.fine("started FragmentGridTiler.placeJunction!");
        Object3DSet neighbors = LinkTools.findNeighbors(vertex, links);
        log.fine("neighbors: " + neighbors);
        int order = neighbors.size();
        Vector3D[] neighborVectors = new Vector3D[neighbors.size()];
        for (int i = 0; i < neighborVectors.length; ++i) {
            neighborVectors[i] = new Vector3D(vertex.getPosition());
        }
        Vector3D[] neighborDirectionsOrig = this.generateDirectionVectors(vertex.getPosition(), neighbors);
        log.fine("trying to place junction of order: " + order);
        MCSuperposeCollinear superposer = new MCSuperposeCollinear();
        superposer.setAngleWeight(this.junctionFitParameters.getAngleWeight());
        superposer.setAngleLimit(this.junctionFitParameters.getAngleLimit());
        int bestId = 0;
        double bestRms = 999.9;
        StrandJunction3D[] strandJunctions = new SimpleStrandJunction3D[]{};
        if (this.junctionPlaceMode) {
            strandJunctions = this.strandJunctionDB.getJunctions(order);
            if (this.kissingLoopJunctionMode) {
                int i;
                StrandJunction3D[] temp = new StrandJunction3D[strandJunctions.length];
                for (i = 0; i < strandJunctions.length; ++i) {
                    temp[i] = strandJunctions[i];
                }
                strandJunctions = new StrandJunction3D[temp.length + this.kissingLoopDB.getJunctions(order).length];
                for (i = 0; i < temp.length; ++i) {
                    strandJunctions[i] = temp[i];
                }
                for (i = 0; i < this.kissingLoopDB.getJunctions(order).length; ++i) {
                    strandJunctions[i + temp.length] = this.kissingLoopDB.getJunctions(order)[i];
                }
            }
        } else if (this.kissingLoopJunctionMode) {
            strandJunctions = this.kissingLoopDB.getJunctions(order);
        }
        if (strandJunctions.length == 0) {
            log.warning("Junction was not placed because there were no junctions of the correct order in the DB.");
            return null;
        }
        Object3D bestJunction = null;
        assert (strandJunctions != null && strandJunctions.length > 0);
        int randomTrials = 0;
        Random random = Randomizer.getInstance();
        for (int ii = 0; ii < strandJunctions.length; ++ii) {
            int i = ii;
            if (randomTrialsMax > 0) {
                if (bestJunction != null || randomTrials++ > randomTrialsMax) {
                    log.fine("Quitting loop over junctions because of random mode");
                    break;
                }
                i = random.nextInt(strandJunctions.length);
                log.finest("Working on database randomly chosen junction " + (i + 1));
            } else {
                log.info("Working on database junction " + (i + 1));
            }
            Vector3D[] junctionDirectionsOrig = FragmentGridTiler.generateJunctionBranchDirections(strandJunctions[i]);
            if (junctionDirectionsOrig.length > 1) {
                assert (junctionDirectionsOrig.length == neighborDirectionsOrig.length);
                double plausScore = Vector3DTools.computeVectorFieldSimilarityScore(junctionDirectionsOrig, neighborDirectionsOrig);
                if (plausScore > 2.0 * this.junctionFitParameters.getAngleLimit()) {
                    log.warning("Skipping junction " + (i + 1) + " because of plausibility score: " + plausScore + " " + this.junctionFitParameters.getAngleLimit());
                    continue;
                }
            } else {
                log.warning("junction of order : " + junctionDirectionsOrig.length + " detected!");
            }
            if (this.symmetryMode) {
                log.fine("Symmetry mode is on");
                StrandJunction3D currJunction = strandJunctions[i];
                if (order < symmetryJunctions.length && symmetryJunctions[order] != null && currJunction != symmetryJunctions[order]) continue;
                List oldJunctions = oldSymmetryJunctions[order];
                if (oldJunctions != null) {
                    boolean forbiddenFound = false;
                    for (int j = 0; j < oldJunctions.size(); ++j) {
                        StrandJunction3D oldJunction = (StrandJunction3D)oldJunctions.get(j);
                        if (currJunction != oldJunction) continue;
                        forbiddenFound = true;
                        break;
                    }
                    if (forbiddenFound && this.forbiddenMode) {
                        continue;
                    }
                } else {
                    FragmentGridTiler.oldSymmetryJunctions[order] = new ArrayList();
                }
            }
            PermutationGenerator permutator = new PermutationGenerator(neighbors.size());
            int permCount = 0;
            while (permutator.hasMore()) {
                int[] perm = permutator.getNext();
                ++permCount;
                try {
                    StrandJunction3D tmpJunction = (StrandJunction3D)strandJunctions[i].cloneDeep();
                    Vector3D[] junctionDirections = FragmentGridTiler.generateJunctionBranchDirections(tmpJunction);
                    Vector3D[] junctionVectors = this.generateJunctionBranchVectors(tmpJunction);
                    assert (junctionDirections.length == junctionVectors.length);
                    Vector3D[] neighborDirections = this.generateDirectionVectors(vertex.getPosition(), neighbors, perm);
                    if (junctionVectors == null) continue;
                    assert (neighborVectors.length == junctionVectors.length);
                    if (order >= this.junctionMinOrder) {
                        SuperpositionResult superResult = superposer.superpose(neighborVectors, neighborDirections, junctionVectors, junctionDirections);
                        assert (superResult != null);
                        double rms = superResult.getRms();
                        if (rms > this.junctionFitParameters.getRmsLimit()) {
                            log.info("Junction could not be placed at all, because fitting error is too large: " + rms);
                            continue;
                        }
                        assert (tmpJunction.checkChildrenUnique());
                        superResult.applyTransformation(tmpJunction);
                        if (!(rms < bestRms) && bestJunction != null) continue;
                        if (permCount > 0) {
                            log.fine("Result of permutated superposition: " + rms + " better than " + bestRms + " " + (i + 1) + " " + permCount);
                        } else {
                            log.fine("Result of first superposition: " + rms + " better than " + bestRms + " " + (i + 1) + " " + permCount);
                        }
                        bestRms = rms;
                        bestId = i;
                        bestJunction = tmpJunction;
                        continue;
                    }
                    log.warning("Junction was not placed because min order specified was greater");
                }
                catch (RuntimeException e) {
                    log.severe("RuntimeException in FragmentGridTiler.placeJunction: " + e.getMessage());
                }
            }
        }
        if (bestJunction == null) {
            log.info("Junction could not be placed at all!");
            return null;
        }
        log.fine("Best fit score: " + bestRms + " modified junction: " + bestJunction.getName() + " " + bestJunction.getBranchCount());
        for (int j = 0; j < bestJunction.getBranchCount(); ++j) {
            log.fine("Branch " + (j + 1) + ": Pos: " + bestJunction.getBranch(j).getPosition() + " Dir: " + bestJunction.getBranch(j).getDirection());
        }
        if (this.symmetryMode && symmetryJunctions[order] == null) {
            FragmentGridTiler.symmetryJunctions[order] = strandJunctions[bestId];
        }
        if ((prop = bestJunction.getProperties()) == null) {
            prop = new Properties();
        }
        prop.setProperty("fit_score", "" + bestRms);
        bestJunction.setProperties(prop);
        log.fine("finished placeJunction!");
        return bestJunction;
    }

    @Test
    public void testPlaceJunction() {
    }

    private Object3DSet placeJunctions(Object3DSet objectSet, LinkSet links, String baseName) {
        assert (objectSet != null);
        assert (objectSet.size() > 0);
        assert (links != null);
        assert (links.size() > 0);
        assert (baseName != null);
        assert (this.strandJunctionDB != null);
        log.fine("Started placeJunctions!");
        this.junctionStatistics = new TilingStatistics();
        SimpleObject3DSet result = new SimpleObject3DSet();
        String[] usedJunctions = new String[1];
        for (int i = 0; i < objectSet.size(); ++i) {
            Object3D vertex = objectSet.get(i);
            if (usedJunctions[usedJunctions.length - 1] != null) {
                String[] tempArray = new String[usedJunctions.length];
                tempArray = usedJunctions;
                usedJunctions = new String[usedJunctions.length + 1];
                for (int x = 0; x < tempArray.length; ++x) {
                    if (tempArray[x] == null) continue;
                    usedJunctions[x] = tempArray[x];
                }
            }
            String name = baseName + "_junc" + (i + 1);
            StrandJunction3D junction = new SimpleStrandJunction3D();
            if (vertex.getProperty("rotateFrom") != null) {
                String rotFromString = vertex.getProperty("rotateFrom");
                assert (rotFromString != null);
                log.info("interpreting rotFrom string: " + rotFromString + " of junction " + (i + 1));
                int rotateFromIndex = Integer.parseInt(rotFromString);
                assert (rotateFromIndex != i);
                StrandJunction3D tmpJunction = (StrandJunction3D)result.get(rotateFromIndex);
                if (tmpJunction != null) {
                    StrandJunction3D rotateJunction = (StrandJunction3D)tmpJunction.cloneDeep();
                    assert (rotateJunction.size() > 0);
                    double x = Double.parseDouble(vertex.getProperty("axisX"));
                    double y = Double.parseDouble(vertex.getProperty("axisY"));
                    double z = Double.parseDouble(vertex.getProperty("axisZ"));
                    Vector3D center = new Vector3D(x, y, z);
                    double angle = Double.parseDouble(vertex.getProperty("angle"));
                    Vector3D v1 = vertex.getPosition().minus(center);
                    Vector3D v2 = rotateJunction.getPosition().minus(center);
                    Vector3D v3 = v1.cross(v2);
                    rotateJunction.rotate(center, v3, angle);
                    junction = rotateJunction;
                } else {
                    log.info("RotateFrom junction could not be found, maybe it could not be placed.");
                }
            } else {
                log.fine("Placing junction " + name);
                junction = this.placeJunction(vertex, links, baseName, 0);
            }
            if (junction != null) {
                junction.setName(name + "_" + junction.getName());
                result.add(junction);
                this.junctionStatistics.updateCoverage(true);
                if (junction.getProperties() != null) {
                    String fitScoreString = junction.getProperties().getProperty("fit_score");
                    assert (fitScoreString != null);
                    double fitScore = Double.parseDouble(fitScoreString);
                    this.junctionStatistics.updateAverageAngle(fitScore);
                    this.junctionStatistics.updateAverageDistance(fitScore);
                }
                boolean junctionAlreadyUsed = false;
                for (int x = 0; x < usedJunctions.length; ++x) {
                    if (usedJunctions[x] != name) continue;
                    junctionAlreadyUsed = true;
                }
                if (junctionAlreadyUsed) continue;
                usedJunctions[usedJunctions.length - 1] = baseName;
                continue;
            }
            log.fine("Junction " + name + " could not be generated!");
            result.add(junction);
            Object3DSet neighbors = LinkTools.findNeighbors(objectSet.get(i), links);
            if (neighbors.size() > 1) {
                this.junctionStatistics.updateCoverage(false);
                continue;
            }
            log.fine("Cannot place hairpins yet!");
        }
        assert (result.size() == objectSet.size());
        log.fine("ended placeJunctions");
        return result;
    }

    @Test
    public void testPlaceJunctions() {
    }

    public void reset() {
        for (int i = 0; i < symmetryJunctions.length; ++i) {
            FragmentGridTiler.symmetryJunctions[i] = null;
        }
    }

    @Test
    public void testReset() {
    }

    public void setAppendStrandsMode(int mode) {
        this.appendStrandsMode = mode;
    }

    public void setAxialSteps(int steps) {
        this.axialSteps = steps;
    }

    public void setJunctionPlaceMode(boolean b) {
        this.junctionPlaceMode = b;
    }

    public void setConnectionAlgorithm(int n) {
        this.connectionAlgorithm = n;
    }

    public void setConnectJunctionsMode(boolean b) {
        this.connectJunctionsMode = b;
    }

    public void setForbiddenMode(boolean b) {
        this.forbiddenMode = b;
    }

    public void setFuseJunctionStrandsMode(boolean b) {
        this.fuseJunctionStrandsMode = b;
    }

    public void setFuseStrandCutoff(double cutoff) {
        this.fuseStrandCutoff = cutoff;
    }

    public void setJunctionFitParameters(FitParameters prm) {
        this.junctionFitParameters = prm;
    }

    public void setJunctionMinOrder(int n) {
        this.junctionMinOrder = n;
    }

    public void setJunctionStatistics(TilingStatistics stat) {
        this.junctionStatistics = stat;
    }

    public void setKissingLoopDB(StrandJunctionDB db) {
        this.kissingLoopDB = db;
    }

    public void setKissingLoopJunctionMode(boolean b) {
        this.kissingLoopJunctionMode = b;
    }

    public void setKissingLoopMode(boolean b) {
        this.kissingLoopMode = b;
    }

    public void setKissingLoopStatistics(TilingStatistics stat) {
        this.kissingLoopStatistics = stat;
    }

    public void setNucleotideDB(Object3D obj) {
        this.nucleotideDB = obj;
    }

    public void setOptimizeJunctionChoiceIterMax(int n) {
        this.optimizeJunctionChoiceIterMax = n;
    }

    public void setRerunMax(int n) {
        this.rerunMax = n;
    }

    public void setStemFitParameters(FitParameters prm) {
        this.stemFitParameters = prm;
    }

    public void setStemStatistics(TilingStatistics stat) {
        this.stemStatistics = stat;
    }

    public void setStrandJunctionDB(StrandJunctionDB db) {
        this.strandJunctionDB = db;
    }

    public void setSymmetryMode(boolean b) {
        this.symmetryMode = b;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("FragmentGridTiler: modes: appendStrand: " + this.appendStrandsMode + " placeJunctions: " + this.junctionPlaceMode + " connectJunctions: " + this.connectJunctionsMode + " forbiddenMode: " + this.forbiddenMode + " fuseJunctionsStrands: " + this.fuseJunctionStrandsMode + " kissingLoopJunction: " + this.kissingLoopJunctionMode + " kissingLoop: " + this.kissingLoopMode + " symmetry: " + this.symmetryMode + PackageConstants.ENDL);
        buf.append("Junction fit parameters " + this.junctionFitParameters.toString() + " Stem fit parameters: " + this.stemFitParameters.toString());
        return buf.toString();
    }

    private void copy(FragmentGridTiler fgTiler) {
        this.setAppendStrandsMode(fgTiler.getAppendStrandsMode());
        this.setAxialSteps(fgTiler.getAxialSteps());
        this.setJunctionPlaceMode(fgTiler.getJunctionPlaceMode());
        this.setConnectionAlgorithm(fgTiler.getConnectionAlgorithm());
        this.setConnectJunctionsMode(fgTiler.getConnectJunctionsMode());
        this.setForbiddenMode(fgTiler.getForbiddenMode());
        this.setFuseJunctionStrandsMode(fgTiler.getFuseJunctionStrandsMode());
        this.setFuseStrandCutoff(fgTiler.getFuseStrandCutoff());
        this.setJunctionFitParameters(new FitParameters(fgTiler.junctionFitParameters));
        this.setJunctionMinOrder(fgTiler.getJunctionMinOrder());
        this.setJunctionStatistics(new TilingStatistics(fgTiler.getJunctionStatistics()));
        this.setKissingLoopDB(fgTiler.getKissingLoopDB());
        this.setKissingLoopJunctionMode(fgTiler.getKissingLoopJunctionMode());
        this.setKissingLoopMode(fgTiler.getKissingLoopMode());
        this.setKissingLoopStatistics(new TilingStatistics(fgTiler.getKissingLoopStatistics()));
        this.setNucleotideDB(fgTiler.getNucleotideDB());
        this.setOptimizeJunctionChoiceIterMax(fgTiler.getOptimizeJunctionChoiceIterMax());
        this.setRerunMax(fgTiler.getRerunMax());
        this.setStemFitParameters(fgTiler.getStemFitParameters());
        this.setStemStatistics(new TilingStatistics(fgTiler.getStemStatistics()));
        this.setStrandJunctionDB(fgTiler.getStrandJunctionDB());
        this.setSymmetryMode(fgTiler.getSymmetryMode());
    }
}

