/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.CollectionTools;
import generaltools.TestTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.testng.annotations.Test;
import rnadesign.rnamodel.DBElementConnectionDescriptor;
import rnadesign.rnamodel.DBElementDescriptor;

public class GrowConnectivity {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private List<DBElementDescriptor> buildingBlocks = new ArrayList<DBElementDescriptor>();
    private List<DBElementConnectionDescriptor> connections = new ArrayList<DBElementConnectionDescriptor>();
    private boolean graphFlag = false;
    private int numGenerations = 4;
    private Set<String> topologies = new HashSet<String>();
    private int sizeMax = -1;
    private int nonEquivalentBuildingBlockCount = 0;
    private int nonEquivalentConnectionCount = 0;
    private boolean debugMode = false;

    public GrowConnectivity() {
    }

    public GrowConnectivity(List<DBElementDescriptor> buildingBlocks, List<DBElementConnectionDescriptor> connections, Set<String> topologies, int numGenerations) {
        this();
        assert (buildingBlocks != null && buildingBlocks.size() > 0);
        assert (!buildingBlocks.contains(null));
        assert (connections == null || !connections.contains(null));
        this.buildingBlocks = buildingBlocks;
        if (connections != null) {
            this.connections = connections;
        }
        if (topologies != null) {
            this.topologies = topologies;
        }
        this.numGenerations = numGenerations;
        this.update();
        assert (this.validate());
    }

    public void add(DBElementDescriptor buildingBlock) {
        this.buildingBlocks.add(buildingBlock);
        this.update();
    }

    public void add(DBElementConnectionDescriptor connection) {
        this.connections.add(connection);
        this.update();
    }

    public void addTopology(String topology) {
        this.topologies.add(topology);
        this.update();
    }

    public List<DBElementDescriptor> getBuildingBlocks() {
        return this.buildingBlocks;
    }

    private List<DBElementDescriptor> computeBuildingBlockRepresentatives() {
        ArrayList<DBElementDescriptor> result = new ArrayList<DBElementDescriptor>();
        HashSet<DBElementDescriptor> testSet = new HashSet<DBElementDescriptor>();
        for (DBElementDescriptor dbe : this.buildingBlocks) {
            DBElementDescriptor dbe2 = (DBElementDescriptor)dbe.clone();
            dbe2.setDescriptorId(0);
            if (!testSet.contains(dbe2)) {
                testSet.add(dbe2);
                result.add(dbe2);
                continue;
            }
            DBElementDescriptor rep = (DBElementDescriptor)CollectionTools.contains(testSet, dbe2);
            result.add(rep);
        }
        assert (result.size() == this.buildingBlocks.size());
        return result;
    }

    private int computeNonEquivalentBuildingBlockCount() {
        assert (this.validate());
        HashSet<DBElementDescriptor> testSet = new HashSet<DBElementDescriptor>();
        for (DBElementDescriptor dbe : this.buildingBlocks) {
            DBElementDescriptor dbe2 = (DBElementDescriptor)dbe.clone();
            dbe2.setDescriptorId(0);
            testSet.add(dbe2);
        }
        assert (testSet.size() <= this.buildingBlocks.size());
        return testSet.size();
    }

    @Test(groups={"new"})
    public void testComputeNonEquivalentBuildingBlockCount() {
        String methodName = "testComputeNonEquivalentBuildingBlockCount";
        System.out.println(TestTools.generateMethodHeader(methodName));
        DBElementDescriptor db1 = new DBElementDescriptor(2, 1, 1, 1);
        DBElementDescriptor db2 = new DBElementDescriptor(2, 1, 1, 2);
        DBElementDescriptor db3 = new DBElementDescriptor(2, 1, 1, 3);
        ArrayList<DBElementDescriptor> bbList = new ArrayList<DBElementDescriptor>();
        bbList.add(db1);
        bbList.add(db2);
        bbList.add(db3);
        GrowConnectivity connectivity = new GrowConnectivity(bbList, null, null, 3);
        System.out.println("Defined grow connectivity: " + connectivity);
        assert (connectivity.validate());
        assert (connectivity.getBuildingBlocks().size() == 3);
        assert (connectivity.getNonEquivalentBuildingBlockCount() == 1);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    @Test(groups={"new"})
    public void testComputeNonEquivalentConnectionCount() {
        String methodName = "testComputeNonEquivalentConnectionCount";
        System.out.println(TestTools.generateMethodHeader(methodName));
        DBElementDescriptor db1 = new DBElementDescriptor(2, 1, 1, 0);
        DBElementDescriptor db2 = new DBElementDescriptor(2, 1, 1, 1);
        DBElementDescriptor db3 = new DBElementDescriptor(2, 1, 1, 2);
        int bp = 5;
        String hx1 = "(hxend)1";
        String hx2 = "(hxend)2";
        String hx3 = "(hxend)3";
        DBElementConnectionDescriptor c1 = new DBElementConnectionDescriptor(db1, db2, hx1, hx2, bp);
        DBElementConnectionDescriptor c2 = new DBElementConnectionDescriptor(db2, db3, hx1, hx2, bp);
        DBElementConnectionDescriptor c3 = new DBElementConnectionDescriptor(db3, db1, hx1, hx2, bp);
        ArrayList<DBElementDescriptor> bbList = new ArrayList<DBElementDescriptor>();
        ArrayList<DBElementConnectionDescriptor> connList = new ArrayList<DBElementConnectionDescriptor>();
        bbList.add(db1);
        bbList.add(db2);
        bbList.add(db3);
        connList.add(c1);
        connList.add(c2);
        connList.add(c3);
        System.out.println("Defined 3 connections: ");
        for (DBElementConnectionDescriptor c : connList) {
            System.out.println(c);
        }
        GrowConnectivity connectivity = new GrowConnectivity(bbList, connList, null, 3);
        System.out.println("Defined grow connectivity: " + connectivity);
        assert (connectivity.validate());
        assert (connectivity.getBuildingBlocks().size() == 3);
        assert (connectivity.getNonEquivalentBuildingBlockCount() == 1);
        assert (connectivity.getConnections().size() == 3);
        assert (connectivity.getNonEquivalentConnectionCount() == 1);
        DBElementConnectionDescriptor c4 = new DBElementConnectionDescriptor(db1, db3, hx2, hx1, bp);
        System.out.println("Adding new connection: " + c4);
        System.out.println("Should be same as previous connection: " + c3);
        assert (c4.equals(c3));
        connectivity.add(c4);
        System.out.println("Defined grow connectivity after adding " + c4 + " : " + connectivity);
        assert (connectivity.getBuildingBlocks().size() == 3);
        assert (connectivity.getNonEquivalentBuildingBlockCount() == 1);
        assert (connectivity.getConnections().size() == 4);
        assert (connectivity.getNonEquivalentConnectionCount() == 1);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    private int computeNonEquivalentConnectionCount() {
        assert (this.validate());
        HashSet<DBElementConnectionDescriptor> testSet = new HashSet<DBElementConnectionDescriptor>();
        for (DBElementConnectionDescriptor dbc : this.connections) {
            DBElementConnectionDescriptor dbc2 = (DBElementConnectionDescriptor)dbc.clone();
            DBElementDescriptor deb1 = dbc2.getDescriptor1();
            DBElementDescriptor deb2 = dbc2.getDescriptor2();
            assert (deb1.compareTo(deb2) <= 0);
            deb1.setDescriptorId(0);
            deb2.setDescriptorId(0);
            DBElementConnectionDescriptor dbc3 = new DBElementConnectionDescriptor(deb1, deb2, dbc2.getHelixendName1(), dbc2.getHelixendName2(), dbc2.getBasePairCount());
            testSet.add(dbc3);
        }
        if (this.debugMode) {
            log.info("Set of non-equivalent connections: ");
            for (DBElementConnectionDescriptor conn : testSet) {
                System.out.println("" + conn);
            }
        }
        assert (testSet.size() <= this.connections.size());
        return testSet.size();
    }

    public int getNonEquivalentBuildingBlockCount() {
        assert (this.nonEquivalentBuildingBlockCount == this.computeNonEquivalentBuildingBlockCount());
        return this.nonEquivalentBuildingBlockCount;
    }

    public int getNonEquivalentConnectionCount() {
        assert (this.nonEquivalentConnectionCount == this.computeNonEquivalentConnectionCount());
        return this.nonEquivalentConnectionCount;
    }

    public List<DBElementConnectionDescriptor> getConnections() {
        return this.connections;
    }

    public int getNumGenerations() {
        return this.numGenerations;
    }

    public Set<String> getTopologies() {
        return this.topologies;
    }

    public int getSizeMax() {
        return this.sizeMax;
    }

    public boolean isGraphFlag() {
        return this.graphFlag;
    }

    public void setGraphFlag(boolean b) {
        this.graphFlag = b;
    }

    public void setNumGenerations(int n) {
        this.numGenerations = n;
    }

    public void setSizeMax(int size) {
        this.sizeMax = size;
    }

    private static String toStringBlock(DBElementDescriptor dbe) {
        String result = DBElementDescriptor.getTypeString(dbe.getType()) + "," + dbe.getOrder() + "," + (dbe.getId() + 1) + "," + dbe.getDescriptorId();
        return result;
    }

    private static String toStringConnection(DBElementConnectionDescriptor dcd) {
        return "" + (dcd.getDescriptor1().getDescriptorId() + 1) + "," + (dcd.getDescriptor2().getDescriptorId() + 1) + "," + dcd.getHelixendName1() + "," + dcd.getHelixendName2() + "," + dcd.getBasePairCount();
    }

    private String toStringBlocks() {
        StringBuffer result = new StringBuffer();
        result.append("blocks=");
        for (int i = 0; i < this.buildingBlocks.size(); ++i) {
            result.append(GrowConnectivity.toStringBlock(this.buildingBlocks.get(i)));
            if (i + 1 >= this.buildingBlocks.size()) continue;
            result.append(";");
        }
        return result.toString();
    }

    private String toStringConnections() {
        StringBuffer result = new StringBuffer();
        result.append("connect=");
        for (int i = 0; i < this.connections.size(); ++i) {
            result.append(GrowConnectivity.toStringConnection(this.connections.get(i)));
            if (i + 1 >= this.connections.size()) continue;
            result.append(";");
        }
        return result.toString();
    }

    public String toString() {
        String result = this.toStringBlocks() + " " + this.toStringConnections() + " gen=" + this.numGenerations + " graph=" + this.graphFlag;
        return result;
    }

    private void update() {
        this.nonEquivalentBuildingBlockCount = this.computeNonEquivalentBuildingBlockCount();
        this.nonEquivalentConnectionCount = this.computeNonEquivalentConnectionCount();
    }

    public boolean validate() {
        boolean check1;
        boolean bl = check1 = this.buildingBlocks != null && this.buildingBlocks.size() > 0 && this.connections != null;
        if (!check1) {
            return false;
        }
        for (DBElementDescriptor dbe : this.buildingBlocks) {
            if (dbe != null) continue;
            return false;
        }
        for (DBElementConnectionDescriptor dbc : this.connections) {
            if (dbc != null) continue;
            return false;
        }
        return true;
    }
}

