/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.logging.Logger;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.BranchDescriptorPotential;
import rnadesign.rnamodel.KissingLoop3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DPotential;

public class KissingLoopPotential
implements Object3DPotential {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private BranchDescriptorPotential branch1Potential;
    private BranchDescriptorPotential branch2Potential;

    public KissingLoopPotential(BranchDescriptor3D branch1, BranchDescriptor3D branch2) {
        this.branch1Potential = new BranchDescriptorPotential(branch1);
        this.branch2Potential = new BranchDescriptorPotential(branch2);
    }

    @Override
    public double computeValue(Object3D obj) {
        double result;
        double dobj;
        assert (obj instanceof KissingLoop3D);
        KissingLoop3D kissingLoop = (KissingLoop3D)obj;
        assert (kissingLoop.getBranchCount() == 2);
        BranchDescriptor3D b1 = kissingLoop.getBranch(0);
        BranchDescriptor3D b2 = kissingLoop.getBranch(1);
        double d = this.branch1Potential.getBranch().distance(this.branch2Potential.getBranch());
        double distdist = 0.5 * Math.abs(d - (dobj = b1.distance(b2)));
        if (distdist == 0.0) {
            log.warning("kissing loop too large!");
            distdist = 0.001;
        }
        double d11 = this.branch1Potential.getBranch().distance(b1);
        double d21 = this.branch2Potential.getBranch().distance(b2);
        double d12 = this.branch1Potential.getBranch().distance(b1);
        double d22 = this.branch2Potential.getBranch().distance(b2);
        double term1a = 0.5 * (this.branch1Potential.computeValue(kissingLoop.getBranch(0)) + this.branch2Potential.computeValue(kissingLoop.getBranch(1)));
        double term2a = 0.5 * (this.branch1Potential.computeValue(kissingLoop.getBranch(1)) + this.branch2Potential.computeValue(kissingLoop.getBranch(0)));
        double term1 = Math.abs(Math.sqrt(0.5 * (d11 * d11 + d21 * d21)) - distdist) / distdist;
        double term2 = Math.abs(Math.sqrt(0.5 * (d12 * d12 + d22 * d22)) - distdist) / distdist;
        if (term2 + term2a < (result = term1 + term1a)) {
            result = term2 + term2a;
        }
        return result;
    }
}

