/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

public class RnaPhysicalProperties {
    public static final double DEG2RAD = Math.PI / 180;
    public static final double RAD2DEG = 57.29577951308232;
    public static final double RNA_SINGLESTRAND_LENGTH_PER_RESIDUE = 5.0;
    public static final double RNA_DOUBLESTRAND_LENGTH_PER_RESIDUE = 3.0;
    public static final double RNA_SINGLESTRAND_WIDTH = 5.0;
    public static final double RNA_AVERAGE_BASE_RADIUS = 3.0;
    public static final double RNA_DOUBLESTRAND_WIDTH = 10.0;
    public static final double RNA_BP_DISTANCE = 3.5;
    public static final double RNA_BP_DISTANCE_TOLERANCE = 0.5;
    public static final double RNA_BP_ANGLE = 0.6283185307179586;
    public static final double RNA_BP_ANGLE_TOLERANCE = 0.08726646259971647;
    public static final double RNA_BP_BEND = 0.0;
    public static final double RNA_BP_BEND_TOLERANCE = 0.08726646259971647;

    public static double computeSingleStrandLength(int nResidues) {
        return (double)nResidues * 5.0;
    }

    public static double getSingleStrandWidth() {
        return 5.0;
    }

    public static double computeDoubleStrandLength(int nResidues) {
        return (double)nResidues * 3.0;
    }

    public static double getDoubleStrandWidth() {
        return 10.0;
    }

    public static double getAverageBaseRadius() {
        return 3.0;
    }
}

