/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.AlgorithmFailureException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import launchtools.Job;
import launchtools.SimpleQueueManager;
import launchtools.SimpleRunCommand;
import org.testng.annotations.Test;
import rnadesign.rnamodel.AtomTools;
import rnadesign.rnamodel.HeteroAtomPdbWriter;
import rnadesign.rnamodel.PackageConstants;
import tools3d.Vector3D;
import tools3d.objects3d.GraphCanonizer;
import tools3d.objects3d.GraphWriter;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.SimpleLink;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class SignatureTranslatorCanonizer
implements GraphCanonizer {
    private String nameBase = "signature_graph";
    private static ResourceBundle rb = ResourceBundle.getBundle("NanoTiler");
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean debugMode = false;
    private String programName = "tra";

    @Override
    public String generateCanonizedRepresentation(Object3DLinkSetBundle graph) throws AlgorithmFailureException {
        List<String> resultLines;
        Object3DLinkSetBundle moleculeBundle = AtomTools.convertGraphToMolecule(graph.getObject3D(), graph.getLinks(), this.nameBase);
        HeteroAtomPdbWriter writer = new HeteroAtomPdbWriter();
        try {
            File tmpFile = File.createTempFile("signature", ".bgf");
            if (!this.debugMode) {
                tmpFile.deleteOnExit();
            }
            String fileName = tmpFile.getAbsolutePath();
            FileOutputStream fos = new FileOutputStream(fileName);
            PrintStream ps = new PrintStream(fos);
            String content = writer.toString(moleculeBundle);
            ps.println(content);
            fos.close();
            if (this.debugMode) {
                log.info("wrote temporary polygraf file: " + content);
            }
            String tmpFileNameBase = fileName.substring(0, fileName.length() - 4);
            String commandString = this.programName + " " + tmpFileNameBase + " polygraf canonize";
            log.fine("Launching command with string: " + commandString);
            String[] commandWords = commandString.split(" ");
            SimpleRunCommand command = new SimpleRunCommand(commandWords);
            SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
            Job job = queueManager.createJob(command);
            queueManager.submit(job);
            resultLines = job.getRunInfo().getLines();
            if (!this.debugMode) {
                boolean deletionResult = tmpFile.delete();
                if (!deletionResult) {
                    log.warning("Could not delete file: " + fileName);
                }
                assert (!tmpFile.exists());
                File file2 = new File(tmpFileNameBase + "_out.bgf");
                if (file2.exists()) {
                    boolean deletionResult2 = file2.delete();
                    assert (deletionResult2);
                } else {
                    log.warning("Could not find signature result file: " + file2.getAbsolutePath());
                }
            }
        }
        catch (IOException ioe) {
            throw new AlgorithmFailureException(ioe.getMessage());
        }
        if (resultLines == null) {
            throw new AlgorithmFailureException("No output from signature translation program received!");
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < resultLines.size(); ++i) {
            buf.append(resultLines.get(i) + PackageConstants.NEWLINE);
        }
        String result = buf.toString().trim();
        assert (result != null);
        if (result.length() == 0) {
            throw new AlgorithmFailureException("Output from signature translation program has zero length! Maybe signature generater help program is not installed?");
        }
        result = this.processRawCanonizedString(result);
        assert (result != null);
        if (result.length() == 0) {
            throw new AlgorithmFailureException("Processed output from signature translation program has zero length! Maybe signature generater help program is not installed?");
        }
        return result;
    }

    String processRawCanonizedString(String canonicString) {
        String[] words;
        canonicString = canonicString.replace('\n', ';');
        if ((canonicString = canonicString.replace(' ', '%')).charAt(canonicString.length() - 1) == ';') {
            canonicString = canonicString.substring(0, canonicString.length() - 1);
        }
        StringBuffer buf = new StringBuffer();
        for (String word : words = canonicString.split(";")) {
            if (word.indexOf("[") < 0) continue;
            buf.append(word);
            buf.append(";");
        }
        String result = buf.toString();
        if (result.length() > 0 && result.charAt(result.length() - 1) == ';') {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    @Test(groups={"new"})
    public void testGenerateCanonizedRepresentation() {
        block7: {
            String result;
            GraphWriter writer;
            String correctAnswer2;
            SimpleObject3DLinkSetBundle fullGraph;
            SimpleLinkSet links;
            SimpleObject3D p4;
            SimpleObject3D p2;
            SimpleObject3D p1;
            SimpleObject3D rawGraph;
            block6: {
                rawGraph = new SimpleObject3D();
                rawGraph.setName("test_graph");
                p1 = new SimpleObject3D(new Vector3D(0.0, 0.0, 0.0));
                p2 = new SimpleObject3D(new Vector3D(100.0, 0.0, 0.0));
                SimpleObject3D p3 = new SimpleObject3D(new Vector3D(0.0, 100.0, 0.0));
                p4 = new SimpleObject3D(new Vector3D(0.0, 0.0, 100.0));
                links = new SimpleLinkSet();
                p1.setName("p1");
                p2.setName("p2");
                p3.setName("p3");
                p3.setProperty("atom_element", "S");
                links.add(new SimpleLink(p1, p2));
                links.add(new SimpleLink(p2, p3));
                links.add(new SimpleLink(p1, p3));
                rawGraph.insertChild(p1);
                rawGraph.insertChild(p2);
                rawGraph.insertChild(p3);
                fullGraph = new SimpleObject3DLinkSetBundle(rawGraph, links);
                String correctAnswer1 = "[s_]([o_]([o_,1])[o_,1])";
                correctAnswer2 = "[s_]([n_]([n_,1][o_,2])[n_,1]([o_,2]))";
                writer = new GraphWriter();
                System.out.println("Calling canonizer for graph: " + writer.toString(fullGraph));
                try {
                    result = this.generateCanonizedRepresentation(fullGraph);
                    System.out.println("The canonized output is: " + result);
                    assert (correctAnswer1.equals(result));
                }
                catch (AlgorithmFailureException afe) {
                    System.out.println("Error canonizing graph: " + afe.getMessage());
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
            rawGraph.insertChild(p4);
            links.add(new SimpleLink(p1, p4));
            links.add(new SimpleLink(p2, p4));
            System.out.println("Calling canonizer for graph: " + writer.toString(fullGraph));
            try {
                result = this.generateCanonizedRepresentation(fullGraph);
                System.out.println("The canonized output is: " + result);
                assert (correctAnswer2.equals(result));
            }
            catch (AlgorithmFailureException afe) {
                System.out.println("Error canonizing graph: " + afe.getMessage());
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
    }

    @Test(groups={"new"})
    public void testGenerateCanonizedRepresentation2() {
        block3: {
            SimpleObject3D rawGraph = new SimpleObject3D();
            rawGraph.setName("test_graph");
            SimpleObject3D p1 = new SimpleObject3D(new Vector3D(0.0, 0.0, 0.0));
            SimpleObject3D p2 = new SimpleObject3D(new Vector3D(100.0, 0.0, 0.0));
            SimpleObject3D p3 = new SimpleObject3D(new Vector3D(0.0, 100.0, 0.0));
            SimpleObject3D p4 = new SimpleObject3D(new Vector3D(0.0, 0.0, 100.0));
            SimpleLinkSet links = new SimpleLinkSet();
            p1.setName("p1");
            p2.setName("p2");
            p3.setName("p3");
            p3.setName("p4");
            p2.setProperty("atom_element", "S");
            p4.setProperty("atom_element", "S");
            links.add(new SimpleLink(p1, p2));
            links.add(new SimpleLink(p2, p3));
            links.add(new SimpleLink(p3, p4));
            links.add(new SimpleLink(p1, p4));
            rawGraph.insertChild(p1);
            rawGraph.insertChild(p2);
            rawGraph.insertChild(p3);
            rawGraph.insertChild(p4);
            SimpleObject3DLinkSetBundle fullGraph = new SimpleObject3DLinkSetBundle(rawGraph, links);
            String correctAnswer1 = "[s_]([o_]([o_,1])[o_,1])";
            GraphWriter writer = new GraphWriter();
            System.out.println("Calling canonizer for graph: " + writer.toString(fullGraph));
            try {
                String result = this.generateCanonizedRepresentation(fullGraph);
                System.out.println("The canonized output is: " + result);
                p2.setProperty("atom_element", "O");
                p4.setProperty("atom_element", "O");
                p1.setProperty("atom_element", "S");
                p3.setProperty("atom_element", "S");
                String result2 = this.generateCanonizedRepresentation(fullGraph);
                System.out.println("The canonized output of the relable graph is: " + result2);
                assert (result.equals(result2));
            }
            catch (AlgorithmFailureException afe) {
                System.out.println("Error canonizing graph: " + afe.getMessage());
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    @Test(groups={"new"})
    public void testGenerateCanonizedRepresentation3() {
        block3: {
            SimpleObject3D rawGraph = new SimpleObject3D();
            rawGraph.setName("test_graph");
            SimpleObject3D p1 = new SimpleObject3D(new Vector3D(0.0, 0.0, 0.0));
            SimpleObject3D p2 = new SimpleObject3D(new Vector3D(0.0, 0.0, 0.0));
            SimpleObject3D p3 = new SimpleObject3D(new Vector3D(0.0, 0.0, 0.0));
            SimpleObject3D p4 = new SimpleObject3D(new Vector3D(0.0, 0.0, 0.0));
            SimpleLinkSet links = new SimpleLinkSet();
            p1.setName("p1");
            p2.setName("p2");
            p3.setName("p3");
            p3.setName("p4");
            p2.setProperty("atom_element", "S");
            p4.setProperty("atom_element", "S");
            links.add(new SimpleLink(p1, p2));
            links.add(new SimpleLink(p2, p3));
            links.add(new SimpleLink(p3, p4));
            links.add(new SimpleLink(p1, p4));
            rawGraph.insertChild(p1);
            rawGraph.insertChild(p2);
            rawGraph.insertChild(p3);
            rawGraph.insertChild(p4);
            SimpleObject3DLinkSetBundle fullGraph = new SimpleObject3DLinkSetBundle(rawGraph, links);
            String correctAnswer1 = "[s_]([o_]([o_,1])[o_,1])";
            GraphWriter writer = new GraphWriter();
            System.out.println("Calling canonizer for graph: " + writer.toString(fullGraph));
            try {
                String result = this.generateCanonizedRepresentation(fullGraph);
                System.out.println("The canonized output is: " + result);
                p2.setProperty("atom_element", "O");
                p4.setProperty("atom_element", "O");
                p1.setProperty("atom_element", "S");
                p3.setProperty("atom_element", "S");
                String result2 = this.generateCanonizedRepresentation(fullGraph);
                System.out.println("The canonized output of the relable graph is: " + result2);
                assert (result.equals(result2));
            }
            catch (AlgorithmFailureException afe) {
                System.out.println("Error canonizing graph: " + afe.getMessage());
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }
}

