/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.ResultWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideDBTools;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.RnaModelException;
import rnadesign.rnamodel.RnaStrand;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;

public class SimpleStrandFuser
extends ResultWorker {
    private Logger log = Logger.getLogger("NanoTiler_debug");
    public static final int STRAND_FUSION_MAX = 20;
    private static final double STRAND_DIST_MAX = 7.0;
    private static final double STRAND_ANGLE_MAX = 2.356194490192345;
    private static final double ANGLE_PENALTY = 50.0;
    private static final double STRAND_CONNECTION_SCORE_CUTOFF = 50.0;
    private static final String TMP_TOKEN = "__RINGFUSE_STATUS";
    private static final String TMP_TOKEN_OCCUPIED = "occupied";
    private double scoreCutoff = 50.0;
    private static boolean debugMode = true;
    private List<RnaStrand> strands = new ArrayList<RnaStrand>();

    public SimpleStrandFuser(List<RnaStrand> strands) {
        this.strands.addAll(strands);
        this.log.info("Initial strands: " + strands.size() + " cleaned version: " + this.strands.size());
    }

    public SimpleStrandFuser(Object3DSet strandSet) {
        for (int i = 0; i < strandSet.size(); ++i) {
            Object3D obj = strandSet.get(i);
            if (obj instanceof RnaStrand) {
                this.strands.add((RnaStrand)obj);
                continue;
            }
            this.log.severe("Internal error in RingFuse: 3D object is not RNA strand: " + obj.getFullName() + " " + obj.getClassName());
            assert (false);
        }
        this.log.info("Initial strands: " + strandSet.size() + " cleaned version: " + this.strands.size());
    }

    @Override
    public void runInternal() {
        this.log.info("Starting automatic strand fusing for " + this.strands.size() + " strands !");
        Properties properties = new Properties();
        double bestScore = 1.0E10;
        int bestI = 0;
        int bestJ = 0;
        for (int i = 0; i < this.strands.size(); ++i) {
            if (!this.checkStrandAvailable(this.strands.get(i))) continue;
            for (int j = 0; j < this.strands.size(); ++j) {
                if (!this.checkStrandAvailable(this.strands.get(j))) continue;
                try {
                    double score = this.scoreStrandConnectivity(this.strands.get(i), this.strands.get(j));
                    if (!(score < bestScore)) continue;
                    bestScore = score;
                    bestI = i;
                    bestJ = j;
                    continue;
                }
                catch (RnaModelException rne) {
                    // empty catch block
                }
            }
            this.result = properties;
        }
        if (bestScore < this.scoreCutoff) {
            properties.setProperty("strand1", this.strands.get(bestI).getName());
            properties.setProperty("strand2", this.strands.get(bestJ).getName());
            properties.setProperty("score", "" + bestScore);
            this.log.info("Fusing strands " + this.strands.get(bestI).getFullName() + " and " + this.strands.get(bestJ).getFullName());
            this.strands.get(bestI).appendAndDelete(this.strands.get(bestJ));
        } else {
            this.log.info("Could not find any candidates for fusing strands: " + bestScore);
        }
    }

    private boolean checkStrandAvailable(NucleotideStrand strand) {
        return strand.getProperty(TMP_TOKEN) != TMP_TOKEN_OCCUPIED;
    }

    public void setScoreCutoff(double value) {
        this.scoreCutoff = value;
    }

    private void setStrandOccupied(NucleotideStrand strand) {
        strand.setProperty(TMP_TOKEN, TMP_TOKEN_OCCUPIED);
    }

    private double scoreStrandConnectivity(RnaStrand startStrand, RnaStrand endStrand) throws RnaModelException {
        Nucleotide3D startStrandResidue = (Nucleotide3D)startStrand.getResidue3D(startStrand.getResidueCount() - 1);
        Nucleotide3D endStrandResidue = (Nucleotide3D)endStrand.getResidue3D(0);
        Object3D ao21 = startStrandResidue.getChild("O2*");
        Object3D ap2 = endStrandResidue.getChild("P");
        if (ap2 == null) {
            NucleotideDBTools.addMissingPhosphor(endStrandResidue);
            ap2 = endStrandResidue.getChild("P");
            assert (ap2 != null);
        }
        if (ao21 == null) {
            throw new RnaModelException("Could not find atom O2* in residue: " + startStrandResidue.getFullName());
        }
        double distance = ao21.distance(ap2);
        Vector3D v1 = NucleotideDBTools.getBackwardDirectionVector(startStrandResidue, "C4*");
        Vector3D v2 = NucleotideDBTools.getForwardDirectionVector(endStrandResidue, "C4*");
        double angle = Math.PI - v1.angle(v2);
        if (distance > 7.0) {
            distance += this.scoreCutoff + 1.0;
        }
        if (angle > 2.356194490192345) {
            distance += 50.0;
        }
        return distance;
    }
}

