/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.Randomizer;
import graphtools.PermutationGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import numerictools.IntegerArrayTools;
import numerictools.PotentialND;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.ConnectJunctionTools;
import rnadesign.rnamodel.RnaConstants;
import rnadesign.rnamodel.SimpleBranchDescriptor3D;
import rnadesign.rnamodel.SimpleConnectivityIterator;
import tools3d.GeometryTools;
import tools3d.Matrix3D;
import tools3d.Matrix3DTools;
import tools3d.Vector3D;
import tools3d.Vector3DTools;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class TraceRnaGraphPotential
implements PotentialND {
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private LinkSet links;
    private Object3DSet objSet;
    private int[][] bestPerms;
    private List<List<Integer>> linkIds;
    private List<BranchDescriptor3D> branchDescriptors;
    private List<Integer> helixLengths;
    private double turnHeight;
    private double offset;
    private double distMax = 10.0;
    private double distMin = 5.0;
    private double collisionDistance = 4.0;
    private double collisionPenalty = 0.0;
    private int verboseLevel = 1;
    private char c1 = (char)71;
    private char c2 = (char)67;
    private double crossingDistanceLimit = 7.0;
    private boolean generateBridgesMode = true;

    public TraceRnaGraphPotential(Object3DSet objSet, LinkSet links, double turnHeight, double offset, double distMax, double distMin) {
        assert (TraceRnaGraphPotential.validate(objSet, links, turnHeight, offset));
        this.links = links;
        this.objSet = objSet;
        this.turnHeight = turnHeight;
        this.offset = offset;
        this.distMax = distMax;
        this.distMin = distMin;
        this.init();
        assert (this.validate());
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void setVerboseLevel(int n) {
        this.verboseLevel = n;
    }

    public static boolean validate(double edgeDistance, double turnHeight, double offset) {
        double helLen = edgeDistance - 2.0 * offset;
        return helLen > RnaConstants.HELIX_RISE;
    }

    public static boolean validate(Object3DSet objSet, LinkSet links, double turnHeight, double offset) {
        for (int i = 0; i < links.size(); ++i) {
            if (TraceRnaGraphPotential.validate(links.get(i).getObj1().distance(links.get(i).getObj2()), turnHeight, offset)) continue;
            return false;
        }
        return true;
    }

    private void updateBranchDescriptor(int n, Vector3D startPos, Vector3D endPos) {
        int startId = this.getBranchDescriptorStartVertexId(n);
        int stopId = this.getBranchDescriptorStopVertexId(n);
        Vector3D startPosOrig = this.objSet.get(startId).getPosition();
        Vector3D stopPosOrig = this.objSet.get(stopId).getPosition();
        Vector3D shift = startPos.minus(startPosOrig);
    }

    private int getBranchDescriptorStartVertexId(int n) {
        assert (false);
        return 0;
    }

    private int getBranchDescriptorStopVertexId(int n) {
        assert (false);
        return 0;
    }

    private Vector3D extractPosition(double[] anglesAndPositions, int n) {
        int offset = this.branchDescriptors.size();
        int pc = offset + n * 3;
        assert (pc + 2 < anglesAndPositions.length);
        return new Vector3D(anglesAndPositions[pc], anglesAndPositions[pc + 1], anglesAndPositions[pc + 2]);
    }

    private void updateBranchDescriptor(double[] anglesAndPositions, int n) {
        int startId = this.getBranchDescriptorStartVertexId(n);
        int stopId = this.getBranchDescriptorStopVertexId(n);
        assert (startId != stopId);
        Vector3D startPos = this.extractPosition(anglesAndPositions, startId);
        Vector3D stopPos = this.extractPosition(anglesAndPositions, stopId);
        this.updateBranchDescriptor(n, startPos, stopPos);
    }

    private void updateBranchDescriptors(double[] anglesAndPositions) {
        for (int i = 0; i < this.objSet.size(); ++i) {
            Vector3D pos = this.extractPosition(anglesAndPositions, i);
            this.objSet.get(i).setPosition(pos);
        }
        this.initHelices();
    }

    public Object3DLinkSetBundle generateRna(double[] anglesAndPositions, String baseName, Object3D nucleotideDB) {
        assert (anglesAndPositions != null && baseName != null && Object3DTools.validateName(baseName) && nucleotideDB != null);
        System.out.println("Starting generateRna...");
        this.log.info("Starting generateRna");
        assert (false);
        double value = this.getValue(anglesAndPositions);
        SimpleObject3D root = new SimpleObject3D(baseName);
        SimpleLinkSet links = new SimpleLinkSet();
        for (int i = 0; i < this.branchDescriptors.size(); ++i) {
            String name = baseName + "_" + (i + 1);
            int len = this.helixLengths.get(i);
            BranchDescriptor3D bd = this.branchDescriptors.get(i);
            Object3DLinkSetBundle helixBundle = ConnectJunctionTools.generateIdealStem(this.branchDescriptors.get(i), this.c1, this.c2, name, nucleotideDB, len);
            Matrix3D rotMatrix = Matrix3DTools.rotationMatrix(bd.getDirection(), anglesAndPositions[i]);
            Object3D obj = helixBundle.getObject3D();
            obj.rotate(bd.getPosition(), rotMatrix);
            root.insertChild(obj);
            links.merge(helixBundle.getLinks());
        }
        this.log.info("Finished generateRna");
        System.out.println("Finished generateRna...");
        return new SimpleObject3DLinkSetBundle(root, links);
    }

    private List<Integer> generateObjectLinkIds(int n) {
        assert (n >= 0 && n < this.objSet.size());
        ArrayList<Integer> result = new ArrayList<Integer>();
        Object3D obj = this.objSet.get(n);
        for (int i = 0; i < this.links.size(); ++i) {
            Link link = this.links.get(i);
            int order = link.linkOrder(obj);
            assert (order < 2);
            if (order == 1) {
                result.add(i);
                continue;
            }
            assert (order == 0);
        }
        assert (result != null);
        return result;
    }

    private void init() {
        assert (this.links != null);
        this.linkIds = new ArrayList<List<Integer>>();
        for (int i = 0; i < this.objSet.size(); ++i) {
            this.linkIds.add(this.generateObjectLinkIds(i));
        }
        this.initHelices();
        this.bestPerms = new int[this.objSet.size()][0];
        assert (this.validate());
    }

    private void initHelix(Vector3D p1Pos, Vector3D p2Pos) {
        Vector3D dir = p2Pos.minus(p1Pos);
        double helLen = dir.length() - 2.0 * this.offset;
        assert (helLen > 0.0);
        assert (dir.length() > 0.0);
        dir.normalize();
        Vector3D base = p1Pos.plus(dir.mul(this.offset));
        Vector3D y = Vector3DTools.generateRandomOrthogonalDirection(dir);
        Vector3D x = y.cross(dir);
        CoordinateSystem3D cs = new CoordinateSystem3D(base, x, y);
        SimpleBranchDescriptor3D bd = new SimpleBranchDescriptor3D(new CoordinateSystem3D(Vector3D.ZVEC));
        bd.setCoordinateSystem(cs);
        this.branchDescriptors.add(bd);
        int numBp = SimpleConnectivityIterator.estimateNumberBasePairs(helLen);
        this.helixLengths.add(numBp);
    }

    private void initHelix(int n) {
        Link link = this.links.get(n);
        assert (link.getObj1() != link.getObj2());
        this.initHelix(link.getObj1().getPosition(), link.getObj2().getPosition());
    }

    private void initHelices() {
        this.branchDescriptors = new ArrayList<BranchDescriptor3D>();
        this.helixLengths = new ArrayList<Integer>();
        for (int i = 0; i < this.links.size(); ++i) {
            this.initHelix(i);
        }
    }

    public boolean validate() {
        boolean check3;
        boolean check2;
        boolean check1;
        boolean bl = check1 = this.branchDescriptors != null && this.helixLengths != null && this.links != null && this.objSet != null && this.linkIds != null;
        if (!check1) {
            return false;
        }
        boolean bl2 = check2 = this.links.size() == this.branchDescriptors.size() && this.links.size() == this.helixLengths.size();
        if (!check2) {
            return false;
        }
        boolean bl3 = check3 = this.objSet.size() == this.linkIds.size();
        return check3;
    }

    @Override
    public double[] generateLowPosition() {
        int i;
        double[] result = new double[this.getDimension()];
        Random rand = Randomizer.getInstance();
        int pc = 0;
        for (i = 0; i < this.links.size(); ++i) {
            assert (pc < result.length);
            result[pc++] = Math.PI * 2 * rand.nextDouble();
        }
        for (i = 0; i < this.objSet.size(); ++i) {
            int id = pc + i * 3;
            assert (id + 2 < result.length);
            Vector3D pos = this.objSet.get(i).getPosition();
            result[id] = pos.getX();
            result[id + 1] = pos.getY();
            result[id + 2] = pos.getZ();
        }
        return result;
    }

    @Override
    public double[] generateHighPosition() {
        return this.generateLowPosition();
    }

    @Override
    public int getDimension() {
        return this.links.size() + 3 * this.objSet.size();
    }

    @Override
    public double getValue(double[] anglesAndPositions) {
        this.updateBranchDescriptors(anglesAndPositions);
        double sum = 0.0;
        for (int i = 0; i < this.objSet.size(); ++i) {
            sum += this.computeVertexValue(anglesAndPositions, i);
        }
        return sum;
    }

    private double computeStrandConnectionValue(Vector3D posFive, Vector3D posThree) {
        double dist = posFive.distance(posThree);
        if (dist > this.distMax) {
            return dist - this.distMax;
        }
        if (dist < this.distMin) {
            return this.distMin - dist;
        }
        return 0.0;
    }

    private double getVertexValue(Vector3D[] posFive, Vector3D[] posThree, int[] perm) {
        assert (posFive.length == posThree.length);
        assert (perm.length + 1 == posFive.length);
        double sum = 0.0;
        ArrayList<Vector3D> startPositions = new ArrayList<Vector3D>();
        ArrayList<Vector3D> endPositions = new ArrayList<Vector3D>();
        for (int i = 1; i < perm.length; ++i) {
            sum += this.computeStrandConnectionValue(posFive[perm[i - 1]], posThree[perm[i]]);
            startPositions.add(posFive[perm[i - 1]]);
            endPositions.add(posThree[perm[i]]);
        }
        Vector3D lastFivePos1 = posFive[perm[perm.length - 1]];
        Vector3D firstThreePos1 = posThree[posThree.length - 1];
        Vector3D lastFivePos2 = posFive[posFive.length - 1];
        Vector3D firstThreePos2 = posThree[perm[0]];
        startPositions.add(lastFivePos1);
        endPositions.add(firstThreePos1);
        sum += this.computeStrandConnectionValue(lastFivePos1, firstThreePos1);
        startPositions.add(lastFivePos2);
        endPositions.add(firstThreePos2);
        sum += this.computeStrandConnectionValue(lastFivePos2, firstThreePos2);
        return sum += this.scoreLineCrossings(startPositions, endPositions);
    }

    private double scoreLineCrossing(Vector3D p0, Vector3D p1, Vector3D q0, Vector3D q1) {
        Vector3D u = p1.minus(p0);
        Vector3D v = q1.minus(q0);
        assert (u.lengthSquare() > 0.0);
        assert (v.lengthSquare() > 0.0);
        double dist = GeometryTools.distanceOfLines(p0, u, q0, v);
        double result = 0.0;
        if (dist < this.crossingDistanceLimit) {
            result = this.crossingDistanceLimit - dist;
        }
        return result;
    }

    private double scoreLineCrossings(List<Vector3D> startPositions, List<Vector3D> stopPositions) {
        assert (startPositions.size() == stopPositions.size());
        double sum = 0.0;
        for (int i = 0; i < startPositions.size(); ++i) {
            for (int j = i + 1; j < startPositions.size(); ++j) {
                sum += this.scoreLineCrossing(startPositions.get(i), stopPositions.get(i), startPositions.get(j), stopPositions.get(j));
            }
        }
        return sum;
    }

    private int countCollisions(Vector3D[] pv, double distance) {
        int result = 0;
        for (int i = 0; i < pv.length; ++i) {
            for (int j = i + 1; j < pv.length; ++j) {
                if (!(pv[i].distance(pv[j]) < distance)) continue;
                ++result;
            }
        }
        return result;
    }

    private int countCollisions(Vector3D[] posFive, Vector3D[] posThree, double distance) {
        int result = this.countCollisions(posFive, distance) + this.countCollisions(posThree, distance);
        for (int i = 0; i < posFive.length; ++i) {
            for (int j = 0; j < posThree.length; ++j) {
                if (!(posFive[i].distance(posThree[j]) < distance)) continue;
                ++result;
            }
        }
        return result;
    }

    private double computeVertexValue(Vector3D[] posFive, Vector3D[] posThree, int vertexId) {
        assert (posFive.length == posThree.length);
        int order = posFive.length;
        if (order < 2) {
            return 0.0;
        }
        PermutationGenerator perm = new PermutationGenerator(order - 1);
        double bestScore = 1.0E30;
        do {
            int[] pm;
            double score;
            if (!((score = this.getVertexValue(posFive, posThree, pm = perm.get())) < bestScore)) continue;
            bestScore = score;
            this.bestPerms[vertexId] = IntegerArrayTools.clone(pm);
        } while (perm.hasNext() && perm.inc());
        bestScore = this.collisionPenalty * (double)this.countCollisions(posFive, posThree, this.collisionDistance);
        return bestScore;
    }

    private double computeVertexValue(double[] angles, int vertexId) {
        Vector3D[] posFiveVec = this.computeFivePrimePositions(angles, vertexId);
        Vector3D[] posThreeVec = this.computeThreePrimePositions(angles, vertexId);
        return this.computeVertexValue(posFiveVec, posThreeVec, vertexId);
    }

    private boolean hasBranchDescriptor(int linkId, int vertexId) {
        assert (linkId >= 0 && linkId < this.links.size());
        assert (vertexId >= 0 && vertexId < this.objSet.size());
        Link link = this.links.get(linkId);
        Object3D obj = this.objSet.get(vertexId);
        if (link.getObj1() == obj) {
            return true;
        }
        assert (link.getObj2() == obj);
        return false;
    }

    private Vector3D computeFivePrimePosition(int linkId, double angle, int vertexId) {
        assert (this.branchDescriptors != null && this.branchDescriptors.size() == this.links.size());
        BranchDescriptor3D bd = this.branchDescriptors.get(linkId);
        Vector3D p = this.hasBranchDescriptor(linkId, vertexId) ? bd.computeHelixPosition(0, 2) : bd.computeHelixPosition(this.helixLengths.get(linkId), 1);
        p = Matrix3DTools.rotate(p, bd.getDirection(), angle, bd.getPosition());
        return p;
    }

    private Vector3D computeThreePrimePosition(int linkId, double angle, int vertexId) {
        assert (this.branchDescriptors != null && this.branchDescriptors.size() == this.links.size());
        BranchDescriptor3D bd = this.branchDescriptors.get(linkId);
        Vector3D p = this.hasBranchDescriptor(linkId, vertexId) ? bd.computeHelixPosition(0, 1) : bd.computeHelixPosition(this.helixLengths.get(linkId), 2);
        p = Matrix3DTools.rotate(p, bd.getDirection(), angle, bd.getPosition());
        return p;
    }

    private Vector3D[] computeFivePrimePositions(double[] angles, int vertexId) {
        List<Integer> linkId = this.linkIds.get(vertexId);
        Vector3D[] result = new Vector3D[linkId.size()];
        if (this.verboseLevel > 2) {
            System.out.print("5' positions of helices at vertex " + (vertexId + 1) + " : ");
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.computeFivePrimePosition(linkId.get(i), angles[linkId.get(i)], vertexId);
            if (this.verboseLevel <= 2) continue;
            System.out.print("" + result[i] + " " + this.objSet.get(vertexId).getPosition().distance(result[i]) + " ; ");
        }
        if (this.verboseLevel > 2) {
            System.out.println();
        }
        return result;
    }

    private Vector3D[] computeThreePrimePositions(double[] angles, int vertexId) {
        List<Integer> linkId = this.linkIds.get(vertexId);
        Vector3D[] result = new Vector3D[linkId.size()];
        if (this.verboseLevel > 2) {
            System.out.print("3' positions of helices at vertex " + (vertexId + 1) + " : ");
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.computeThreePrimePosition(linkId.get(i), angles[linkId.get(i)], vertexId);
            if (this.verboseLevel <= 2) continue;
            System.out.print("" + result[i] + " " + this.objSet.get(vertexId).getPosition().distance(result[i]) + " ; ");
        }
        if (this.verboseLevel > 2) {
            System.out.println();
        }
        return result;
    }

    public void setBasepairCharacters(char c1, char c2) {
        this.c1 = c1;
        this.c2 = c2;
    }
}

