/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import generaltools.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import launchtools.Job;
import launchtools.SimpleQueueManager;
import launchtools.SimpleRunCommand;
import numerictools.DoubleArrayTools;
import numerictools.IntegerArrayTools;
import rnasecondary.MutableSecondaryStructure;
import rnasecondary.SecondaryStructure;
import rnasecondary.SecondaryStructureScriptFormatWriter;
import secondarystructuredesign.PknotsRGParser;
import secondarystructuredesign.RnaFoldTools;
import secondarystructuredesign.SecondaryStructureScorer;

public class RnacofoldSecondaryStructureScorer2
implements SecondaryStructureScorer {
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private static ResourceBundle rb = ResourceBundle.getBundle("SecondaryStructureDesign");
    private static String rnafoldScriptName = rb.getString("rnafoldscript");
    private static String rnacofoldScriptName = rb.getString("rnacofoldscript");
    private static String pknotsScriptName = rb.getString("pknotsscript");
    private boolean interStrandMode = true;
    private double energyAU = -0.8;
    private double energyGC = -1.2;
    private double overlapWeight = 1.0;
    private String linkerSequence = "&";
    private String pkLinkerSequence = "";
    private boolean energyMode = true;
    private boolean pkMode = false;
    private int debugLevel = 2;
    private Level debugLogLevel = Level.FINE;
    private SecondaryStructureScorer subScorer;
    private double subScorerWeight = 1.0;
    private double selfEnergyCutoff = 0.0;
    private double structureWeight = 1.0;
    private double energyGap = 0.0;
    private boolean countMissedMode = true;
    private StringBuffer[] lastSeqs = null;
    private double[] singleSequenceScoreCache = null;
    private double[][] sequencePairScoreCache = null;

    public double interactionEnergy(char c1, char c2) {
        if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) {
            return 0.0;
        }
        if (c1 > c2) {
            return this.interactionEnergy(c2, c1);
        }
        switch (c1) {
            case 'A': {
                if (c2 == 'U') {
                    return this.energyAU;
                }
            }
            case 'C': {
                if (c2 != 'G') break;
                return this.energyGC;
            }
        }
        return 0.0;
    }

    String[] launchFolding(String sequence) throws IOException {
        File tmpInputFile = File.createTempFile("nanotiler_rnafold", ".seq");
        String inputFileName = tmpInputFile.getAbsolutePath();
        FileOutputStream fos = new FileOutputStream(tmpInputFile);
        PrintStream ps = new PrintStream(fos);
        SecondaryStructureScriptFormatWriter secWriter = new SecondaryStructureScriptFormatWriter();
        this.log.log(this.debugLogLevel, "Writing to file: " + inputFileName);
        this.log.log(this.debugLogLevel, "Writing content: " + sequence);
        ps.println(sequence);
        fos.close();
        File tmpOutputFile = File.createTempFile("nanotiler_rnafold", ".sec");
        String outputFileName = tmpOutputFile.getAbsolutePath();
        if (tmpOutputFile.exists()) {
            tmpOutputFile.delete();
        }
        String scriptName = rnacofoldScriptName;
        if (this.pkMode) {
            scriptName = pknotsScriptName;
        } else if (sequence.indexOf(38) < 0) {
            scriptName = rnafoldScriptName;
        }
        File tempFile = new File(scriptName);
        String[] commandWords = new String[]{scriptName, inputFileName, outputFileName};
        SimpleRunCommand command = new SimpleRunCommand(commandWords);
        this.log.log(this.debugLogLevel, "Issuing command: " + scriptName + " " + inputFileName + " " + outputFileName);
        SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
        Job job = queueManager.createJob(command);
        queueManager.submit(job);
        this.log.log(this.debugLogLevel, "queue manager finished job!");
        this.log.log(this.debugLogLevel, "Importing optimized sequences from " + outputFileName);
        String[] resultLines = null;
        FileInputStream resultFile = null;
        try {
            resultFile = new FileInputStream(outputFileName);
            resultLines = StringTools.readAllLines(resultFile);
        }
        catch (IOException ioe) {
            this.log.warning("Error when scraping result file from: " + outputFileName);
            assert (false);
            throw ioe;
        }
        finally {
            if (resultFile != null) {
                resultFile.close();
                File file = new File(outputFileName);
                file.delete();
            }
            if (tmpInputFile != null) {
                tmpInputFile.delete();
            }
        }
        if (resultLines != null) {
            this.log.log(this.debugLogLevel, "Results for RNAcofold:");
            for (int i = 0; i < resultLines.length; ++i) {
                this.log.fine(resultLines[i]);
            }
        } else {
            assert (false);
            this.log.warning("Rnacofold results were null!");
        }
        return resultLines;
    }

    public String getLinker() {
        if (this.pkMode) {
            return this.pkLinkerSequence;
        }
        return this.linkerSequence;
    }

    private String generateFusedSequence(String s1, String s2) {
        return s1 + this.getLinker() + s2;
    }

    private int[][] generateFusedInteractions(int[][] interactions) {
        int j;
        int i;
        int linkLen = this.getLinker().length();
        int l1 = interactions.length;
        int l2 = interactions[0].length;
        int fusedLen = l1 + linkLen + l2;
        assert (fusedLen > 0);
        int[][] result = new int[fusedLen][fusedLen];
        for (i = 0; i < result.length; ++i) {
            for (j = 0; j < result[0].length; ++j) {
                result[i][j] = -1;
            }
        }
        for (i = 0; i < interactions.length; ++i) {
            for (j = 0; j < interactions[0].length; ++j) {
                if (interactions[i][j] != 1) continue;
                int id1 = i;
                int id2 = j + l1 + linkLen;
                assert (id1 < result.length);
                assert (id2 < result[0].length);
                result[id1][id2] = 1;
                result[id2][id1] = 1;
            }
        }
        return result;
    }

    private boolean isInteracting(int[][] interactions) {
        for (int i = 0; i < interactions.length; ++i) {
            for (int j = i + 1; j < interactions[i].length; ++j) {
                if (interactions[i][j] == -1) continue;
                return true;
            }
        }
        return false;
    }

    private double scoreStructureSequencePair2(StringBuffer bseq1, StringBuffer bseq2, int[][] interactions, int[][] interactions1, int[][] interactions2) throws IOException, ParseException {
        assert (interactions.length == bseq1.length());
        assert (interactions[0].length == bseq2.length());
        String fusedSequence = "";
        int len1 = bseq1.length();
        int len2 = bseq2.length();
        fusedSequence = this.generateFusedSequence(bseq1.toString(), bseq2.toString());
        String[] rnafoldLines = this.launchFolding(fusedSequence);
        if (this.debugLogLevel.intValue() >= Level.INFO.intValue()) {
            System.out.println("Output of folding algorithm:");
            for (int i = 0; i < rnafoldLines.length; ++i) {
                System.out.println(rnafoldLines[i]);
            }
        }
        double energyAB = RnaFoldTools.parseRnacofoldEnergyAB(rnafoldLines);
        double energyAA = RnaFoldTools.parseRnacofoldEnergyAA(rnafoldLines);
        double energyBB = RnaFoldTools.parseRnacofoldEnergyBB(rnafoldLines);
        double energyA = RnaFoldTools.parseRnacofoldEnergyA(rnafoldLines);
        double energyB = RnaFoldTools.parseRnacofoldEnergyB(rnafoldLines);
        double eDiff = energyAB - energyA - energyB;
        double eDiffGap = eDiff + this.energyGap;
        double eDiffAA = energyAB - energyAA;
        double eDiffBB = energyAB - energyBB;
        return eDiff;
    }

    private double scoreStructureSingleSequence(StringBuffer bseq1, int[][] interactions1) throws IOException, ParseException {
        assert (interactions1.length == bseq1.length());
        assert (interactions1[0].length == bseq1.length());
        String fusedSequence = "";
        int len1 = bseq1.length();
        String[] rnafoldLines = this.launchFolding(bseq1.toString());
        int[][] predictedInteractions1 = null;
        double energy = 0.0;
        if (this.debugLogLevel.intValue() >= Level.INFO.intValue()) {
            System.out.println("Output of single sequence folding algorithm:");
            for (int i = 0; i < rnafoldLines.length; ++i) {
                System.out.println(rnafoldLines[i]);
            }
        }
        if (this.pkMode) {
            PknotsRGParser parser = new PknotsRGParser();
            MutableSecondaryStructure structure = parser.parse(rnafoldLines);
            assert (structure != null);
            assert (structure.getSequenceCount() == 1);
            predictedInteractions1 = structure.toInteractionMatrix(0, 0);
            assert (predictedInteractions1 != null && predictedInteractions1.length > 0);
            assert (predictedInteractions1.length == predictedInteractions1[0].length);
            if (this.debugLevel > 2) {
                System.out.println("Interactions of single-strand evaluation:");
                IntegerArrayTools.writeMatrix(System.out, predictedInteractions1);
            }
        } else {
            String bracket = RnaFoldTools.parseRnafoldStructure(rnafoldLines);
            predictedInteractions1 = RnaFoldTools.parseBracketInteractions(bracket);
            energy = RnaFoldTools.parseRnafoldEnergy(rnafoldLines);
        }
        double result = 0.0;
        result = this.countMissedMode ? this.structureWeight * RnaFoldTools.countMissedInteractions(interactions1, predictedInteractions1) / 2.0 : this.structureWeight * RnaFoldTools.computeMatrixDifference(interactions1, predictedInteractions1) / 2.0;
        if (!this.isInteracting(interactions1) && energy < this.selfEnergyCutoff) {
            result += this.selfEnergyCutoff - energy;
        }
        assert (result >= 0.0);
        return result;
    }

    private void cacheSeqs(StringBuffer[] bseqs) {
        if (this.lastSeqs == null || this.lastSeqs.length != bseqs.length) {
            this.lastSeqs = new StringBuffer[bseqs.length];
        }
        for (int i = 0; i < bseqs.length; ++i) {
            this.lastSeqs[i] = new StringBuffer(bseqs[i].toString());
        }
    }

    boolean[] findModified(StringBuffer[] bseqs) {
        int i;
        boolean[] result = new boolean[bseqs.length];
        for (i = 0; i < bseqs.length; ++i) {
            result[i] = true;
        }
        if (this.lastSeqs == null || result.length != this.lastSeqs.length) {
            return result;
        }
        for (i = 0; i < bseqs.length; ++i) {
            assert (this.lastSeqs[i] != null);
            assert (bseqs[i] != null);
            result[i] = this.lastSeqs[i].toString().compareTo(bseqs[i].toString()) != 0;
        }
        return result;
    }

    private void initScoreCache(StringBuffer[] bseqs) {
        this.singleSequenceScoreCache = new double[bseqs.length];
        assert (this.singleSequenceScoreCache[0] == 0.0);
        this.sequencePairScoreCache = new double[bseqs.length][bseqs.length];
    }

    @Override
    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        assert (false);
        return null;
    }

    @Override
    public double scoreStructure(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        double score = 0.0;
        if (bseqs.length < 2) {
            return 0.0;
        }
        boolean[] modified = this.findModified(bseqs);
        if (this.singleSequenceScoreCache == null || this.singleSequenceScoreCache.length != bseqs.length) {
            this.initScoreCache(bseqs);
        }
        double term = 0.0;
        int termCount = 0;
        int cacheCount = 0;
        ArrayList<Double> highScores = new ArrayList<Double>();
        ArrayList<Double> lowScores = new ArrayList<Double>();
        try {
            for (int i = 0; i < bseqs.length; ++i) {
                if (!structure.isActive(i)) continue;
                if (this.interStrandMode) {
                    for (int j = i + 1; j < bseqs.length; ++j) {
                        if (!structure.isActive(j)) continue;
                        if (modified[i] || modified[j]) {
                            this.sequencePairScoreCache[i][j] = term = this.scoreStructureSequencePair2(bseqs[i], bseqs[j], interactionMatrices[i][j], interactionMatrices[i][i], interactionMatrices[j][j]);
                            this.sequencePairScoreCache[j][i] = term;
                        } else {
                            term = this.sequencePairScoreCache[i][j];
                            ++cacheCount;
                        }
                        if (this.isInteracting(interactionMatrices[i][j])) {
                            lowScores.add(term);
                        } else {
                            highScores.add(term);
                        }
                        ++termCount;
                    }
                }
                if (modified[i]) {
                    this.singleSequenceScoreCache[i] = term = this.scoreStructureSingleSequence(bseqs[i], interactionMatrices[i][i]);
                } else {
                    term = this.singleSequenceScoreCache[i];
                    ++cacheCount;
                }
                score += term;
                ++termCount;
            }
        }
        catch (IOException ioe) {
            this.log.severe("Error launching RNAcofold! Error message: " + ioe.getMessage());
            assert (false);
            return 0.0;
        }
        catch (ParseException pe) {
            this.log.severe("Error parsing RNAcofold results! Error message: " + pe.getMessage());
            assert (false);
            return 0.0;
        }
        Collections.sort(highScores);
        Collections.sort(lowScores);
        double overlapTerm = 0.0;
        if (bseqs.length > 0 && highScores.size() > 0 && lowScores.size() > 0) {
            overlapTerm = DoubleArrayTools.scoreOverlap(highScores, lowScores);
        }
        assert ((score += this.overlapWeight * overlapTerm) >= 0.0);
        if (this.subScorer != null && this.subScorerWeight != 0.0) {
            score += this.subScorerWeight * this.subScorer.scoreStructure(bseqs, structure, interactionMatrices);
        }
        assert (termCount > 0);
        this.cacheSeqs(bseqs);
        return score;
    }

    public void setEnergyGap(double value) {
        this.energyGap = value;
    }

    public void setEnergyMode(boolean b) {
        this.energyMode = b;
    }

    public void setInterStrandMode(boolean mode) {
        this.interStrandMode = mode;
    }

    public void setPkMode(boolean mode) {
        this.pkMode = mode;
    }

    public void setSubScorer(SecondaryStructureScorer scorer) {
        this.subScorer = scorer;
    }

    public void setSelfEnergyCutoff(double cutoff) {
        this.selfEnergyCutoff = cutoff;
    }

    public void setStructureWeight(double weight) {
        this.structureWeight = weight;
    }

    public void setSubScorerWeight(double weight) {
        this.subScorerWeight = weight;
    }
}

