/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.util.Properties;
import tools3d.Appearance;
import tools3d.CoordinateSystem;
import tools3d.Drawable;
import tools3d.Positionable3D;
import tools3d.Vector3D;

public abstract class AbstractGeometryElement
implements Drawable {
    protected Vector3D position;
    protected double zBufValue = 0.0;
    protected Appearance appearance;
    protected Properties properties;
    protected boolean selected = false;

    @Override
    public void activeTransform(CoordinateSystem cs) {
        this.position = cs.activeTransform(this.position);
    }

    @Override
    public void passiveTransform(CoordinateSystem cs) {
        this.position = cs.passiveTransform(this.position);
    }

    @Override
    public double distance(Positionable3D other) {
        return this.getPosition().minus(other.getPosition()).length();
    }

    @Override
    public Appearance getAppearance() {
        return this.appearance;
    }

    @Override
    public Vector3D getPosition() {
        return this.position;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean isValid() {
        return this.getPosition().isValid();
    }

    @Override
    public double getZBufValue() {
        return this.zBufValue;
    }

    @Override
    public int compareTo(Positionable3D other) {
        if (other instanceof Positionable3D) {
            Positionable3D p = other;
            if (this.zBufValue < p.getZBufValue()) {
                return -1;
            }
            if (this.zBufValue > p.getZBufValue()) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    protected void copy(AbstractGeometryElement other) {
        this.position = other.position;
        this.zBufValue = other.zBufValue;
        this.appearance = other.appearance;
        this.properties = other.properties;
        this.selected = other.selected;
    }

    @Override
    public void setAppearance(Appearance appearance) {
        this.appearance = appearance;
    }

    protected void setPosition(Vector3D position) {
        this.position = position;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void setSelected(boolean b) {
        this.selected = b;
    }

    @Override
    public void setZBufValue(double v) {
        this.zBufValue = v;
    }

    @Override
    public void translate(Vector3D shift) {
        this.position.add(shift);
    }
}

