/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.util.logging.Logger;
import tools3d.Camera;
import tools3d.Matrix3D;
import tools3d.Vector3D;

public class CameraTools {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private static final Vector3D zFixed = new Vector3D(0.0, 0.0, 1.0);

    public static void updateCameraFromAngles(Camera camera, double theta, double phi, double psi, double dist, Vector3D interest) {
        Vector3D xVec;
        double x = Math.cos(phi) * Math.sin(theta) * dist + interest.getX();
        double y = Math.sin(phi) * Math.sin(theta) * dist + interest.getY();
        double z = Math.cos(theta) * dist + interest.getZ();
        Vector3D pos = camera.getPosition();
        Matrix3D orient = camera.getOrientation();
        pos.set(x, y, z);
        Vector3D zVec = interest.minus(pos);
        if (zVec.length() == 0.0) {
            zVec.copy(zFixed);
        } else {
            zVec.normalize();
        }
        if (zVec.length() > 1.01) {
            log.warning("Strange zvec found: " + zVec.toString());
        }
        if ((xVec = zVec.cross(zFixed)).length() == 0.0) {
            xVec.set(1.0, 0.0, 0.0);
        } else {
            xVec.normalize();
        }
        Vector3D yVec = zVec.cross(xVec);
        if (yVec.length() == 0.0) {
            yVec.set(0.0, 1.0, 0.0);
        } else {
            yVec.normalize();
        }
        orient.copy(xVec, yVec, zVec);
        camera.setPosition(pos);
        camera.setOrientation(orient);
    }
}

