/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import generaltools.TestTools;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.testng.annotations.Test;
import tools3d.Edge3D;
import tools3d.Face3D;
import tools3d.Geometry;
import tools3d.Point3D;
import tools3d.StandardGeometry;
import tools3d.Vector3D;

public class GeometryTools {
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public static int computeCircleDevisions(double angleDelta) {
        return (int)(Math.PI * 2 / angleDelta);
    }

    public static double distanceToLine(Vector3D point, Vector3D offset, Vector3D direction) {
        assert (direction.length() > 0.0);
        double result = 0.0;
        Vector3D dVec = point.minus(offset);
        double dLength = dVec.length();
        if (dLength == 0.0) {
            return 0.0;
        }
        double cosAlpha = dVec.dot(direction) / (dLength * direction.length());
        double alpha = Math.acos(cosAlpha);
        result = dLength * Math.sin(alpha);
        if (cosAlpha < 0.0) assert ((result *= -1.0) <= 0.0);
        assert (result * cosAlpha >= 0.0);
        return result;
    }

    public static Vector3D closestPointOnLine(Vector3D point, Vector3D offset, Vector3D directionOrig) {
        assert (directionOrig.length() > 0.0);
        Vector3D direction = new Vector3D(directionOrig);
        direction.normalize();
        Vector3D dVec = point.minus(offset);
        double dLength = dVec.length();
        if (dLength == 0.0) {
            return new Vector3D(point);
        }
        double projection = dVec.dot(direction);
        Vector3D closestPoint = offset.plus(direction.mul(projection));
        return closestPoint;
    }

    @Test(groups={"new"})
    public static void closestPointOnLineTest() {
        Vector3D p = new Vector3D(-1.0, 0.0, 0.0);
        Vector3D offset = new Vector3D(0.0, 1.0, 0.0);
        Vector3D dir = new Vector3D(1.0, 0.0, 0.0);
        Vector3D result = GeometryTools.closestPointOnLine(p, offset, dir);
        assert (result.getX() == -1.0);
        assert (result.getY() == 1.0);
        assert (result.getZ() == 0.0);
    }

    @Test(groups={"new"})
    public static void closestPointOnLineTest2() {
        Vector3D p = new Vector3D(-1.0, 1.0, 0.0);
        Vector3D offset = new Vector3D(0.0, 1.0, 0.0);
        Vector3D dir = new Vector3D(1.0, 0.0, 0.0);
        Vector3D result = GeometryTools.closestPointOnLine(p, offset, dir);
        assert (result.getX() == -1.0);
        assert (result.getY() == 1.0);
        assert (result.getZ() == 0.0);
    }

    public static double distanceToLineSegment(Vector3D point, Vector3D offset, Vector3D directionAndLength) {
        assert (directionAndLength.length() > 0.0);
        double result = GeometryTools.distanceToLine(point, offset, directionAndLength);
        if (result < 0.0) {
            result = point.distance(offset);
        } else if (result > directionAndLength.length()) {
            result = point.distance(offset.plus(directionAndLength));
        }
        return result;
    }

    public static double distanceOfLines(Vector3D p0, Vector3D u, Vector3D q0, Vector3D v) {
        assert (u.lengthSquare() > 0.0);
        assert (v.lengthSquare() > 0.0);
        double a = u.dot(u);
        assert (a > 0.0);
        double b = u.dot(v);
        double c = v.dot(v);
        assert (c > 0.0);
        Vector3D w0 = p0.minus(q0);
        double d = u.dot(w0);
        double e = v.dot(w0);
        double denom = a * c - b * b;
        double s = 0.0;
        double t = 0.0;
        if (denom == 0.0) {
            t = e / c;
        } else {
            s = (b * e - c * d) / denom;
            t = (a * e - b * d) / denom;
        }
        Vector3D p = p0.plus(u.mul(s));
        Vector3D q = q0.plus(v.mul(t));
        double dist = p.distance(q);
        return dist;
    }

    private static String distanceOfLinesString(Vector3D p0, Vector3D u, Vector3D q0, Vector3D v, double dist) {
        return "Distance between lines " + p0 + " " + u + " and " + q0 + " " + v + " : " + dist;
    }

    @Test(groups={"new"})
    public void distanceOfLinesTest() {
        String methodName = "distanceOfLinesTest";
        System.out.println(TestTools.generateMethodHeader(methodName));
        Vector3D p0 = new Vector3D(0.0, 0.0, 0.0);
        Vector3D p0b = new Vector3D(2.0, 0.0, 0.0);
        Vector3D q0 = new Vector3D(0.0, 0.0, 1.0);
        Vector3D u = new Vector3D(1.0, 0.0, 0.0);
        Vector3D v = new Vector3D(1.0, 1.0, 0.0);
        Vector3D vb = new Vector3D(-1.0, -1.0, 0.0);
        double result1 = GeometryTools.distanceOfLines(p0, u, q0, v);
        System.out.println(GeometryTools.distanceOfLinesString(p0, u, q0, v, result1));
        double result2 = GeometryTools.distanceOfLines(p0b, u, q0, v);
        System.out.println(GeometryTools.distanceOfLinesString(p0b, u, q0, vb, result2));
        assert (Math.abs(result1 - 1.0) < 0.01);
        assert (Math.abs(result2 - 1.0) < 0.01);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    public static Geometry triangularize(Vector3D[] v, double angleMin, double angleMax, double lengthMin, double lengthMax) {
        int i;
        log.fine("Starting triangularization! " + v.length + " " + angleMin + " " + angleMax + " " + lengthMin + " " + lengthMax);
        ArrayList<Edge3D> edgeList = new ArrayList<Edge3D>();
        ArrayList<Face3D> faceList = new ArrayList<Face3D>();
        int nn = v.length;
        for (int i2 = 0; i2 < nn; ++i2) {
            for (int j = i2 + 1; j < nn; ++j) {
                double d = v[i2].distance(v[j]);
                if (!(d <= lengthMax) || !(d >= lengthMin)) continue;
                edgeList.add(new Edge3D(v[i2], v[j]));
            }
        }
        int ne = edgeList.size();
        log.fine("number of found edges: " + edgeList.size());
        for (int i3 = 0; i3 < ne; ++i3) {
            Edge3D edgeI = (Edge3D)edgeList.get(i3);
            for (int j = i3 + 1; j < ne; ++j) {
                Edge3D edgeJ = (Edge3D)edgeList.get(j);
                Vector3D pij = edgeI.findAdjacent(edgeJ);
                if (pij == null) continue;
                for (int k = j + 1; k < ne; ++k) {
                    Edge3D edgeK = (Edge3D)edgeList.get(k);
                    Vector3D pik = edgeI.findAdjacent(edgeK);
                    Vector3D pjk = edgeJ.findAdjacent(edgeK);
                    if (pik == null || pjk == null || !(pij.distance(pik) > 0.0) || !(pij.distance(pik) > 0.0) || !(pik.distance(pjk) > 0.0)) continue;
                    Vector3D[] threePos = new Vector3D[]{pij, pik, pjk};
                    faceList.add(new Face3D(threePos));
                }
            }
        }
        Point3D[] points = new Point3D[v.length];
        Edge3D[] edges = new Edge3D[edgeList.size()];
        Face3D[] faces = new Face3D[faceList.size()];
        for (i = 0; i < points.length; ++i) {
            points[i] = new Point3D(v[i]);
        }
        for (i = 0; i < edges.length; ++i) {
            edges[i] = (Edge3D)edgeList.get(i);
        }
        for (i = 0; i < faces.length; ++i) {
            faces[i] = (Face3D)faceList.get(i);
        }
        log.fine("number of found edges: " + edgeList.size() + " faces: " + faceList.size());
        return new StandardGeometry(points, edges, faces);
    }

    public static double planeDistance(Vector3D planeNormal, Vector3D planeOffset, Vector3D point) {
        assert (planeNormal.length() > 0.99 && planeNormal.length() < 1.01);
        Vector3D v = point.minus(planeOffset);
        double result = v.dot(planeNormal);
        return result;
    }
}

