/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import generaltools.Randomizer;
import java.util.Random;
import java.util.logging.Logger;
import tools3d.Matrix3D;
import tools3d.Superpose;
import tools3d.SuperpositionResult;
import tools3d.Vector3D;
import tools3d.Vector3DTools;

public class MCSuperpose
implements Superpose {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static Random rnd = Randomizer.getInstance();
    public static final double PI2 = Math.PI * 2;
    private int iterMax = 100000;
    private double rmsLim = 0.01;
    private double angleStep = Math.PI;
    private int numTrial = 1;
    private int centerId = -1;

    private double generateRandomDouble(double min, double max) {
        assert (max >= min);
        double delta = max - min;
        double x = rnd.nextDouble();
        x *= delta;
        return x += min;
    }

    private double generateRandomGaussian(double center, double scale) {
        double x = rnd.nextGaussian();
        x *= scale;
        return x += center;
    }

    private double mutateValue(double x, double step) {
        return this.generateRandomGaussian(x, step);
    }

    public static double computeRms(Vector3D[] constCoord, Vector3D[] varCoord) {
        double sum = 0.0;
        for (int i = 0; i < constCoord.length; ++i) {
            sum += constCoord[i].minus(varCoord[i]).lengthSquare();
        }
        return Math.sqrt(sum /= (double)constCoord.length);
    }

    public static double computeRms(Vector3D[] constCoord, Vector3D[] varCoord, double phi, double theta, double angle) {
        assert (constCoord.length == varCoord.length);
        double sum = 0.0;
        Vector3D axis = Vector3DTools.generateCartesianFromPolar(phi, theta, 1.0);
        Matrix3D rotationMatrix = Matrix3D.rotationMatrix(axis, angle);
        SuperpositionResult supResult = new SuperpositionResult();
        supResult.setRotationMatrix(rotationMatrix);
        for (int i = 0; i < constCoord.length; ++i) {
            Vector3D vTmp = rotationMatrix.multiply(varCoord[i]);
            assert (vTmp.distance(supResult.returnTransformed(varCoord[i])) < 0.1);
            sum += constCoord[i].minus(vTmp).lengthSquare();
        }
        double rms = Math.sqrt(sum /= (double)constCoord.length);
        return rms;
    }

    SuperpositionResult rotationRun(Vector3D[] constCoord, Vector3D[] varCoord) {
        double phi = rnd.nextDouble() * (Math.PI * 2);
        double theta = rnd.nextDouble() * Math.PI;
        double angle = rnd.nextDouble() * (Math.PI * 2);
        double angleStepCurr = this.angleStep;
        double bestRms = MCSuperpose.computeRms(constCoord, varCoord, phi, theta, angle);
        int iter = 0;
        while (iter < this.iterMax && bestRms > this.rmsLim) {
            double angleNew;
            double rms;
            ++iter;
            double phiNew = this.mutateValue(phi, angleStepCurr);
            double thetaNew = this.mutateValue(theta, 0.5 * angleStepCurr);
            if (thetaNew < 0.0) {
                thetaNew = 0.0;
            }
            if (thetaNew > Math.PI) {
                thetaNew = Math.PI;
            }
            if (!((rms = MCSuperpose.computeRms(constCoord, varCoord, phiNew, thetaNew, angleNew = this.mutateValue(angle, angleStepCurr))) < bestRms)) continue;
            phi = phiNew;
            theta = thetaNew;
            angle = angleNew;
            bestRms = rms;
            angleStepCurr *= 0.9;
            Vector3D axis = Vector3DTools.generateCartesianFromPolar(phi, theta, 1.0);
            Matrix3D rotationMatrix = Matrix3D.rotationMatrix(axis, angle);
            assert (constCoord[1].distance(rotationMatrix.multiply(varCoord[1])) <= 2.0 * bestRms);
        }
        Vector3D axis = Vector3DTools.generateCartesianFromPolar(phi, theta, 1.0);
        Matrix3D rotationMatrix = Matrix3D.rotationMatrix(axis, angle);
        SuperpositionResult result = new SuperpositionResult();
        result.setRms(bestRms);
        result.setRotationMatrix(rotationMatrix);
        assert (constCoord[1].distance(rotationMatrix.multiply(varCoord[1])) < 2.0 * bestRms);
        assert (constCoord[1].distance(result.returnTransformed(varCoord[1])) <= 2.0 * result.getRms());
        return result;
    }

    public void setCenterId(int n) {
        this.centerId = n;
    }

    @Override
    public SuperpositionResult superpose(Vector3D[] constCoord, Vector3D[] varCoord) {
        assert (constCoord.length == varCoord.length);
        Vector3D varCoordOrig = null;
        Vector3D debugPos = new Vector3D(varCoord[1]);
        Vector3D shift1 = new Vector3D();
        Vector3D shift2 = new Vector3D();
        if (this.centerId >= 0) {
            assert (this.centerId < constCoord.length);
            shift1.copy(constCoord[this.centerId]);
            shift2.copy(varCoord[this.centerId]);
            varCoordOrig = new Vector3D(varCoord[this.centerId]);
        } else {
            shift1 = Vector3DTools.computeCenterGravity(constCoord);
            shift2 = Vector3DTools.computeCenterGravity(varCoord);
        }
        for (int i = 0; i < constCoord.length; ++i) {
            constCoord[i].sub(shift1);
            varCoord[i].sub(shift2);
        }
        SuperpositionResult result = this.rotationRun(constCoord, varCoord);
        for (int i = 1; i < this.numTrial; ++i) {
            SuperpositionResult newResult = this.rotationRun(constCoord, varCoord);
            if (!(newResult.getRms() < result.getRms())) continue;
            result = newResult;
        }
        result.setShift1(shift1);
        result.setShift2(shift2);
        Matrix3D rotMatrix = result.getRotationMatrix();
        for (int i = 0; i < constCoord.length; ++i) {
            constCoord[i].add(shift1);
            if (i == 1) {
                // empty if block
            }
            varCoord[i] = rotMatrix.multiply(varCoord[i]);
            if (i == 1) {
                // empty if block
            }
            varCoord[i].add(shift1);
            if (i != 1) continue;
        }
        if (varCoordOrig == null) assert (this.centerId < 0);
        if (result.returnTransformed(debugPos).distance(varCoord[1]) > 0.01) {
            log.warning("Error detected in transformation!!! " + debugPos + " " + result.returnTransformed(debugPos) + " " + varCoord[1]);
        }
        return result;
    }
}

