/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import generaltools.Randomizer;
import java.util.Random;
import java.util.logging.Logger;
import tools3d.GeometryTools;
import tools3d.Matrix3D;
import tools3d.SuperposeCollinear;
import tools3d.SuperpositionResult;
import tools3d.Vector3D;
import tools3d.Vector3DTools;

public class MCSuperposeCollinear
implements SuperposeCollinear {
    public static final double DEG2RAD = Math.PI / 180;
    public static Random rnd = Randomizer.getInstance();
    public static final double PI2 = Math.PI * 2;
    private int iterMax = 100000;
    private double rmsLim = 0.01;
    private double angleStep = Math.PI;
    private int numTrial = 1;
    private int centerId = -1;
    private double shiftStep = 1.0;
    private double stepDecayMul = 0.99;
    private double angleWeight = 1.0;
    private double anglePenalty = 10.0;
    private double angleLimit = 0.6981317007977318;
    private double distanceLimit = 5.0;
    private double distancePenalty = 10.0;
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    private double generateRandomDouble(double min, double max) {
        assert (max >= min);
        double delta = max - min;
        double x = rnd.nextDouble();
        x *= delta;
        return x += min;
    }

    private double generateRandomGaussian(double center, double scale) {
        double x = rnd.nextGaussian();
        x *= scale;
        return x += center;
    }

    public double getAngleLimit() {
        return this.angleLimit;
    }

    public double getDistanceLimit() {
        return this.distanceLimit;
    }

    private double mutateValue(double x, double step) {
        return this.generateRandomGaussian(x, step);
    }

    private Vector3D mutateVector(Vector3D v, double step) {
        return new Vector3D(this.generateRandomGaussian(v.getX(), step), this.generateRandomGaussian(v.getY(), step), this.generateRandomGaussian(v.getZ(), step));
    }

    private double computeError(Vector3D[] constCoord, Vector3D[] constDirs, Vector3D[] varCoord, Vector3D[] varDirs, double phi, double theta, double angle, Vector3D shift) {
        assert (constCoord.length == varCoord.length);
        double sum = 0.0;
        Vector3D axis = Vector3DTools.generateCartesianFromPolar(phi, theta, 1.0);
        Matrix3D rotationMatrix = Matrix3D.rotationMatrix(axis, angle);
        SuperpositionResult supResult = new SuperpositionResult();
        supResult.setRotationMatrix(rotationMatrix);
        for (int i = 0; i < constCoord.length; ++i) {
            Vector3D vTmp = rotationMatrix.multiply(varCoord[i]).plus(shift);
            double distTerm = Math.abs(GeometryTools.distanceToLine(vTmp, constCoord[i], constDirs[i]));
            double angleTerm = Math.abs(constDirs[i].angle(rotationMatrix.multiply(varDirs[i])));
            sum += distTerm + this.angleWeight * angleTerm;
            if (angleTerm > this.angleLimit) {
                sum += this.anglePenalty;
            }
            if (!(distTerm > this.distanceLimit)) continue;
            sum += this.distancePenalty;
        }
        assert ((sum /= (double)constCoord.length) >= 0.0);
        return sum;
    }

    public double getAngleWeight() {
        return this.angleWeight;
    }

    private SuperpositionResult monteCarloRun(Vector3D[] constCoord, Vector3D[] constDirs, Vector3D[] varCoord, Vector3D[] varDirs) {
        double phi = rnd.nextDouble() * (Math.PI * 2);
        double theta = rnd.nextDouble() * Math.PI;
        double angle = rnd.nextDouble() * (Math.PI * 2);
        double angleStepCurr = this.angleStep;
        double shiftStepCurr = this.shiftStep;
        Vector3D varShift = new Vector3D(0.0, 0.0, 0.0);
        double bestRms = this.computeError(constCoord, constDirs, varCoord, varDirs, phi, theta, angle, varShift);
        int iter = 0;
        while (iter < this.iterMax && bestRms > this.rmsLim) {
            double angleNew;
            double rms;
            ++iter;
            double phiNew = this.mutateValue(phi, angleStepCurr);
            double thetaNew = this.mutateValue(theta, 0.5 * angleStepCurr);
            Vector3D shiftNew = this.mutateVector(varShift, shiftStepCurr);
            if (thetaNew < 0.0) {
                thetaNew = 0.0;
            }
            if (thetaNew > Math.PI) {
                thetaNew = Math.PI;
            }
            if (!((rms = this.computeError(constCoord, constDirs, varCoord, varDirs, phiNew, thetaNew, angleNew = this.mutateValue(angle, angleStepCurr), shiftNew)) < bestRms)) continue;
            phi = phiNew;
            theta = thetaNew;
            angle = angleNew;
            bestRms = rms;
            varShift = shiftNew;
            angleStepCurr *= this.stepDecayMul;
            shiftStepCurr *= this.stepDecayMul;
        }
        Vector3D axis = Vector3DTools.generateCartesianFromPolar(phi, theta, 1.0);
        Matrix3D rotationMatrix = Matrix3D.rotationMatrix(axis, angle);
        SuperpositionResult result = new SuperpositionResult();
        result.setRms(bestRms);
        result.setRotationMatrix(rotationMatrix);
        result.setShift1(varShift);
        return result;
    }

    @Override
    public SuperpositionResult superpose(Vector3D[] constCoord, Vector3D[] constDirs, Vector3D[] varCoord, Vector3D[] varDirs) {
        int i;
        assert (constCoord.length == varCoord.length);
        Object varCoordOrig = null;
        try {
            Vector3D debugPos = new Vector3D(varCoord[1]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Vector3D debugPos = new Vector3D(varCoord[0]);
        }
        Vector3D shift1 = Vector3DTools.computeCenterGravity(constCoord);
        Vector3D shift2 = Vector3DTools.computeCenterGravity(varCoord);
        for (int i2 = 0; i2 < constCoord.length; ++i2) {
            constCoord[i2].sub(shift1);
            varCoord[i2].sub(shift2);
        }
        SuperpositionResult result = this.monteCarloRun(constCoord, constDirs, varCoord, varDirs);
        for (i = 1; i < this.numTrial; ++i) {
            SuperpositionResult newResult = this.monteCarloRun(constCoord, constDirs, varCoord, varDirs);
            if (!(newResult.getRms() < result.getRms())) continue;
            result = newResult;
        }
        result.setShift1(shift1.plus(result.getShift1()));
        result.setShift2(shift2.plus(result.getShift2()));
        for (i = 0; i < constCoord.length; ++i) {
            constCoord[i].add(shift1);
            result.applyTransformation(varCoord[i]);
        }
        return result;
    }

    public void setAngleWeight(double val) {
        this.angleWeight = val;
    }

    public void setAngleLimit(double x) {
        this.angleLimit = x;
    }

    public void setDistanceLimit(double x) {
        this.distanceLimit = x;
    }
}

