/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import generaltools.Randomizer;
import java.util.Random;
import org.testng.annotations.Test;
import tools3d.Matrix3D;
import tools3d.PermutationSymbol3;
import tools3d.Vector3D;
import tools3d.Vector3DTools;
import tools3d.Vector4D;

public class Matrix3DTools {
    public static final double PI2 = Math.PI * 2;
    private static Random rnd = Randomizer.getInstance();

    public static Vector4D extractQuaternion(Matrix3D m) {
        int[] perm = new int[]{0, 1, 2};
        int largest = 0;
        double largestVal = m.getXX();
        if (m.getYY() > largestVal) {
            largest = 1;
            largestVal = m.getYY();
        }
        if (m.getZZ() > largestVal) {
            largest = 2;
            largestVal = m.getZZ();
        }
        if (largest == 1) {
            perm[0] = 1;
            perm[1] = 2;
            perm[2] = 0;
        } else if (largest == 2) {
            perm[0] = 2;
            perm[1] = 0;
            perm[2] = 1;
        }
        double[][] ary = m.toArray();
        double Quu = ary[perm[0]][perm[0]];
        double Quv = ary[perm[0]][perm[1]];
        double Quw = ary[perm[0]][perm[2]];
        double Qvu = ary[perm[1]][perm[0]];
        double Qvv = ary[perm[1]][perm[1]];
        double Qvw = ary[perm[1]][perm[2]];
        double Qwu = ary[perm[2]][perm[0]];
        double Qwv = ary[perm[2]][perm[1]];
        double Qww = ary[perm[2]][perm[2]];
        double rsq = 1.0 + Quu - Qvv - Qww;
        if (rsq <= 0.0) {
            return new Vector4D(1.0, 0.0, 0.0, 0.0);
        }
        double r = Math.sqrt(rsq);
        double q0 = (Qwv - Qvw) / (2.0 * r);
        double qu = r / 2.0;
        double qv = (Quv + Qvu) / (2.0 * r);
        double qw = (Qwu + Quw) / (2.0 * r);
        return new Vector4D(q0, qu, qv, qw);
    }

    public static Matrix3D computeEulerRotationMatrix(double w, double a, double k) {
        Matrix3D m = new Matrix3D(Math.cos(k) * Math.cos(a), -Math.sin(k) * Math.cos(w) + Math.cos(k) * Math.sin(a) * Math.sin(w), Math.sin(k) * Math.sin(w) + Math.cos(w) * Math.cos(k) * Math.sin(a), Math.sin(k) * Math.cos(a), Math.cos(k) * Math.cos(w) + Math.sin(w) * Math.sin(k) * Math.sin(a), -Math.sin(w) * Math.cos(k) + Math.cos(w) * Math.sin(k) * Math.sin(a), -Math.sin(a), Math.sin(w) * Math.cos(a), Math.cos(w) * Math.cos(a));
        return m;
    }

    public static Matrix3D generateRandomRotationMatrix() {
        double phi = Math.PI * 2 * rnd.nextDouble();
        double theta = Math.PI * rnd.nextDouble();
        double angle = Math.PI * 2 * rnd.nextDouble();
        Vector3D axis = Vector3DTools.generateCartesianFromPolar(phi, theta, 1.0);
        Matrix3D rotationMatrix = Matrix3D.rotationMatrix(axis, angle);
        return rotationMatrix;
    }

    public static double project(Vector3D point, Vector3D dir, Vector3D offs) {
        return dir.dot(point.minus(offs));
    }

    public static Matrix3D matrixProduct(Vector3D a, Vector3D b) {
        double xx = a.getX() * b.getX();
        double xy = a.getX() * b.getY();
        double xz = a.getX() * b.getZ();
        double yx = a.getY() * b.getX();
        double yy = a.getY() * b.getY();
        double yz = a.getY() * b.getZ();
        double zx = a.getZ() * b.getX();
        double zy = a.getZ() * b.getY();
        double zz = a.getZ() * b.getZ();
        return new Matrix3D(xx, xy, xz, yx, yy, yz, zx, zy, zz);
    }

    public static Vector3D rotate(Vector3D v, Vector3D axis, double angle) {
        return Matrix3DTools.rotationMatrix(axis, angle).multiply(v);
    }

    @Test
    public void testRotate() {
        Vector3D xVec = new Vector3D(1.0, 0.0, 0.0);
        Vector3D yVec = new Vector3D(0.0, 1.0, 0.0);
        Vector3D zVec = new Vector3D(0.0, 0.0, 1.0);
        double ang = 1.5707963267948966;
        Vector3D result = Matrix3DTools.rotate(xVec, zVec, ang);
        assert (result.similar(yVec));
    }

    public static Vector3D rotate(Vector3D x, Vector3D axis, double angle, Vector3D axisOffset) {
        Vector3D result = Matrix3DTools.rotationMatrix(axis, angle).multiply(x.minus(axisOffset));
        return result.plus(axisOffset);
    }

    public static Matrix3D rotationMatrix(Vector3D n, double alpha) {
        Matrix3D R = new Matrix3D(1.0);
        Matrix3D S = new Matrix3D();
        Matrix3D U = new Matrix3D();
        if (n.getX() == 0.0 && n.getY() == 0.0 && n.getZ() == 0.0) {
            return R;
        }
        n.normalize();
        Vector3D nSin = n.mul(Math.sin(alpha));
        S.setXX(0.0);
        S.setXY(-nSin.getZ());
        S.setXZ(nSin.getY());
        S.setYX(nSin.getZ());
        S.setYY(0.0);
        S.setYZ(-nSin.getX());
        S.setZX(-nSin.getY());
        S.setZY(nSin.getX());
        S.setZZ(0.0);
        U.setXX(n.getX() * n.getX());
        U.setXY(n.getX() * n.getY());
        U.setXZ(n.getX() * n.getZ());
        U.setYX(n.getY() * n.getX());
        U.setYY(n.getY() * n.getY());
        U.setYZ(n.getY() * n.getZ());
        U.setZX(n.getZ() * n.getX());
        U.setZY(n.getZ() * n.getY());
        U.setZZ(n.getZ() * n.getZ());
        R.subtract(U);
        R.scale(Math.cos(alpha));
        R.add(U);
        R.add(S);
        return R;
    }

    public static Matrix3D transpose(Matrix3D m) {
        Matrix3D result = new Matrix3D();
        result.setXX(m.getXX());
        result.setXY(m.getYX());
        result.setXZ(m.getZX());
        result.setYX(m.getXY());
        result.setYY(m.getYY());
        result.setYZ(m.getZY());
        result.setZX(m.getXZ());
        result.setZY(m.getYZ());
        result.setZZ(m.getZZ());
        return result;
    }

    public static Matrix3D generateJMatrix(int j) {
        PermutationSymbol3 p = new PermutationSymbol3();
        return new Matrix3D(PermutationSymbol3.epsilon(1, j, 1), PermutationSymbol3.epsilon(1, j, 2), PermutationSymbol3.epsilon(1, j, 3), PermutationSymbol3.epsilon(2, j, 1), PermutationSymbol3.epsilon(2, j, 2), PermutationSymbol3.epsilon(2, j, 3), PermutationSymbol3.epsilon(3, j, 1), PermutationSymbol3.epsilon(3, j, 2), PermutationSymbol3.epsilon(3, j, 3));
    }

    public static double[] convertRotationMatrixToAxisAngle(Matrix3D R) {
        double trace = R.trace();
        double term1 = Math.sqrt(trace + 1.0);
        double denom = term1 * Math.sqrt(3.0 - trace);
        double[] result = new double[4];
        result[3] = 2.0 * Math.acos(0.5 * term1);
        for (int j = 0; j < 3; ++j) {
            Matrix3D jMatrix = Matrix3DTools.generateJMatrix(j + 1);
            Matrix3D jTimesR = jMatrix.multiply(R);
            result[j] = jTimesR.trace() / denom;
        }
        return result;
    }
}

