/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import tools3d.Appearance;
import tools3d.CoordinateSystem;
import tools3d.Geometry;
import tools3d.Matrix3D;
import tools3d.Positionable3D;
import tools3d.Shape3D;
import tools3d.Shape3DActor;
import tools3d.Shape3DSet;
import tools3d.SimpleShape3D;
import tools3d.StandardGeometry;
import tools3d.Vector3D;

public class SimpleShape3DSet
implements Shape3DSet {
    private Shape3D shape = new SimpleShape3D();
    private List<Shape3D> shapes = new ArrayList<Shape3D>();
    private double zBufValue = 0.0;

    @Override
    public void activeTransform(CoordinateSystem cs) {
        assert (false);
    }

    @Override
    public void passiveTransform(CoordinateSystem cs) {
        assert (false);
    }

    public void clear() {
        this.shape = null;
        this.shapes.clear();
    }

    @Override
    public Object cloneDeep() {
        assert (false);
        return null;
    }

    @Override
    public Geometry createGeometry(double angleDelta) {
        if (this.size() == 0) {
            return new StandardGeometry();
        }
        Shape3D lShape = this.get(0);
        Geometry geometry = lShape.createGeometry(angleDelta);
        for (int i = 1; i < this.shapes.size(); ++i) {
            lShape = this.get(i);
            geometry.merge(lShape.createGeometry(angleDelta));
        }
        return geometry;
    }

    @Override
    public int compareTo(Positionable3D o) {
        assert (false);
        return 0;
    }

    @Override
    public double distance(Positionable3D other) {
        return this.getPosition().minus(other.getPosition()).length();
    }

    @Override
    public Shape3D get(int n) {
        return this.shapes.get(n);
    }

    @Override
    public Vector3D getPosition() {
        return this.shape.getPosition();
    }

    @Override
    public double getZBufValue() {
        return this.zBufValue;
    }

    @Override
    public boolean isSelected() {
        return this.shape.isSelected();
    }

    @Override
    public boolean isValid() {
        return this.getPosition().isValid();
    }

    @Override
    public int size() {
        return this.shapes.size();
    }

    @Override
    public void add(Shape3D shape) {
        if (shape != null) {
            this.shapes.add(shape);
        }
    }

    @Override
    public void merge(Shape3DSet shapeSet) {
        if (shapeSet == null) {
            return;
        }
        for (int i = 0; i < shapeSet.size(); ++i) {
            this.shapes.add(shapeSet.get(i));
        }
    }

    @Override
    public void remove(Shape3D shape) {
    }

    @Override
    public void act() {
        this.shape.act();
        for (int i = 0; i < this.shapes.size(); ++i) {
            this.shapes.get(i).act();
        }
    }

    @Override
    public Shape3DActor getActor() {
        return this.shape.getActor();
    }

    @Override
    public Appearance getAppearance() {
        return this.shape.getAppearance();
    }

    @Override
    public String getShapeName() {
        return this.shape.getShapeName();
    }

    @Override
    public Properties getProperties() {
        return this.shape.getProperties();
    }

    @Override
    public Vector3D getRotationAxis() {
        return this.shape.getRotationAxis();
    }

    @Override
    public double getRotationAngle() {
        return this.shape.getRotationAngle();
    }

    @Override
    public Vector3D getScalingFactor() {
        return this.shape.getScalingFactor();
    }

    @Override
    public double getBoundingRadius() {
        return this.shape.getBoundingRadius();
    }

    @Override
    public Vector3D getDimensions() {
        return this.shape.getDimensions();
    }

    @Override
    public void setActor(Shape3DActor actor) {
        this.shape.setActor(actor);
        for (int i = 0; i < this.shapes.size(); ++i) {
            this.shapes.get(i).setActor(actor);
        }
    }

    @Override
    public void setAppearance(Appearance appearance) {
        this.shape.setAppearance(appearance);
        for (int i = 0; i < this.shapes.size(); ++i) {
            this.shapes.get(i).setAppearance(appearance);
        }
    }

    @Override
    public void setPosition(Vector3D point) {
        this.shape.setPosition(point);
    }

    @Override
    public void setProperties(Properties p) {
        this.shape.setProperties(p);
    }

    @Override
    public void setRotationAngle(double angle) {
        this.shape.setRotationAngle(angle);
    }

    @Override
    public void setRotationAxis(Vector3D axis) {
        this.shape.setRotationAxis(axis);
    }

    @Override
    public void setSelected(boolean b) {
        this.shape.setSelected(b);
    }

    @Override
    public void setZBufValue(double val) {
        this.zBufValue = val;
    }

    @Override
    public void rotate(Vector3D axis, double angle) {
        this.shape.rotate(axis, angle);
        for (int i = 0; i < this.shapes.size(); ++i) {
            this.shapes.get(i).rotate(axis, angle);
        }
    }

    @Override
    public void rotate(Vector3D center, Matrix3D matrix) {
        assert (false);
    }

    @Override
    public void rotate(Vector3D center, Vector3D axis, double angle) {
        this.shape.rotate(center, axis, angle);
        for (int i = 0; i < this.shapes.size(); ++i) {
            this.shapes.get(i).rotate(center, axis, angle);
        }
    }

    @Override
    public void scale(Vector3D factor) {
        this.shape.scale(factor);
        for (int i = 0; i < this.shapes.size(); ++i) {
            this.shapes.get(i).scale(factor);
        }
    }

    @Override
    public void setBoundingRadius(double radius) {
        this.shape.setBoundingRadius(radius);
    }

    @Override
    public void setDimensions(Vector3D dimensions) {
        this.shape.setDimensions(dimensions);
    }

    @Override
    public void translate(Vector3D vec) {
        for (int i = 0; i < this.shapes.size(); ++i) {
            this.shapes.get(i).translate(vec);
        }
    }
}

