/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import tools3d.Matrix3DTools;
import tools3d.Positionable3D;
import tools3d.Vector3D;

public class ZBuffer {
    private List<Positionable3D> list;
    private Iterator iter;
    private boolean sorted = true;
    private Vector3D direction = new Vector3D(0.0, 0.0, 1.0);
    private static final Vector3D zeroPos = new Vector3D(0.0, 0.0, 0.0);

    public ZBuffer() {
        this.list = new ArrayList<Positionable3D>();
        this.iter = this.list.iterator();
    }

    public void add(Positionable3D p) {
        p.setZBufValue(this.computePriority(p.getPosition()));
        this.list.add(p);
        this.sorted = false;
    }

    public Positionable3D get(int i) {
        return this.list.get(i);
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public double computePriority(Vector3D pos) {
        return Matrix3DTools.project(pos, this.direction, zeroPos);
    }

    public void sort() {
        Collections.sort(this.list);
        this.sorted = true;
    }

    public void reset() {
        this.list.clear();
        this.iter = this.list.iterator();
        this.sorted = true;
    }

    public void setDirection(Vector3D v) {
        this.direction = v;
    }

    public int size() {
        return this.list.size();
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public Positionable3D next() {
        if (!this.iter.hasNext()) {
            return null;
        }
        return (Positionable3D)this.iter.next();
    }
}

