/*
 * Decompiled with CFR 0.152.
 */
package tools3d.geometry;

import tools3d.Edge3D;
import tools3d.Face3D;
import tools3d.Geometry;
import tools3d.Point3D;
import tools3d.StandardGeometry;

public class PlanarTools {
    public static Geometry generateNtagon(int n, double sideLength) {
        assert (n > 2);
        Point3D[] points = new Point3D[n];
        double l = sideLength;
        double lh = 0.5 * l;
        double angle = Math.PI * 2 / (double)n;
        double h = lh / Math.sin(0.5 * angle);
        double r = Math.sqrt(lh * lh + h * h);
        for (int i = 0; i < n; ++i) {
            double currAng = (double)i * angle;
            double x = r * Math.cos(currAng);
            double y = r * Math.sin(currAng);
            double z = 0.0;
            points[i] = new Point3D(x, y, z);
        }
        Edge3D[] edges = new Edge3D[n];
        for (int i = 1; i < n; ++i) {
            edges[i] = new Edge3D(points[i - 1], points[i]);
        }
        edges[0] = new Edge3D(points[0], points[n - 1]);
        Face3D[] faces = new Face3D[]{};
        return new StandardGeometry(points, edges, faces);
    }

    public static Geometry generatePrism(int n, double sideLength, double height) {
        int i;
        assert (n > 2);
        Point3D[] points = new Point3D[2 * n];
        double l = sideLength;
        double lh = 0.5 * l;
        double angle = Math.PI * 2 / (double)n;
        double h = lh / Math.sin(0.5 * angle);
        double r = Math.sqrt(lh * lh + h * h);
        for (int i2 = 0; i2 < n; ++i2) {
            double currAng = (double)i2 * angle;
            double x = r * Math.cos(currAng);
            double y = r * Math.sin(currAng);
            double z0 = 0.0;
            double z1 = height;
            points[i2] = new Point3D(x, y, z0);
            points[i2 + n] = new Point3D(x, y, z1);
        }
        Edge3D[] edges = new Edge3D[3 * n];
        for (int i3 = 1; i3 < n; ++i3) {
            edges[i3] = new Edge3D(points[i3 - 1], points[i3]);
            edges[i3 + n] = new Edge3D(points[i3 - 1 + n], points[i3 + n]);
            edges[i3 + 2 * n] = new Edge3D(points[i3], points[i3 + n]);
        }
        edges[0] = new Edge3D(points[0], points[n - 1]);
        edges[n] = new Edge3D(points[n], points[2 * n - 1]);
        edges[2 * n] = new Edge3D(points[0], points[n]);
        Face3D[] faces = new Face3D[]{};
        for (i = 0; i < points.length; ++i) {
            assert (points[i] != null);
        }
        for (i = 0; i < edges.length; ++i) {
            assert (edges[i] != null);
        }
        return new StandardGeometry(points, edges, faces);
    }
}

