/*
 * Decompiled with CFR 0.152.
 */
package tools3d.numerics3d;

import java.awt.geom.NoninvertibleTransformException;
import java.util.logging.Logger;
import tools3d.Vector3D;
import tools3d.numerics3d.Line;

public class Geom3DTools {
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public static Vector3D computeLineDistance(Vector3D x0, Vector3D x, Vector3D y0, Vector3D y) {
        double A = x.lengthSquare();
        double B = 2.0 * (x.dot(x0) - x.dot(y0));
        double C = 2.0 * x.dot(y);
        double D = 2.0 * (y.dot(y0) - y.dot(x0));
        double E = y.lengthSquare();
        double F = x0.lengthSquare() + y0.lengthSquare();
        double denom = C * C - 4.0 * A * E;
        if (denom == 0.0) {
            return new Vector3D(0.0, 0.0, -1.0);
        }
        double s = (2.0 * A * D + B * C) / denom;
        double t = (C * s - B) / (2.0 * A);
        double d = Math.sqrt((B * C * D + B * B * E + C * C * F + A * (D * D - 4.0 * E * F)) / denom);
        return new Vector3D(t, s, d);
    }

    public static Vector3D computeLineMedium(Vector3D x0, Vector3D x, Vector3D y0, Vector3D y) throws NoninvertibleTransformException {
        Vector3D values = Geom3DTools.computeLineDistance(x0, x, y0, y);
        if (values.getZ() < 0.0) {
            throw new NoninvertibleTransformException("Trying to obtain distances between parallel lines: " + x0 + " " + x + " " + y0 + " " + y);
        }
        Vector3D p1 = x0.plus(x.mul(values.getX()));
        Vector3D p2 = y0.plus(y.mul(values.getY()));
        return p1.plus(p2).mul(0.5);
    }

    public static Vector3D computeLineMedium(Line line1, Line line2) throws NoninvertibleTransformException {
        return Geom3DTools.computeLineMedium(line1.offs, line1.dir, line2.offs, line2.dir);
    }

    public static Vector3D computeLinesMedium(Line[] lines) throws NoninvertibleTransformException {
        Vector3D avg = new Vector3D(0.0, 0.0, 0.0);
        int counter = 0;
        for (int i = 0; i < lines.length; ++i) {
            for (int j = i + 1; j < lines.length; ++j) {
                try {
                    Vector3D p = Geom3DTools.computeLineMedium(lines[i], lines[j]);
                    avg.add(p);
                    ++counter;
                    continue;
                }
                catch (NoninvertibleTransformException nite) {
                    // empty catch block
                }
            }
        }
        if (counter == 0) {
            throw new NoninvertibleTransformException("Only parallel lines found. Could not compute mid point of set of lines.");
        }
        avg.scale(1.0 / (double)counter);
        return avg;
    }

    public static double computeDistanceToLine(Vector3D point, Vector3D offset, Vector3D direction) {
        assert (direction.length() > 0.0);
        double result = 0.0;
        Vector3D dVec = point.minus(offset);
        double dLength = dVec.length();
        assert (dLength > 0.0);
        double cosAlpha = dVec.dot(direction) / (dLength * direction.length());
        double alpha = Math.acos(cosAlpha);
        result = dLength * Math.sin(alpha);
        if (cosAlpha < 0.0) assert ((result *= -1.0) <= 0.0);
        assert (result * cosAlpha >= 0.0);
        return result;
    }

    public static double computeDistanceLinePoint(Vector3D point, Vector3D offset, Vector3D direction) {
        assert (direction.length() > 0.0);
        Vector3D dVec = point.minus(offset);
        double dLength = dVec.length();
        assert (dLength > 0.0);
        double result = dVec.dot(direction) / direction.length();
        return result;
    }
}

