/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import java.util.logging.Logger;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DAction;
import tools3d.objects3d.Object3DActionVisitor;

public class FurthestFinder
implements Object3DAction {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private Object3D startPosition;
    private Object3D furthestObject;
    private double furthestDistance;

    public FurthestFinder(Object3D startObject) {
        this.startPosition = startObject;
        this.furthestObject = startObject;
        this.furthestDistance = 0.0;
    }

    @Override
    public void act(Object3D obj) {
        if (obj == null) {
            return;
        }
        double dist = this.startPosition.distance(obj);
        if (dist >= this.furthestDistance) {
            this.furthestDistance = dist;
            this.furthestObject = obj;
        }
    }

    public Object3D getFurthestObject() {
        return this.furthestObject;
    }

    public static Object3D find(Object3D root) {
        FurthestFinder collector = new FurthestFinder(root);
        Object3DActionVisitor visitor = new Object3DActionVisitor(root, collector);
        visitor.nextToEnd();
        Object3D result = collector.getFurthestObject();
        if (result == null) {
            log.warning("Warning from FurthestFinder.find: result null!");
        }
        return result;
    }
}

