/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import generaltools.ConstraintDouble;
import generaltools.SimpleConstraintDouble;
import tools3d.Vector3D;
import tools3d.objects3d.CrossProductLink;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.SimpleLink;

public class SimpleCrossProductLink
extends SimpleLink
implements CrossProductLink {
    private ConstraintDouble constraint;
    private Object3D obj3;
    private Object3D obj4;
    private Object3D obj5;
    private Object3D obj6;

    public SimpleCrossProductLink(Object3D o1, Object3D o2, Object3D o3, Object3D o4, Object3D o5, Object3D o6, ConstraintDouble constraint) {
        super(o1, o2);
        assert (o1 != null);
        assert (o2 != null);
        assert (o3 != null);
        assert (o4 != null);
        assert (o5 != null);
        assert (o6 != null);
        this.obj3 = o3;
        this.obj4 = o4;
        this.obj5 = o5;
        this.obj6 = o6;
        this.constraint = constraint;
    }

    public SimpleCrossProductLink(Object3D o1, Object3D o2, Object3D o3, Object3D o4, Object3D o5, Object3D o6, double min, double max) {
        super(o1, o2);
        this.obj3 = o3;
        this.obj4 = o4;
        this.obj5 = o5;
        this.obj6 = o6;
        this.constraint = new SimpleConstraintDouble(min, max);
    }

    @Override
    public ConstraintDouble getConstraint() {
        return this.constraint;
    }

    @Override
    public Object3D getObj3() {
        return this.obj3;
    }

    @Override
    public Object3D getObj4() {
        return this.obj4;
    }

    @Override
    public Object3D getObj5() {
        return this.obj5;
    }

    @Override
    public Object3D getObj6() {
        return this.obj6;
    }

    @Override
    public double computeError() {
        return this.computeError(this.getObj1().getPosition(), this.getObj2().getPosition(), this.getObj3().getPosition(), this.getObj4().getPosition(), this.getObj5().getPosition(), this.getObj6().getPosition());
    }

    public double computeVolume(Vector3D v1, Vector3D v2, Vector3D v3, Vector3D v4, Vector3D v5, Vector3D v6) {
        Vector3D a = v2.minus(v1);
        a.normalize();
        Vector3D b = v4.minus(v3);
        b.normalize();
        Vector3D c = v6.minus(v5);
        c.normalize();
        double vol = a.cross(b).dot(c);
        return vol;
    }

    @Override
    public double computeError(Vector3D v1, Vector3D v2, Vector3D v3, Vector3D v4, Vector3D v5, Vector3D v6) {
        double ang = Vector3D.torsionAngle(v1, v2, v3, v4);
        assert (ang >= 0.0);
        assert (ang <= Math.PI);
        double vol = this.computeVolume(v1, v2, v3, v4, v5, v6);
        double result = 0.0;
        if (vol < this.constraint.getMin()) {
            result = this.constraint.getMin() - vol;
        } else if (vol > this.constraint.getMax()) {
            result = vol - this.constraint.getMax();
        }
        assert (result >= 0.0);
        assert (result <= Math.PI);
        return result;
    }
}

