/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import org.testng.annotations.Test;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.AABBBoundingVolume;
import tools3d.Appearance;
import tools3d.BoundingVolume;
import tools3d.CoordinateSystem;
import tools3d.Dimension3D;
import tools3d.Geometry;
import tools3d.Matrix3D;
import tools3d.Matrix3DTools;
import tools3d.Point;
import tools3d.Positionable3D;
import tools3d.Shape3DActor;
import tools3d.Shape3DSet;
import tools3d.StandardGeometry;
import tools3d.Symmetry;
import tools3d.Vector3D;
import tools3d.Vector4D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.Object3DVisitor;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.symmetry2.SymCopies;
import tools3d.symmetry2.SymCopySingleton;

public class SimpleObject3D
implements Object3D {
    private static final String className = "Object3D";
    public static final String CLASS_NAME = "Object3D";
    protected static Logger log = Logger.getLogger("NanoTiler_debug");
    private HashMap<String, Integer> nameIndices;
    private Appearance appearance;
    private boolean finalPoint;
    private boolean selected;
    private double boundingBox = -1.0;
    private double boundingRadius;
    private double rotationAngle;
    private double zBufValue;
    private int number;
    private int typeId;
    private LinkSet links = new SimpleLinkSet();
    private List<Object3D> children;
    private Object3D parent;
    private Properties properties;
    private BoundingVolume boundingVolume;
    private Shape3DActor actor = null;
    private Shape3DSet shapeSet;
    private String name;
    private Vector<Symmetry> symmetriesVector = new Vector();
    private Vector3D dimensions;
    protected Vector3D relativePosition;
    private Vector3D rotationAxis;
    protected Vector3D scaling;
    private double score = 0.0;
    private String filename = "default_name";

    public SimpleObject3D() {
        this.appearance = new Appearance();
        this.selected = false;
        this.number = 0;
        this.typeId = 0;
        this.name = "unnamed";
        this.relativePosition = new Vector3D(0.0, 0.0, 0.0);
        this.scaling = new Vector3D(1.0, 1.0, 1.0);
        this.rotationAxis = new Vector3D(1.0, 0.0, 0.0);
        this.rotationAngle = 0.0;
        this.parent = null;
        this.children = new ArrayList<Object3D>();
        this.zBufValue = 0.0;
        this.updateNameIndices();
    }

    public SimpleObject3D(String name) {
        this();
        this.setName(name);
    }

    public SimpleObject3D(Object3D obj) {
        assert (obj.isValid());
        log.warning("Constructor not yet implemented");
        this.copy(obj);
    }

    public SimpleObject3D(Vector3D position) {
        this();
        assert (position.isValid());
        this.relativePosition = new Vector3D(position);
    }

    @Override
    public void accept(Object3DVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void act() {
        if (this.actor != null) {
            this.actor.act(this);
        }
    }

    @Override
    public void activeTransform(CoordinateSystem cs) {
        Vector3D newPos = cs.activeTransform(this.getPosition());
        this.setIsolatedPosition(newPos);
        for (int i = 0; i < this.size(); ++i) {
            this.getChild(i).activeTransform(cs);
        }
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public void passiveTransform(CoordinateSystem cs) {
        Vector3D newPos = cs.passiveTransform(this.getPosition());
        this.setIsolatedPosition(newPos);
        for (int i = 0; i < this.size(); ++i) {
            this.getChild(i).passiveTransform(cs);
        }
    }

    @Override
    public void activeTransform2(CoordinateSystem cs) {
        Vector3D newPos = cs.activeTransform2(this.getPosition());
        this.setIsolatedPosition(newPos);
        for (int i = 0; i < this.size(); ++i) {
            this.getChild(i).activeTransform2(cs);
        }
    }

    @Override
    public void activeTransform3(CoordinateSystem cs) {
        Vector3D newPos = cs.activeTransform3(this.getPosition());
        this.setIsolatedPosition(newPos);
        for (int i = 0; i < this.size(); ++i) {
            this.getChild(i).activeTransform3(cs);
        }
    }

    @Override
    public void passiveTransform2(CoordinateSystem cs) {
        Vector3D newPos = cs.passiveTransform2(this.getPosition());
        this.setIsolatedPosition(newPos);
        for (int i = 0; i < this.size(); ++i) {
            this.getChild(i).passiveTransform2(cs);
        }
    }

    @Override
    public void passiveTransform3(CoordinateSystem cs) {
        Vector3D newPos = cs.passiveTransform3(this.getPosition());
        this.setIsolatedPosition(newPos);
        for (int i = 0; i < this.size(); ++i) {
            this.getChild(i).passiveTransform3(cs);
        }
    }

    @Override
    public void addLink(Link link) {
        this.links.add(link);
    }

    public void addSymmetry(Symmetry symmetry) {
        this.symmetriesVector.add(symmetry);
    }

    @Override
    public boolean checkChildrenUnique() {
        return this.size() <= 0 || this.nameIndices != null;
    }

    @Override
    public void clear() {
        this.number = 0;
        this.typeId = 0;
        this.boundingRadius = 1.0;
        this.name = "";
        this.relativePosition.mul(0.0);
        this.scaling = new Vector3D(1.0, 1.0, 1.0);
        this.rotationAxis = new Vector3D(1.0, 1.0, 1.0);
        this.rotationAngle = 0.0;
        this.parent = null;
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).clear();
        }
        this.children.clear();
        this.links.clear();
        this.properties = null;
        this.updateNameIndices();
        this.invalidateBoundingCache();
    }

    @Override
    public Object cloneDeep() {
        Object3D newObj = (Object3D)this.cloneDeepThis();
        for (int i = 0; i < this.size(); ++i) {
            newObj.insertChild((Object3D)this.getChild(i).cloneDeep());
        }
        return newObj;
    }

    @Override
    public Object cloneDeepThis() {
        if (!this.getClassName().equals("Object3D")) {
            log.warning("Warning: Object3D class expected: " + this.getClassName());
        }
        assert (this.getClassName().equals("Object3D"));
        SimpleObject3D newObj = new SimpleObject3D();
        newObj.copyDeepThisCore(this);
        return newObj;
    }

    @Override
    public Object cloneEmpty() {
        return new SimpleObject3D();
    }

    @Override
    public int compareTo(Positionable3D object) {
        double objectVal = object.getZBufValue();
        if (this.zBufValue < objectVal) {
            return -1;
        }
        if (this.zBufValue > objectVal) {
            return 1;
        }
        return 0;
    }

    @Override
    public void copy(Object3D orig) {
        log.warning("Warning: copy not yet implemented!");
    }

    protected void copyDeepThisCore(SimpleObject3D obj) {
        this.appearance = obj.appearance;
        this.selected = obj.selected;
        this.number = obj.number;
        this.typeId = obj.typeId;
        this.boundingRadius = obj.boundingRadius;
        this.actor = obj.actor;
        this.score = obj.score;
        this.shapeSet = obj.shapeSet;
        this.name = new String(obj.name);
        if (obj.dimensions != null) {
            this.dimensions = (Vector3D)obj.dimensions.clone();
        }
        this.setPosition(obj.getPosition());
        if (obj.scaling != null) {
            this.scaling = (Vector3D)obj.scaling.clone();
        }
        if (obj.rotationAxis != null) {
            this.rotationAxis = (Vector3D)obj.rotationAxis.clone();
        }
        this.rotationAngle = obj.rotationAngle;
        this.properties = obj.properties != null ? (Properties)obj.properties.clone() : null;
        this.zBufValue = obj.zBufValue;
        this.invalidateBoundingCache();
    }

    @Override
    public boolean contains(Object3D obj) {
        return this.children.contains(obj);
    }

    @Override
    public Geometry createGeometry(double angleDelta) {
        return StandardGeometry.createSinglePointGeometry(this.getPosition());
    }

    @Override
    public double distance(Positionable3D other) {
        Vector3D p1 = this.getPosition();
        Vector3D p2 = other.getPosition();
        assert (p1.isValid());
        assert (p2.isValid());
        return p1.minus(p2).length();
    }

    public double distance(Vector3D vector3d, Point point2) {
        Point point1 = new Point(vector3d.getX(), vector3d.getY(), vector3d.getZ());
        double distance = this.distance(point1, point2);
        return distance;
    }

    public double distance(Point point1, Point point2) {
        double x1 = point1.getX();
        double x2 = point2.getX();
        double y1 = point1.getY();
        double y2 = point2.getY();
        double z1 = point1.getZ();
        double z2 = point2.getZ();
        double distance = Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0));
        return distance;
    }

    @Override
    public Shape3DActor getActor() {
        return this.actor;
    }

    @Override
    public Appearance getAppearance() {
        return this.appearance;
    }

    @Override
    public double getBoundingRadius() {
        return this.boundingRadius;
    }

    @Override
    public double getBoundingBox() {
        if (!this.isBoundingBoxCacheValid()) {
            this.cacheBoundingBox();
        }
        return this.boundingBox;
    }

    @Override
    public BoundingVolume getBoundingVolume() {
        if (this.boundingVolume == null) {
            this.generateBoundingVolume();
        }
        return this.boundingVolume;
    }

    @Override
    public Dimension3D getDimension() {
        Vector3D position = this.getPosition();
        return new Dimension3D(position.getX() - 0.5, position.getY() - 0.5, position.getZ() - 0.5, 1.0, 1.0, 1.0);
    }

    private void generateBoundingVolume() {
        if (this.size() == 0) {
            Dimension3D dim = this.getDimension();
            this.boundingVolume = new AABBBoundingVolume(new Vector4D(dim.getX() + dim.getWidth(), dim.getY() + dim.getHeight(), dim.getZ() + dim.getDepth(), 1.0), new Vector4D(dim.getX(), dim.getY(), dim.getZ(), 1.0));
            return;
        }
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        double minZ = Double.MAX_VALUE;
        double maxZ = -1.7976931348623157E308;
        Vector4D position = new Vector4D(this.getPosition());
        for (int i = 0; i < this.size(); ++i) {
            Vector4D[] vertices = this.getChild(i).getBoundingVolume().getVertices();
            for (int j = 0; j < vertices.length; ++j) {
                Vector4D difference = new Vector4D(this.getChild(i).getPosition());
                difference.add(vertices[j]);
                difference = difference.minus(position);
                minX = Math.min(minX, difference.getX());
                maxX = Math.max(maxX, difference.getX());
                minY = Math.min(minY, difference.getY());
                maxY = Math.max(maxY, difference.getY());
                minZ = Math.min(minZ, difference.getZ());
                maxZ = Math.max(maxZ, difference.getZ());
            }
        }
        this.boundingVolume = new AABBBoundingVolume(new Vector4D(minX, minY, minZ, 1.0), new Vector4D(maxX, maxY, maxZ, 1.0));
    }

    private void cacheBoundingBox() {
        if (this.size() == 0) {
            this.boundingBox = 1.0;
            if (this.getParent() != null) {
                ((SimpleObject3D)this.getParent()).cacheBoundingBox();
            }
            return;
        }
        Object3D o = null;
        double distance = -1.0;
        for (int i = 0; i < this.size(); ++i) {
            Object3D child = this.getChild(i);
            double d = this.getPosition().distance(child.getPosition());
            if (!(d > distance)) continue;
            o = child;
            distance = d;
        }
        this.boundingBox = distance + o.getBoundingBox();
        if (this.getParent() != null) {
            ((SimpleObject3D)this.getParent()).cacheBoundingBox();
        }
    }

    private void invalidateBoundingCache() {
        this.boundingBox = -1.0;
        this.boundingVolume = null;
        if (this.getParent() != null) {
            ((SimpleObject3D)this.getParent()).invalidateBoundingCache();
        }
    }

    private boolean isBoundingBoxCacheValid() {
        return this.boundingBox >= 0.0;
    }

    @Override
    public Object3D getChild(int n) {
        return this.children.get(n);
    }

    @Override
    public Object3D getChild(Object3D o) {
        for (int i = 0; i < this.children.size(); ++i) {
            Object3D child = this.getChild(i);
            if (child.getPosition().getX() != o.getPosition().getX() || child.getPosition().getY() != o.getPosition().getY() || child.getPosition().getZ() != o.getPosition().getZ()) continue;
            return child;
        }
        log.warning("Child: " + o + " was not found in Object3D: " + this);
        return null;
    }

    @Override
    public Object3D getChild(String name) {
        if (name == null || name.length() == 0) {
            log.warning("Insufficent child node name!");
            return null;
        }
        int idx = -1;
        if (name.charAt(0) == '(') {
            String[] subwords = name.split("\\)");
            if (subwords.length != 2) {
                log.warning("Expected one closing bracked in child object name: " + name);
                return null;
            }
            subwords[0] = subwords[0].substring(1);
            try {
                int id = Integer.parseInt(subwords[1]) - 1;
                String className = subwords[0];
                if (className.equals("hxend")) {
                    className = "BranchDescriptor3D";
                } else if (className.equals("helixend")) {
                    className = "BranchDescriptor3D";
                } else if (className.equals("atom")) {
                    className = "Atom3D";
                } else if (className.equals("strand")) {
                    className = "RnaStrand";
                } else if (className.equals("residue")) {
                    className = "Nucleotide3D";
                } else if (className.equals("stem")) {
                    className = "RnaStem3D";
                }
                idx = this.getIndexOfChild(id, className);
            }
            catch (NumberFormatException nfe) {
                log.warning("Number format exception: " + nfe.getMessage());
            }
        } else {
            idx = this.getIndexOfChild(name);
        }
        if (idx < 0) {
            String childNames = "";
            for (int i = 0; i < this.size(); ++i) {
                childNames = childNames + this.getChild(i).getName() + " ";
            }
            assert (this.nameIndices == null || this.nameIndices.get(name) == null);
            return null;
        }
        return this.children.get(idx);
    }

    @Override
    public int getChildClassCounter(Object3D child) {
        String childClass = child.getClassName();
        int counter = 0;
        boolean found = false;
        for (int i = 0; i < this.size(); ++i) {
            if (this.getChild(i) == child) {
                found = true;
                break;
            }
            if (!this.getChild(i).getClassName().equals(childClass)) continue;
            ++counter;
        }
        assert (found);
        return counter;
    }

    @Override
    public int getChildCount(String childClassName) {
        int counter = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getChild(i).getClassName().equals(childClassName)) continue;
            ++counter;
        }
        return counter;
    }

    @Override
    public String getClassName() {
        return "Object3D";
    }

    @Override
    public int getDepth() {
        if (this.parent != null) {
            return this.parent.getDepth() + 1;
        }
        return 0;
    }

    @Override
    public Vector3D getDimensions() {
        return this.dimensions;
    }

    public boolean getFinalPoint() {
        return this.finalPoint;
    }

    @Override
    public int getIndexOfChild(int n, String childClassName) {
        int counter = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getChild(i).getClassName().equals(childClassName)) continue;
            if (counter == n) {
                return i;
            }
            ++counter;
        }
        return -1;
    }

    @Override
    public int getIndexOfChild(Object3D child) {
        for (int i = 0; i < this.size(); ++i) {
            if (!child.equals(this.children.get(i))) continue;
            return i;
        }
        assert (false);
        return -1;
    }

    @Override
    public int getIndexOfChild(String name) {
        if (this.nameIndices == null) {
            this.updateNameIndices();
        }
        if (this.nameIndices == null) {
            return -1;
        }
        Integer integer = this.nameIndices.get(name);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    public int getLinkNumber(Object3D obj) {
        return this.links.getLinkNumber(this, obj);
    }

    @Override
    public LinkSet getLinks() {
        return this.links;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getFullName() {
        return Object3DTools.getFullName(this);
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    public int getNumSymmetries() {
        return this.symmetriesVector.size();
    }

    @Override
    public Object3D getParent() {
        return this.parent;
    }

    @Override
    public Vector3D getPosition() {
        if (this.parent == null) {
            return new Vector3D(this.getRelativePosition());
        }
        return this.getRelativePosition().plus(this.parent.getPosition());
    }

    @Override
    public Vector3D getPosition(int symId) {
        assert (symId >= 0);
        Vector3D pos = this.getPosition();
        if (symId == 0) {
            return pos;
        }
        SymCopies symCopies = SymCopySingleton.getInstance();
        assert (symId < symCopies.size());
        return symCopies.getPosition(pos, symId);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(key);
    }

    @Override
    public Vector3D getRelativePosition() {
        return new Vector3D(this.relativePosition);
    }

    @Override
    public double getRotationAngle() {
        return this.rotationAngle;
    }

    @Override
    public Vector3D getRotationAxis() {
        return this.rotationAxis;
    }

    @Override
    public Vector3D getScalingFactor() {
        return this.scaling;
    }

    @Override
    public Shape3DSet getShapeSet() {
        return this.shapeSet;
    }

    @Override
    public String getShapeName() {
        return "Object3D";
    }

    @Override
    public Object3D getSibling(int n) {
        if (this.parent == null || n >= this.getSiblingCount()) {
            return null;
        }
        return this.parent.getChild(n);
    }

    @Override
    public int getSiblingCount() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.size();
    }

    @Override
    public int getSiblingId() {
        if (this.parent == null) {
            return 0;
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.getChild(i) != this) continue;
            return i;
        }
        assert (false);
        return this.parent.size();
    }

    public Symmetry getSymmetry(int i) {
        return this.symmetriesVector.get(i);
    }

    @Override
    public double getZBufValue() {
        return this.zBufValue;
    }

    public boolean hasSymmetries() {
        return this.symmetriesVector.size() > 0;
    }

    @Override
    public int getTotalNumberOfObjects() {
        int sum = 1;
        if (this.size() == 0) {
            return sum;
        }
        for (int i = 0; i < this.size(); ++i) {
            sum += this.getChild(i).getTotalNumberOfObjects();
        }
        return sum;
    }

    @Override
    public int getTypeId() {
        return this.typeId;
    }

    @Override
    public String infoString() {
        String result = new String();
        result = "(" + this.getClassName() + " " + this.infoStringBody() + "(children " + this.size() + " ";
        for (int i = 0; i < this.size(); ++i) {
            result = result + this.getChild(i).getName() + " ";
        }
        result = result + " ) )";
        return result;
    }

    public String infoStringBody() {
        String result = new String();
        result = this.getName() + " ";
        result = result + this.getPosition();
        return result;
    }

    @Override
    public String findSaveName(String name) {
        if (this.getChild(name) == null) {
            return name;
        }
        for (int i = 1; i > 0; ++i) {
            String newName = name + i;
            if (this.getChild(newName) != null) continue;
            return newName;
        }
        assert (false);
        return null;
    }

    @Override
    public String insertChildSave(Object3D child) {
        return this.insertChildSafe(child);
    }

    @Override
    public String insertChildSafe(Object3D child) {
        if (this.getChild(child.getName()) != null) {
            child.setName(this.findSaveName(child.getName()));
            assert (child.getName() != null);
            assert (this.getChild(child.getName()) == null);
            this.insertChild(child);
        } else {
            this.insertChild(child);
        }
        return child.getName();
    }

    @Override
    public void insertChild(Object3D child) {
        assert (this.getChild(child.getName()) == null);
        this.insertChild(child, this.size());
    }

    @Override
    public void insertChild(Object3D child, int position) {
        assert (position >= 0);
        assert (position <= this.size());
        if (child == null) {
            return;
        }
        Vector3D childPos = new Vector3D(child.getPosition());
        child.setRelativePosition(childPos.minus(this.getPosition()));
        child.setParent(this);
        this.children.add(position, child);
        this.updateNameIndices();
        this.invalidateBoundingCache();
    }

    @Override
    public boolean isProbablyEqual(Object3D obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClassName().equals(this.getClassName()) || !obj.getName().equals(this.getName())) {
            return false;
        }
        double dist = this.distance(obj);
        if (dist > 0.001) {
            return false;
        }
        if (this.size() != obj.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.getChild(i).isProbablyEqual(obj.getChild(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean isValid() {
        boolean check1 = this.getPosition().isValid();
        if (!check1) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.getChild(i).getParent() == this) continue;
            return false;
        }
        return true;
    }

    @Override
    public void removeChild(Object3D child) {
        int origSize = this.size();
        this.children.remove(child);
        this.updateNameIndices();
        assert (this.size() + 1 == origSize);
        this.invalidateBoundingCache();
    }

    @Override
    public void removeChild(int n) {
        assert (n >= 0 && n < this.size());
        int origSize = this.size();
        this.children.remove(n);
        this.updateNameIndices();
        assert (this.size() + 1 == origSize);
        this.invalidateBoundingCache();
    }

    @Override
    public void removeLink(Link link) {
        this.links.remove(link);
    }

    @Override
    public void replaceChild(int n, Object3D child) {
        assert (n < this.size());
        assert (n >= 0);
        assert (child != null);
        Vector3D childPos = new Vector3D(child.getPosition());
        Object3D oldChild = this.getChild(n);
        assert (oldChild != null);
        oldChild.setParent(null);
        child.setRelativePosition(childPos.minus(this.getPosition()));
        child.setParent(this);
        this.children.set(n, child);
        this.updateNameIndices();
        this.invalidateBoundingCache();
    }

    @Override
    public void rotate(Vector3D axis, double angle) {
        this.rotate(this.getPosition(), axis, angle);
    }

    @Override
    public void rotate(Vector3D center, Vector3D axis, double angle) {
        if (angle == 0.0) {
            return;
        }
        Vector3D shiftedPos = this.getPosition().minus(center);
        Vector3D rotatedPos = Matrix3DTools.rotate(shiftedPos, axis, angle);
        this.setIsolatedPosition(rotatedPos.plus(center));
        this.setRotationAxis(axis);
        this.setRotationAngle(angle);
        for (int i = 0; i < this.size(); ++i) {
            Object3D child = this.getChild(i);
            child.rotate(center, axis, angle);
        }
        this.invalidateBoundingCache();
    }

    @Override
    public void twist(Vector3D center, Vector3D axis, double anglePerProjection) {
        if (anglePerProjection == 0.0) {
            return;
        }
        Vector3D shiftedPos = this.getPosition().minus(center);
        double projection = shiftedPos.dot(axis) / axis.length();
        double angle = projection * anglePerProjection;
        Vector3D rotatedPos = Matrix3DTools.rotate(shiftedPos, axis, angle);
        this.setIsolatedPosition(rotatedPos.plus(center));
        this.setRotationAxis(axis);
        this.setRotationAngle(angle);
        for (int i = 0; i < this.size(); ++i) {
            Object3D child = this.getChild(i);
            child.twist(center, axis, anglePerProjection);
        }
        this.invalidateBoundingCache();
    }

    @Override
    public void rotate(Vector3D center, Matrix3D rotationMatrix) {
        Vector3D shiftedPos = this.getPosition().minus(center);
        Vector3D rotatedPos = rotationMatrix.multiply(shiftedPos);
        this.setIsolatedPosition(rotatedPos.plus(center));
        for (int i = 0; i < this.size(); ++i) {
            Object3D child = this.getChild(i);
            child.rotate(center, rotationMatrix);
        }
        this.translate(center);
    }

    @Test
    public void testRotate() {
        SimpleObject3D a = new SimpleObject3D(new Vector3D(1.0, 1.0, 0.0));
        SimpleObject3D b = new SimpleObject3D(new Vector3D(-1.0, 1.0, 0.0));
        SimpleObject3D o = new SimpleObject3D(new Vector3D(0.0, 0.0, 0.0));
        Vector3D vect1 = a.getPosition().minus(o.getPosition());
        Vector3D vect2 = b.getPosition().minus(o.getPosition());
        Vector3D vect3 = vect1.cross(vect2);
        a.rotate(o.getPosition(), vect3, vect1.angle(vect2));
        assert (a.getPosition().equals(b.getPosition()));
    }

    public void rotateStartEnd(Point start, Point end, double angle) {
        this.rotate(start.getVector3D(), end.getVector3D().minus(start.getVector3D()), angle);
    }

    @Override
    public void scale(Vector3D factor) {
        this.scaling.scale(factor);
        this.relativePosition.scale(factor);
        for (int i = 0; i < this.size(); ++i) {
            this.getChild(i).scale(factor);
        }
    }

    @Override
    public void setActor(Shape3DActor actor) {
        this.actor = actor;
    }

    @Override
    public void setAppearance(Appearance appearance) {
        this.appearance = appearance;
    }

    @Override
    public void setBoundingRadius(double radius) {
        this.boundingRadius = radius;
    }

    @Override
    public void setDimensions(Vector3D d) {
        this.dimensions = d;
    }

    @Override
    public void setFinalPoint(boolean finalPoint) {
        this.finalPoint = finalPoint;
    }

    @Override
    public void setFilename(String s) {
        this.filename = s;
    }

    @Override
    public void setIsolatedPosition(Vector3D point) {
        Vector3D currentPos = this.getPosition();
        Vector3D shift = point.minus(currentPos);
        Vector3D negShift = shift.mul(-1.0);
        for (int i = 0; i < this.size(); ++i) {
            Object3D child = this.getChild(i);
            child.translate(negShift);
        }
        this.translate(shift);
    }

    public void setLinkSet(LinkSet l) {
        this.links = l;
    }

    @Override
    public void setName(String n) {
        this.name = new String(n);
    }

    @Override
    public void setNumber(int n) {
        this.number = n;
    }

    @Override
    public void setParent(Object3D p) {
        this.parent = p;
        if (p != null) {
            ((SimpleObject3D)p).invalidateBoundingCache();
        }
    }

    @Override
    public void setPosition(Vector3D point) {
        assert (point.isValid());
        Vector3D currentPos = this.getPosition();
        Vector3D shift = point.minus(currentPos);
        this.translate(shift);
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(key, value);
    }

    @Override
    public void setScore(double score) {
        this.score = score;
    }

    @Override
    public void setRelativePosition(Vector3D v) {
        this.relativePosition.copy(v);
        this.invalidateBoundingCache();
    }

    @Override
    public void setRotationAngle(double a) {
        this.rotationAngle = a;
    }

    @Override
    public void setRotationAxis(Vector3D v) {
        this.rotationAxis = v;
    }

    @Override
    public void setSelected(boolean f) {
        this.selected = f;
    }

    @Override
    public void setShapeSet(Shape3DSet shapeSet) {
        this.shapeSet = shapeSet;
    }

    @Override
    public void setZBufValue(double d) {
        this.zBufValue = d;
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public String toString() {
        return this.infoString();
    }

    public String toString2() {
        String result = new String();
        result = "(" + this.getClassName() + " " + this.toStringBody() + " )";
        return result;
    }

    public static String toStringBody(Object3D obj) {
        return ((Object)obj).toString();
    }

    public String toStringBody() {
        String result = new String();
        result = this.getName() + " ";
        result = result + this.getPosition();
        result = result + " (children " + this.size();
        for (int i = 0; i < this.size(); ++i) {
            result = !(this instanceof StrandJunction3D) && !(this.getChild(i) instanceof RnaStrand) ? result + " " + ((Object)this.getChild(i)).toString() : result + " (RnaStrand )";
        }
        result = result + " ) ";
        return result;
    }

    @Override
    public void translate(Vector3D vec) {
        this.relativePosition.add(vec);
        this.invalidateBoundingCache();
    }

    public void write(PrintWriter pw) {
        pw.print("(Object3D ");
        if (this.name != null && this.name.length() > 0) {
            pw.print(this.name + " ");
        } else {
            pw.print("unnamed ");
        }
        pw.print(")");
    }

    @Override
    public boolean isAncestor(Object3D o) {
        if (o.getParent() == null) {
            return false;
        }
        if (this.equals(o.getParent())) {
            return true;
        }
        return this.isAncestor(o.getParent());
    }

    private void updateNameIndices() {
        if (this.size() == 0) {
            this.nameIndices = null;
            return;
        }
        if (this.nameIndices == null) {
            this.nameIndices = new HashMap();
        }
        this.nameIndices.clear();
        for (int i = 0; i < this.size(); ++i) {
            this.nameIndices.put(this.getChild(i).getName(), new Integer(i));
        }
        if (this.nameIndices.size() != this.size()) {
            this.nameIndices = null;
            log.info("Duplicate child name detected for object: " + this.getName());
        }
    }
}

