/*
 * Decompiled with CFR 0.152.
 */
package viewer.commands;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.BoundingVolume;
import tools3d.CollisionDetectionTools;
import tools3d.Vector3D;
import tools3d.Vector4D;
import tools3d.objects3d.Object3DSetTools;
import tools3d.objects3d.SimpleObject3DSet;
import viewer.commands.DisplayCommand;
import viewer.display.Display;
import viewer.display.OrthogonalDisplay;
import viewer.display.PerspectiveDisplay;
import viewer.util.Tools;

public class FindObject
implements DisplayCommand {
    private Object3DGraphController controller;

    public FindObject(Object3DGraphController controller) {
        this.controller = controller;
    }

    @Override
    public JComponent component(final Display d) {
        JButton button = new JButton("Find");
        button.setToolTipText("Find");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindObject.this.execute(d);
            }
        });
        return button;
    }

    @Override
    public String description() {
        return "Centers camera on the entire object";
    }

    @Override
    public void execute(Display d) {
        if (d instanceof PerspectiveDisplay) {
            this.centerPerspectiveDisplay((PerspectiveDisplay)d);
        } else {
            this.centerOrthogonalDisplay((OrthogonalDisplay)d);
        }
    }

    public void centerPerspectiveDisplay(PerspectiveDisplay d) {
        Vector4D direction = d.getView().getViewDirection();
        Vector4D normal = d.getView().getViewDirectionNormal();
        Vector4D location = d.getView().getViewLocation();
        Vector4D cross = direction.cross(normal);
        cross.normalize();
        double maxDV = -1.7976931348623157E308;
        double maxDU = -1.7976931348623157E308;
        double minDV = Double.MAX_VALUE;
        double minDU = Double.MAX_VALUE;
        BoundingVolume volume = this.controller.getGraph().getGraph().getBoundingVolume();
        double distance = Double.MAX_VALUE;
        Vector4D closest = null;
        double closestDValue = -1.0 * location.dot(direction);
        for (Vector4D vertex : volume.getVertices()) {
            double dist;
            double dU = Tools.project(vertex, cross);
            double dV = Tools.project(vertex, normal);
            if (dU > maxDU) {
                maxDU = dU;
            }
            if (dV > maxDV) {
                maxDV = dV;
            }
            if (dU < minDU) {
                minDU = dU;
            }
            if (dV < minDV) {
                minDV = dV;
            }
            if (!((dist = direction.dot(vertex) + closestDValue) < distance)) continue;
            closest = vertex;
            distance = dist;
        }
        double dValue = -1.0 * direction.dot(closest);
        Vector4D minPoint = cross.mul(minDU).plus(normal.mul(minDV));
        Vector4D maxPoint = cross.mul(maxDU).plus(normal.mul(maxDV));
        double angle = Math.PI * (d.getAngle() / 2.0) / 180.0;
        Vector4D tn = Tools.rotate(normal, cross, angle);
        Vector4D bn = Tools.rotate(normal.mul(-1.0), cross, -angle);
        Vector4D ln = Tools.rotate(cross.mul(-1.0), normal, angle);
        Vector4D rn = Tools.rotate(cross, normal, -angle);
        Vector4D ltr = CollisionDetectionTools.intersecton3Planes(ln, minPoint, rn, maxPoint, tn, maxPoint);
        Vector4D trb = CollisionDetectionTools.intersecton3Planes(tn, maxPoint, rn, maxPoint, bn, minPoint);
        Vector4D rbl = CollisionDetectionTools.intersecton3Planes(rn, maxPoint, bn, minPoint, ln, minPoint);
        Vector4D blt = CollisionDetectionTools.intersecton3Planes(bn, minPoint, ln, minPoint, tn, maxPoint);
        double ltrProj = direction.dot(ltr) + dValue;
        double trbProj = direction.dot(trb) + dValue;
        double min = Math.min(ltrProj, trbProj);
        double x = (ltr.getX() + trb.getX() + rbl.getX() + blt.getX()) / 4.0;
        double y = (ltr.getY() + trb.getY() + rbl.getY() + blt.getY()) / 4.0;
        if (min == ltrProj) {
            d.getView().setViewLocation(x, y, (ltr.getZ() + rbl.getZ()) / 2.0);
        } else {
            d.getView().setViewLocation(x, y, (trb.getZ() + blt.getZ()) / 2.0);
        }
    }

    public void centerOrthogonalDisplay(OrthogonalDisplay d) {
        Vector3D center = Object3DSetTools.centerOfMass(new SimpleObject3DSet(this.controller.getGraph().getGraph()));
        d.getView().lookAt(center.getX(), center.getY(), center.getZ());
        double minZ = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minX = Double.MAX_VALUE;
        double maxZ = -4.9E-324;
        double maxY = -4.9E-324;
        double maxX = -4.9E-324;
        BoundingVolume volume = this.controller.getGraph().getGraph().getBoundingVolume();
        for (Vector4D v : volume.getVertices()) {
            if (v.getX() < minX) {
                minX = v.getX();
            }
            if (v.getX() > maxX) {
                maxX = v.getX();
            }
            if (v.getY() < minY) {
                minY = v.getY();
            }
            if (v.getY() > maxY) {
                maxY = v.getY();
            }
            if (v.getZ() < minZ) {
                minZ = v.getZ();
            }
            if (!(v.getZ() > maxZ)) continue;
            maxZ = v.getZ();
        }
        double x = (maxX - minX) / 2.0;
        double y = (maxY - minY) / 2.0;
        double z = (maxZ - minZ) / 2.0;
        double max = Math.max(x, Math.max(y, z));
        if (Math.abs(max) <= 1.0E-9) {
            return;
        }
        double screen = Math.max(d.getSize().width, d.getSize().height);
        double zoom = screen / (2.0 * max);
        d.getView().setZoom(zoom);
    }

    @Override
    public KeyStroke keyStroke() {
        return KeyStroke.getKeyStroke(70, 2, true);
    }
}

