/*
 * Decompiled with CFR 0.152.
 */
package viewer.components;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import viewer.util.KeyBindings;
import viewer.view.OrthogonalView;
import viewer.view.PerspectiveView;
import viewer.view.ViewType;

public class ViewManipulator
extends JPanel {
    private ViewType viewType;
    private OrthogonalView view;
    private JButton translate;
    private JButton zoom;
    private JButton rotate;
    private JCheckBox absolute;
    private static final String NANOTILER_HOME = System.getenv("NANOTILER_HOME");
    private static final ImageIcon ROTATE_ICON = new ImageIcon(NANOTILER_HOME + "/resources/rotate.gif");
    private static final ImageIcon ZOOM_ICON = new ImageIcon(NANOTILER_HOME + "/resources/zoom.gif");
    private static final ImageIcon TRANSLATE_ICON = new ImageIcon(NANOTILER_HOME + "/resources/translate.gif");
    private ZoomListener zoomListener;
    private RotateListener rotateListener;
    private TranslateListener translateListener;
    private double rotationSensitivity = 0.1;
    private KeyBindings bindings = KeyBindings.getKeyBindings();
    private static final Dimension BUTTON_DIM = new Dimension(18, 18);

    public ViewType getViewType() {
        return this.viewType;
    }

    public void setViewType(ViewType viewType) {
        this.viewType = viewType;
    }

    public boolean isAbsolute() {
        return this.absolute.isSelected();
    }

    public void setAbsolute(boolean b) {
        this.absolute.setSelected(b);
    }

    public ViewManipulator(PerspectiveView view) {
        this.view = view;
        this.viewType = ViewType.Perspective;
        this.createGUI();
        this.handleViewChange();
    }

    public ViewManipulator(OrthogonalView view) {
        this.view = view;
        this.viewType = ViewType.Orthogonal;
        this.createGUI();
        this.handleViewChange();
    }

    public void setView(OrthogonalView view) {
        this.view = view;
        this.viewType = ViewType.Orthogonal;
        this.handleViewChange();
    }

    public void setView(PerspectiveView view) {
        this.view = view;
        this.viewType = ViewType.Perspective;
        this.handleViewChange();
    }

    private void handleViewChange() {
        if (this.viewType == ViewType.Orthogonal) {
            this.absolute.setSelected(true);
            this.absolute.setEnabled(false);
            this.rotate.setEnabled(false);
        } else {
            this.absolute.setEnabled(true);
            this.rotate.setEnabled(true);
            this.absolute.setSelected(false);
        }
    }

    private void createGUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.translate = new JButton(TRANSLATE_ICON);
        this.zoom = new JButton(ZOOM_ICON);
        this.rotate = new JButton(ROTATE_ICON);
        this.absolute = new JCheckBox("Absolute");
        this.translate.setToolTipText("Translate");
        this.zoom.setToolTipText("Zoom");
        this.rotate.setToolTipText("Rotate");
        this.translate.setPreferredSize(BUTTON_DIM);
        this.translate.setMinimumSize(BUTTON_DIM);
        this.translate.setMaximumSize(BUTTON_DIM);
        this.zoom.setPreferredSize(BUTTON_DIM);
        this.zoom.setMinimumSize(BUTTON_DIM);
        this.zoom.setMaximumSize(BUTTON_DIM);
        this.rotate.setPreferredSize(BUTTON_DIM);
        this.rotate.setMinimumSize(BUTTON_DIM);
        this.rotate.setMaximumSize(BUTTON_DIM);
        this.rotateListener = new RotateListener();
        this.zoomListener = new ZoomListener();
        this.translateListener = new TranslateListener();
        this.translate.addActionListener(this.translateListener);
        this.zoom.addActionListener(this.zoomListener);
        this.rotate.addActionListener(this.rotateListener);
        this.translate.addMouseMotionListener(this.translateListener);
        this.zoom.addMouseMotionListener(this.zoomListener);
        this.rotate.addMouseMotionListener(this.rotateListener);
        this.translate.addMouseListener(this.translateListener);
        this.zoom.addMouseListener(this.zoomListener);
        this.rotate.addMouseListener(this.rotateListener);
        this.add(this.translate);
        this.add(Box.createHorizontalStrut(3));
        this.add(this.rotate);
        this.add(Box.createHorizontalStrut(3));
        this.add(this.zoom);
        this.add(Box.createHorizontalStrut(3));
        this.add(this.absolute);
    }

    public boolean isTransformationAbsolute() {
        return this.absolute.isSelected();
    }

    public void setTransformationAbsolute(boolean b) {
        this.absolute.setSelected(b);
    }

    public RotateListener getRotateListener() {
        return this.rotateListener;
    }

    public TranslateListener getTranslateListener() {
        return this.translateListener;
    }

    public ZoomListener getZoomListener() {
        return this.zoomListener;
    }

    public class ZoomListener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener {
        private Point p = null;

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.p == null) {
                this.p = e.getPoint();
                return;
            }
            int onmask = ViewManipulator.this.bindings.getViewManipulationBindings();
            if ((e.getModifiersEx() & onmask) == ViewManipulator.this.bindings.getZoomBinding() || e.getSource() == ViewManipulator.this.zoom) {
                double moved = (double)e.getY() - this.p.getY();
                this.p = e.getPoint();
                if (ViewManipulator.this.isAbsolute()) {
                    ViewManipulator.this.view.zoomWorldView(moved);
                } else {
                    ((PerspectiveView)ViewManipulator.this.view).zoomLocalView(moved);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.p = null;
        }
    }

    public class TranslateListener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener {
        private Point p = null;

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.p == null) {
                this.p = e.getPoint();
                return;
            }
            int onmask = ViewManipulator.this.bindings.getViewManipulationBindings();
            if ((e.getModifiersEx() & onmask) == ViewManipulator.this.bindings.getTranslationBinding() || e.getSource() == ViewManipulator.this.translate && (e.getModifiersEx() & 0x400) == 1024) {
                double left = (double)e.getX() - this.p.getX();
                double up = (double)e.getY() - this.p.getY();
                this.p = e.getPoint();
                if (ViewManipulator.this.isAbsolute()) {
                    ViewManipulator.this.view.translateWorldView(left, -up);
                } else {
                    ((PerspectiveView)ViewManipulator.this.view).translateLocalView(left, -up);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.p = null;
        }
    }

    public class RotateListener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener {
        private Point p = null;

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            double left;
            if (this.p == null) {
                this.p = e.getPoint();
                return;
            }
            PerspectiveView v = (PerspectiveView)ViewManipulator.this.view;
            int onmask = ViewManipulator.this.bindings.getViewManipulationBindings();
            if ((e.getModifiersEx() & onmask) == ViewManipulator.this.bindings.getRotateXBinding() && e.getSource() != ViewManipulator.this.rotate || e.getSource() == ViewManipulator.this.rotate) {
                double up = (double)e.getY() - this.p.getY();
                if (ViewManipulator.this.isAbsolute()) {
                    v.rotateWorldViewX(up * ViewManipulator.this.rotationSensitivity);
                } else {
                    v.rotateLocalViewX(up * ViewManipulator.this.rotationSensitivity);
                }
            }
            if ((e.getModifiersEx() & onmask) == ViewManipulator.this.bindings.getRotateYBinding() && e.getSource() != ViewManipulator.this.rotate || e.getSource() == ViewManipulator.this.rotate) {
                left = (double)e.getX() - this.p.getX();
                if (ViewManipulator.this.isAbsolute()) {
                    v.rotateWorldViewY(-left * ViewManipulator.this.rotationSensitivity);
                } else {
                    v.rotateLocalViewY(-left * ViewManipulator.this.rotationSensitivity);
                }
            }
            if ((e.getModifiersEx() & onmask) == ViewManipulator.this.bindings.getRotateZBinding() && e.getSource() != ViewManipulator.this.rotate || e.getSource() == ViewManipulator.this.rotate && e.getButton() == 2) {
                left = (double)e.getY() - this.p.getY();
                if (ViewManipulator.this.isAbsolute()) {
                    v.rotateWorldViewZ(left * ViewManipulator.this.rotationSensitivity);
                } else {
                    v.rotateLocalViewZ(left * ViewManipulator.this.rotationSensitivity);
                }
            }
            this.p = e.getPoint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.p = null;
        }
    }
}

