/*
 * Decompiled with CFR 0.152.
 */
package viewer.deprecated;

import java.awt.Color;
import javax.media.opengl.GL;
import rnadesign.rnacontrol.LinkController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.KissingLoop3D;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.BoundingVolume;
import tools3d.Vector3D;
import tools3d.Vector4D;
import tools3d.objects3d.Link;
import tools3d.objects3d.Object3D;
import viewer.deprecated.RNAModelRenderer;
import viewer.graphics.Material;
import viewer.graphics.RenderableModel;

public abstract class AbstractRNAModelRenderer
implements RNAModelRenderer,
RenderableModel {
    private Object3DGraphController controller;
    private boolean wireframeMode = false;

    @Override
    public void setWireframeMode(boolean wireframeMode) {
        this.wireframeMode = wireframeMode;
    }

    public boolean isWireframeMode() {
        return this.wireframeMode;
    }

    public AbstractRNAModelRenderer(Object3DGraphController controller) {
        this.controller = controller;
    }

    public AbstractRNAModelRenderer() {
        this(null);
    }

    @Override
    public void setController(Object3DGraphController controller) {
        this.controller = controller;
    }

    @Override
    public Object3DGraphController getController() {
        return this.controller;
    }

    @Override
    public boolean getRenderAtom() {
        return false;
    }

    @Override
    public boolean getRenderBranchDescriptor() {
        return false;
    }

    @Override
    public boolean getRenderKissingLoop() {
        return false;
    }

    @Override
    public boolean getRenderLinks() {
        return false;
    }

    @Override
    public boolean getRenderNucleotide() {
        return false;
    }

    @Override
    public boolean getRenderRNAStem() {
        return false;
    }

    @Override
    public boolean getRenderStrand() {
        return false;
    }

    @Override
    public boolean getRenderStrandJunction() {
        return false;
    }

    @Override
    public boolean getRenderOther() {
        return false;
    }

    @Override
    public void renderOther(Object3D o, GL gl) {
    }

    @Override
    public void renderAtom(Atom3D atom, GL gl) {
    }

    @Override
    public void renderBranchDescriptor(BranchDescriptor3D bd, GL gl) {
    }

    @Override
    public void renderKissingLoop(KissingLoop3D kl, GL gl) {
    }

    @Override
    public void renderLink(Link link, GL gl) {
    }

    @Override
    public void renderNucleotide(Nucleotide3D n, GL gl) {
    }

    @Override
    public void renderRNAStem(RnaStem3D stem, GL gl) {
    }

    @Override
    public void renderRnaStrand(RnaStrand strand, GL gl) {
    }

    @Override
    public void renderStrandJunction(StrandJunction3D sj, GL gl) {
    }

    @Override
    public void renderSelected(Object3D o, GL gl) {
        Material material = new Material();
        Color c = Color.yellow;
        material.setEmissive((double)c.getRed() / 255.0, (double)c.getGreen() / 255.0, (double)c.getBlue() / 255.0, 1.0);
        gl.glMaterialfv(1028, 4608, material.getAmbient().buffer());
        gl.glMaterialfv(1028, 4609, material.getDiffuse().buffer());
        gl.glMaterialfv(1028, 4610, material.getSpecular().buffer());
        gl.glMaterialfv(1028, 5632, material.getEmissive().buffer());
        gl.glMaterialf(1028, 5633, (float)material.getHighlight());
        BoundingVolume v = o.getBoundingVolume();
        Vector4D[][] faces = v.getFaces();
        gl.glPushMatrix();
        Vector3D p = o.getPosition();
        gl.glTranslated(p.getX(), p.getY(), p.getZ());
        gl.glBegin(1);
        for (int i = 0; i < faces.length; ++i) {
            for (int j = 0; j < faces[i].length; ++j) {
                Vector4D vec = faces[i][j];
                gl.glVertex3d(vec.getX(), vec.getY(), vec.getZ());
                vec = faces[i][(j + 1) % faces[i].length];
                gl.glVertex3d(vec.getX(), vec.getY(), vec.getZ());
            }
        }
        gl.glEnd();
        gl.glPopMatrix();
    }

    @Override
    public void render(GL gl) {
        this.render(gl, this.controller.getGraph().getGraph());
        if (this.getRenderLinks()) {
            LinkController links = this.controller.getLinks();
            for (int i = 0; i < links.size(); ++i) {
                Link link = links.get(i);
                this.renderLink(link, gl);
            }
        }
    }

    protected void render(GL gl, Object3D o) {
        if (this.getRenderNucleotide() && o instanceof Nucleotide3D) {
            this.renderNucleotide((Nucleotide3D)o, gl);
        } else if (this.getRenderAtom() && o instanceof Atom3D) {
            this.renderAtom((Atom3D)o, gl);
        } else if (this.getRenderStrand() && o instanceof RnaStrand) {
            this.renderRnaStrand((RnaStrand)o, gl);
        } else if (this.getRenderRNAStem() && o instanceof RnaStem3D) {
            this.renderRNAStem((RnaStem3D)o, gl);
        } else if (this.getRenderBranchDescriptor() && o instanceof BranchDescriptor3D) {
            this.renderBranchDescriptor((BranchDescriptor3D)o, gl);
        } else if (this.getRenderStrandJunction() && o instanceof StrandJunction3D) {
            this.renderStrandJunction((StrandJunction3D)o, gl);
        } else if (this.getRenderKissingLoop() && o instanceof KissingLoop3D) {
            this.renderKissingLoop((KissingLoop3D)o, gl);
        } else if (this.getRenderOther()) {
            this.renderOther(o, gl);
        }
        if (o.isSelected()) {
            this.renderSelected(o, gl);
        }
        if (o.size() == 0) {
            return;
        }
        for (int i = 0; i < o.size(); ++i) {
            this.render(gl, o.getChild(i));
        }
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

