/*
 * Decompiled with CFR 0.152.
 */
package viewer.deprecated;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import tools3d.Vector4D;
import viewer.graphics.OldMesh;
import viewer.util.Tools;

public class Cylinder
implements OldMesh {
    private Vector4D e1;
    private Vector4D e2;
    private Vector4D norm;
    private Color wireframeColor = Color.blue;
    private Color solidColor = Color.white;
    private boolean renderWireframe = false;
    private boolean renderSolid = true;
    private int crossSections = 1;
    private int thetaIncrements = 12;

    public Cylinder(double radius, Vector4D e1, Vector4D e2) {
        this.e1 = e1;
        this.e2 = e2;
        Vector4D v = e1.minus(e2);
        Vector4D u = Tools.orthogonal(v);
        u.setX(v.getX() + 1.0);
        double value = Tools.project(u, v);
        Vector4D uv = v.mul(value);
        this.norm = u.minus(uv);
        this.norm.normalize();
        this.norm = this.norm.mul(radius);
    }

    public Cylinder(double radius, Vector4D e1, Vector4D e2, int crossSections, int thetaIncrements) {
        this(radius, e1, e2);
        this.crossSections = crossSections;
        this.thetaIncrements = thetaIncrements;
    }

    @Override
    public OldMesh.Line[] getLines() {
        ArrayList<OldMesh.Line> lines = new ArrayList<OldMesh.Line>();
        this.compute(null, lines);
        OldMesh.Line[] l = new OldMesh.Line[lines.size()];
        lines.toArray(l);
        return l;
    }

    @Override
    public OldMesh.Quad[] getQuads() {
        ArrayList<OldMesh.Quad> quads = new ArrayList<OldMesh.Quad>();
        this.compute(quads, null);
        OldMesh.Quad[] q = new OldMesh.Quad[quads.size()];
        quads.toArray(q);
        return q;
    }

    private void compute(List<OldMesh.Quad> quads, List<OldMesh.Line> lines) {
        int i;
        OldMesh.Line l4;
        OldMesh.Line l3;
        OldMesh.Line l2;
        Vector4D v = this.e1.minus(this.e2);
        double length = v.length();
        double lengthIncrement = length / (double)this.crossSections;
        v.normalize();
        double thetaInc = Math.PI * 2 / (double)this.thetaIncrements;
        Vector4D norm = new Vector4D(this.norm);
        for (int i2 = 0; i2 < this.thetaIncrements; ++i2) {
            OldMesh.Quad q = new OldMesh.Quad();
            q.v1 = new Vector4D(this.e2);
            Vector4D n = v.mul(-1.0);
            n.normalize();
            q.v1n = n;
            q.v2n = n;
            q.v3n = n;
            q.v4n = n;
            q.v2 = new Vector4D(this.e2);
            q.v2.add(norm);
            norm = Tools.rotate(norm, v, -thetaInc);
            q.v3 = new Vector4D(this.e2);
            q.v3.add(norm);
            q.v4 = new Vector4D(this.e2);
            if (quads != null) {
                quads.add(q);
            }
            if (lines == null) continue;
            OldMesh.Line l1 = new OldMesh.Line();
            l2 = new OldMesh.Line();
            l3 = new OldMesh.Line();
            l4 = new OldMesh.Line();
            l1.v1 = q.v1;
            l1.v2 = q.v2;
            l2.v1 = q.v2;
            l2.v2 = q.v3;
            l3.v1 = q.v3;
            l3.v2 = q.v4;
            l4.v1 = q.v4;
            l4.v2 = q.v1;
            lines.add(l1);
            lines.add(l2);
            lines.add(l3);
            lines.add(l4);
        }
        Vector4D lengthVector = v.mul(lengthIncrement);
        for (i = 0; i < this.thetaIncrements; ++i) {
            Vector4D normLocation = new Vector4D(this.e2);
            for (int j = 0; j < this.crossSections; ++j) {
                OldMesh.Quad q = new OldMesh.Quad();
                Vector4D v1 = new Vector4D(normLocation);
                v1.add(norm);
                q.v1 = v1;
                q.v1n = new Vector4D(norm);
                q.v1n.normalize();
                normLocation.add(lengthVector);
                Vector4D v2 = new Vector4D(normLocation);
                v2.add(norm);
                q.v2 = v2;
                q.v2n = new Vector4D(norm);
                q.v2n.normalize();
                norm = Tools.rotate(norm, v, -thetaInc);
                Vector4D v3 = new Vector4D(normLocation);
                v3.add(norm);
                q.v3 = v3;
                q.v3n = new Vector4D(norm);
                q.v3n.normalize();
                normLocation = normLocation.minus(lengthVector);
                Vector4D v4 = new Vector4D(normLocation);
                v4.add(norm);
                q.v4 = v4;
                q.v4n = new Vector4D(norm);
                q.v4n.normalize();
                if (quads != null) {
                    quads.add(q);
                }
                if (lines != null) {
                    OldMesh.Line l1 = new OldMesh.Line();
                    OldMesh.Line l22 = new OldMesh.Line();
                    OldMesh.Line l32 = new OldMesh.Line();
                    OldMesh.Line l42 = new OldMesh.Line();
                    l1.v1 = q.v1;
                    l1.v2 = q.v2;
                    l22.v1 = q.v2;
                    l22.v2 = q.v3;
                    l32.v1 = q.v3;
                    l32.v2 = q.v4;
                    l42.v1 = q.v4;
                    l42.v2 = q.v1;
                    lines.add(l1);
                    lines.add(l22);
                    lines.add(l32);
                    lines.add(l42);
                }
                normLocation.add(lengthVector);
            }
        }
        for (i = 0; i < this.thetaIncrements; ++i) {
            OldMesh.Quad q = new OldMesh.Quad();
            q.v1 = new Vector4D(this.e1);
            q.v1n = v;
            q.v2n = v;
            q.v3n = v;
            q.v4n = v;
            q.v2 = new Vector4D(this.e1);
            q.v2.add(norm);
            norm = Tools.rotate(norm, v, thetaInc);
            q.v3 = new Vector4D(this.e1);
            q.v3.add(norm);
            q.v4 = new Vector4D(this.e1);
            if (quads != null) {
                quads.add(q);
            }
            if (lines == null) continue;
            OldMesh.Line l1 = new OldMesh.Line();
            l2 = new OldMesh.Line();
            l3 = new OldMesh.Line();
            l4 = new OldMesh.Line();
            l1.v1 = q.v1;
            l1.v2 = q.v2;
            l2.v1 = q.v2;
            l2.v2 = q.v3;
            l3.v1 = q.v3;
            l3.v2 = q.v4;
            l4.v1 = q.v4;
            l4.v2 = q.v1;
            lines.add(l1);
            lines.add(l2);
            lines.add(l3);
            lines.add(l4);
        }
    }

    @Override
    public Color getSolidColor() {
        return this.solidColor;
    }

    @Override
    public Color getWireframeColor() {
        return this.wireframeColor;
    }

    @Override
    public void refine() {
        this.thetaIncrements *= 2;
        this.crossSections *= 2;
    }

    @Override
    public boolean renderSolid() {
        return this.renderSolid;
    }

    @Override
    public boolean renderWireframe() {
        return this.renderWireframe;
    }
}

