/*
 * Decompiled with CFR 0.152.
 */
package viewer.display;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import viewer.display.DisplayLayoutRequest;
import viewer.view.ViewOrientation;

public class DisplayGridLayout
implements DisplayLayoutRequest {
    private Dimension displaySize;
    private ArrayList<Rectangle> viewBounds = new ArrayList();
    private ViewOrientation[] orientations;

    public DisplayGridLayout(int[][] grid, ViewOrientation[] orientations, Dimension displaySize) {
        this.orientations = orientations;
        this.displaySize = displaySize;
        this.createViewsFromGrid(grid);
        if (this.viewBounds.size() > orientations.length) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String getDescription() {
        return "Grid Layout";
    }

    @Override
    public Dimension getDisplaySize() {
        return this.displaySize;
    }

    @Override
    public int getNumberViews() {
        return this.viewBounds.size();
    }

    @Override
    public Rectangle getViewBounds(int view) {
        return this.viewBounds.get(view);
    }

    @Override
    public ViewOrientation getViewOrientation(int view) {
        return this.orientations[view];
    }

    private void createViewsFromGrid(int[][] grid) {
        boolean[][] seen = new boolean[grid.length][];
        for (int i = 0; i < grid.length; ++i) {
            seen[i] = new boolean[grid[i].length];
        }
        int x1 = 0;
        int y1 = 0;
        double xDivision = this.displaySize.width / grid[0].length;
        double yDivision = this.displaySize.height / grid.length;
        for (int i = 0; i < seen.length; ++i) {
            y1 = (int)(yDivision * (double)i);
            for (int j = 0; j < seen[i].length; ++j) {
                int l;
                int k;
                x1 = (int)(xDivision * (double)j);
                if (seen[i][j]) continue;
                int view = grid[i][j];
                for (k = i + 1; k < grid.length && grid[k][j] == view; ++k) {
                }
                for (l = j + 1; l < grid[i].length && grid[i][l] == view; ++l) {
                }
                int height = (int)((double)k * yDivision) - y1;
                int width = (int)((double)l * xDivision) - x1;
                this.viewBounds.add(new Rectangle(x1, y1, width, height));
                for (int m = i; m < k; ++m) {
                    for (int n = j; n < l; ++n) {
                        seen[m][n] = true;
                    }
                }
            }
        }
    }
}

