/*
 * Decompiled with CFR 0.152.
 */
package viewer.event;

import tools3d.Vector4D;

public class ViewEvent {
    public static final int LOCAL_MOVEMENT = 0;
    public static final int WORLD_MOVEMENT = 1;
    public static final int POINT_MOVEMENT = 2;
    public static final int ROTATION = 0;
    public static final int TRANSLATION = 1;
    public static final int ZOOM = 2;
    private int movementRelation;
    private int movementType;
    private Vector4D oldPosition;
    private Vector4D newPosition;
    private double oldZoom;
    private double newZoom;
    private Vector4D oldRotation;
    private Vector4D newRotation;
    private Vector4D oldNormal;
    private Vector4D newNormal;

    public ViewEvent() {
    }

    public ViewEvent(int movementType, int movementRelation) {
        this.movementRelation = movementRelation;
        this.movementType = movementType;
    }

    public ViewEvent(int movementType, int movementRelation, Vector4D v1, Vector4D v2) {
        this(movementType, movementRelation);
        if (movementType == 1) {
            this.oldPosition = v1;
            this.newPosition = v2;
        } else {
            this.oldRotation = v1;
            this.newRotation = v2;
        }
    }

    public ViewEvent(int movementType, int movementRelation, Vector4D oldDirection, Vector4D newDirection, Vector4D oldNormal, Vector4D newNormal) {
        this(movementType, movementRelation, oldDirection, newDirection);
        this.oldNormal = oldNormal;
        this.newNormal = newNormal;
    }

    public ViewEvent(int movementType, int movementRelation, double oldZoom, double newZoom) {
        this(movementType, movementRelation);
        this.oldZoom = oldZoom;
        this.newZoom = newZoom;
    }

    public Vector4D getOldNormal() {
        return this.oldNormal;
    }

    public Vector4D getNewNormal() {
        return this.newNormal;
    }

    public Vector4D getNewPosition() {
        return this.newPosition;
    }

    public Vector4D getNewRotation() {
        return this.newRotation;
    }

    public double getNewZoom() {
        return this.newZoom;
    }

    public Vector4D getOldPosition() {
        return this.oldPosition;
    }

    public Vector4D getOldRotation() {
        return this.oldRotation;
    }

    public double getOldZoom() {
        return this.oldZoom;
    }

    public int getMovementRelation() {
        return this.movementRelation;
    }

    public int getMovementType() {
        return this.movementType;
    }
}

