/*
 * Decompiled with CFR 0.152.
 */
package viewer.graphics;

import java.util.List;
import tools3d.Vector4D;
import viewer.graphics.Mesh;

public class DefaultMesh
implements Mesh {
    private List<Vector4D> vertices;
    private List<Vector4D> normals;
    private List<int[]> polygons;
    private int sideCount;

    public DefaultMesh(List<Vector4D> vertices, List<Vector4D> normals, List<int[]> polygons, int sideCount) {
        this.vertices = vertices;
        this.normals = normals;
        this.polygons = polygons;
        this.sideCount = sideCount;
    }

    @Override
    public Vector4D getNormal(int index) {
        return this.normals.get(index);
    }

    @Override
    public Vector4D[] getNormals() {
        Vector4D[] array = new Vector4D[this.normals.size()];
        this.normals.toArray(array);
        return array;
    }

    @Override
    public int[] getGeometryElement(int index) {
        return this.polygons.get(index);
    }

    @Override
    public int getGeometryElementCount() {
        return this.polygons.size();
    }

    @Override
    public int[][] getGeometryElements() {
        int[][] array = new int[this.polygons.size()][];
        this.polygons.toArray((T[])array);
        return array;
    }

    @Override
    public int getPolygonSideCount() {
        return this.sideCount;
    }

    @Override
    public Vector4D getVertex(int index) {
        return this.vertices.get(index);
    }

    @Override
    public int getVertexCount() {
        return this.vertices.size();
    }

    @Override
    public Vector4D[] getVertices() {
        Vector4D[] array = new Vector4D[this.vertices.size()];
        this.vertices.toArray(array);
        return array;
    }
}

