/*
 * Decompiled with CFR 0.152.
 */
package viewer.graphics;

import java.awt.Color;
import javax.media.opengl.GL;
import viewer.graphics.ColorVector;

public class Material
implements Cloneable {
    private ColorVector ambient;
    private ColorVector diffuse;
    private ColorVector emissive;
    private ColorVector specular;
    private double highlight;

    public Material(double ambientR, double ambientG, double ambientB, double ambientI, double diffuseR, double diffuseG, double diffuseB, double diffuseI, double specularR, double specularG, double specularB, double specularI, double emissiveR, double emissiveG, double emissiveB, double emissiveI, double highlight) {
        this.ambient = new ColorVector(ambientR, ambientG, ambientB, ambientI);
        this.diffuse = new ColorVector(diffuseR, diffuseG, diffuseB, diffuseI);
        this.emissive = new ColorVector(emissiveR, emissiveG, emissiveB, emissiveI);
        this.specular = new ColorVector(specularR, specularG, specularB, specularI);
        this.highlight = highlight;
    }

    public Material(Color color) {
        this(color, false);
    }

    public Material(Color color, boolean matte) {
        double red = (double)color.getRed() / 255.0;
        double blue = (double)color.getBlue() / 255.0;
        double green = (double)color.getGreen() / 255.0;
        this.setAmbient(red, green, blue, 1.0);
        this.setDiffuse(red * 0.8, green * 0.8, blue * 0.8, 1.0);
        this.setSpecular(red * 0.2, green * 0.2, blue * 0.2, 1.0);
        if (!matte) {
            this.setEmissive(0.0, 0.0, 0.0, 0.0);
        } else {
            this.setEmissive(red, green, blue, 0.0);
        }
        this.setHighlight(10.0);
    }

    public Material() {
        this(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    public ColorVector getAmbient() {
        return new ColorVector(this.ambient);
    }

    public ColorVector getDiffuse() {
        return new ColorVector(this.diffuse);
    }

    public ColorVector getEmissive() {
        return new ColorVector(this.emissive);
    }

    public ColorVector getSpecular() {
        return new ColorVector(this.specular);
    }

    public double getHighlight() {
        return this.highlight;
    }

    public void setAmbient(double r, double g, double b, double i) {
        this.ambient = new ColorVector(r, g, b, i);
    }

    public void setDiffuse(double r, double g, double b, double i) {
        this.diffuse = new ColorVector(r, g, b, i);
    }

    public void setEmissive(double r, double g, double b, double i) {
        this.emissive = new ColorVector(r, g, b, i);
    }

    public void setSpecular(double r, double g, double b, double i) {
        this.specular = new ColorVector(r, g, b, i);
    }

    public void setAmbient(ColorVector ambient) {
        this.ambient = new ColorVector(ambient);
    }

    public void setDiffuse(ColorVector diffuse) {
        this.diffuse = new ColorVector(diffuse);
    }

    public void setEmissive(ColorVector emissive) {
        this.emissive = new ColorVector(emissive);
    }

    public void setSpecular(ColorVector specular) {
        this.specular = new ColorVector(specular);
    }

    public void setHighlight(double highlight) {
        this.highlight = highlight;
    }

    public static void renderMaterial(GL gl, Material material) {
        gl.glMaterialfv(1028, 4608, material.getAmbient().buffer());
        gl.glMaterialfv(1028, 4609, material.getDiffuse().buffer());
        gl.glMaterialfv(1028, 4610, material.getSpecular().buffer());
        gl.glMaterialfv(1028, 5632, material.getEmissive().buffer());
        gl.glMaterialf(1028, 5633, (float)material.getHighlight());
    }

    public Object clone() {
        Material material = null;
        try {
            material = (Material)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        material.ambient = (ColorVector)this.ambient.clone();
        material.diffuse = (ColorVector)this.diffuse.clone();
        material.emissive = (ColorVector)this.emissive.clone();
        material.specular = (ColorVector)this.specular.clone();
        return material;
    }
}

