/*
 * Decompiled with CFR 0.152.
 */
package viewer.graphics;

import java.util.ArrayList;
import java.util.List;
import tools3d.Vector4D;
import viewer.graphics.DefaultMesh;
import viewer.graphics.Mesh;
import viewer.util.Tools;

public class PrimitiveFactory {
    public static final Mesh UNIT_SPHERE = PrimitiveFactory.generateSphere(1.0, 4, 4);
    public static final Mesh UNIT_BOX = null;
    public static final Mesh UNIT_CYLINDER = PrimitiveFactory.generateCylinder(new Vector4D(1.0, 0.0, 0.0, 0.0), 1.0, 2.0, 1, 8);

    public static Mesh generateSphere(double radius, int subdivisionsU, int subdivisionsV) {
        int j;
        int i;
        final ArrayList<Vector4D> vertices = new ArrayList<Vector4D>();
        final ArrayList<Vector4D> normals = new ArrayList<Vector4D>();
        final ArrayList<int[]> triangles = new ArrayList<int[]>();
        Vector4D v = new Vector4D(0.0, -radius, 0.0, 0.0);
        Vector4D vN = new Vector4D(0.0, 0.0, -1.0, 0.0);
        Vector4D y = new Vector4D(0.0, -1.0, 0.0, 0.0);
        double thetaIncrement = Math.PI * 2 / (double)subdivisionsU;
        double phiIncrement = Math.PI / (double)subdivisionsV;
        int thetaIncrementCount = 0;
        vertices.add(new Vector4D(v));
        Vector4D n = new Vector4D(v);
        n.normalize();
        normals.add(n);
        for (int phiIncrementCount = 1; phiIncrementCount < subdivisionsV; ++phiIncrementCount) {
            Vector4D vX = v.cross(vN);
            vX.normalize();
            v = Tools.rotate(v, vX, phiIncrement);
            vN = Tools.rotate(vN, vX, phiIncrement);
            v = Tools.rotate(v, y, thetaIncrement / 2.0);
            vN = Tools.rotate(vN, y, thetaIncrement / 2.0);
            while (thetaIncrementCount < subdivisionsU) {
                vertices.add(new Vector4D(v));
                n = new Vector4D(v);
                n.normalize();
                normals.add(n);
                v = Tools.rotate(v, y, thetaIncrement);
                vN = Tools.rotate(vN, y, thetaIncrement);
                ++thetaIncrementCount;
            }
            thetaIncrementCount = 0;
        }
        v = new Vector4D(0.0, radius, 0.0, 0.0);
        vertices.add(new Vector4D(v));
        v.normalize();
        normals.add(v);
        for (int i2 = 0; i2 < subdivisionsU - 1; ++i2) {
            int[] triangle = new int[]{0, i2 + 1, i2 + 2};
            triangles.add(triangle);
        }
        int[] extraBottom = new int[]{0, subdivisionsU, 1};
        triangles.add(extraBottom);
        for (i = 0; i < subdivisionsV - 2; ++i) {
            for (j = 0; j < subdivisionsU; ++j) {
                triangles.add(PrimitiveFactory.findClosestPoints(vertices, 1 + j + i * subdivisionsU, (i + 1) * subdivisionsU + 1, subdivisionsU, false));
            }
        }
        for (i = 1; i < subdivisionsV - 1; ++i) {
            for (j = 0; j < subdivisionsU; ++j) {
                triangles.add(PrimitiveFactory.findClosestPoints(vertices, 1 + j + i * subdivisionsU, (i - 1) * subdivisionsU + 1, subdivisionsU, true));
            }
        }
        i = vertices.size() - subdivisionsU - 1;
        while (i < vertices.size() - 1) {
            int[] triangle = new int[]{vertices.size() - 1, i + 1, i++};
            triangles.add(triangle);
        }
        int[] extraTop = new int[]{vertices.size() - 1, vertices.size() - subdivisionsU - 1, vertices.size() - 2};
        triangles.add(extraTop);
        return new Mesh(){

            @Override
            public Vector4D getNormal(int index) {
                return (Vector4D)normals.get(index);
            }

            @Override
            public Vector4D[] getNormals() {
                Vector4D[] array = new Vector4D[normals.size()];
                normals.toArray(array);
                return array;
            }

            @Override
            public int[] getGeometryElement(int index) {
                return (int[])triangles.get(index);
            }

            @Override
            public int getGeometryElementCount() {
                return triangles.size();
            }

            @Override
            public int[][] getGeometryElements() {
                int[][] array = new int[triangles.size()][];
                triangles.toArray((T[])array);
                return array;
            }

            @Override
            public Vector4D getVertex(int index) {
                return (Vector4D)vertices.get(index);
            }

            @Override
            public int getVertexCount() {
                return vertices.size();
            }

            @Override
            public Vector4D[] getVertices() {
                Vector4D[] array = new Vector4D[vertices.size()];
                vertices.toArray(array);
                return array;
            }

            @Override
            public int getPolygonSideCount() {
                return 3;
            }
        };
    }

    private static int[] findClosestPoints(List<Vector4D> vertices, int point, int offset, int length, boolean rotate) {
        int index1 = -1;
        int index2 = -1;
        double smallestDistance = Double.MAX_VALUE;
        Vector4D v = vertices.get(point);
        for (int i = 0; i < length; ++i) {
            int i1 = offset + i;
            int i2 = offset + (i + 1) % length;
            Vector4D p1 = vertices.get(i1);
            Vector4D p2 = vertices.get(i2);
            double distance = v.distance(p1) + v.distance(p2);
            if (!(distance < smallestDistance)) continue;
            index1 = i1;
            index2 = i2;
            smallestDistance = distance;
        }
        int[] ret = new int[3];
        ret[0] = point;
        if (rotate) {
            ret[1] = index2;
            ret[2] = index1;
        } else {
            ret[1] = index1;
            ret[2] = index2;
        }
        return ret;
    }

    public static Mesh generateCylinder(Vector4D axis, double radius, double length, int subdivisionsU, int subdivisionsV) {
        double xx;
        final ArrayList<Vector4D> vertices = new ArrayList<Vector4D>();
        final ArrayList<Vector4D> normals = new ArrayList<Vector4D>();
        final ArrayList<int[]> polygons = new ArrayList<int[]>();
        Vector4D normal = new Vector4D(axis);
        double x = Math.abs(normal.getX());
        double y = Math.abs(normal.getY());
        double z = Math.abs(normal.getZ());
        if (x < y && x < z) {
            normal.setX(0.0);
            double yy = normal.getY();
            normal.setY(-1.0 * normal.getZ());
            normal.setZ(yy);
        } else if (y < x && y < z) {
            normal.setY(0.0);
            xx = normal.getX();
            normal.setX(-1.0 * normal.getZ());
            normal.setZ(xx);
        } else {
            normal.setZ(0.0);
            xx = normal.getX();
            normal.setX(-1.0 * normal.getY());
            normal.setY(xx);
        }
        normal.normalize();
        normal = normal.mul(radius);
        normal.setW(0.0);
        Vector4D increment = axis.mul(length / (double)subdivisionsU);
        Vector4D start = axis.mul(length / 2.0);
        double thetaIncrement = Math.PI * 2 / (double)subdivisionsV;
        for (double uCounter = 0.0; uCounter < (double)(subdivisionsU + 1); uCounter += 1.0) {
            for (double vCounter = 0.0; vCounter < (double)subdivisionsV; vCounter += 1.0) {
                vertices.add(start.plus(normal));
                Vector4D n = new Vector4D(normal);
                n.normalize();
                normals.add(n);
                normal = Tools.rotate(normal, axis, thetaIncrement);
            }
            start.sub(increment);
        }
        for (int i = 0; i < subdivisionsU; ++i) {
            for (int j = 0; j < subdivisionsV; ++j) {
                int[] tri1 = new int[]{i * subdivisionsV + j, (i + 1) * subdivisionsV + j, (i + 1) * subdivisionsV + (j + 1) % subdivisionsV};
                int[] tri2 = new int[]{i * subdivisionsV + j, (i + 1) * subdivisionsV + (j + 1) % subdivisionsV, i * subdivisionsV + (j + 1) % subdivisionsV};
                polygons.add(tri1);
                polygons.add(tri2);
            }
        }
        Vector4D startEnd = axis.mul(length / 2.0);
        vertices.add(startEnd);
        normals.add(new Vector4D(axis));
        Vector4D endEnd = startEnd.mul(-1.0);
        vertices.add(endEnd);
        normals.add(new Vector4D(axis.mul(-1.0)));
        for (int i = 0; i < subdivisionsV; ++i) {
            int[] quad1 = new int[]{vertices.size() - 2, vertices.size() - 2, i, (i + 1) % subdivisionsV};
            int[] tri1a = new int[]{vertices.size() - 2, vertices.size() - 2, i};
            int[] tri1b = new int[]{vertices.size() - 2, i, (i + 1) % subdivisionsV};
            int[] quad2 = new int[]{vertices.size() - 1, vertices.size() - 1, subdivisionsU * subdivisionsV + (i + 1) % subdivisionsV, subdivisionsU * subdivisionsV + i};
            int[] tri2a = new int[]{vertices.size() - 1, vertices.size() - 1, subdivisionsU * subdivisionsV + (i + 1) % subdivisionsV};
            int[] tri2b = new int[]{vertices.size() - 1, subdivisionsU * subdivisionsV + (i + 1) % subdivisionsV, subdivisionsU * subdivisionsV + i};
            polygons.add(tri1a);
            polygons.add(tri1b);
            polygons.add(tri2a);
            polygons.add(tri2b);
        }
        return new Mesh(){

            @Override
            public Vector4D getNormal(int index) {
                return (Vector4D)normals.get(index);
            }

            @Override
            public Vector4D[] getNormals() {
                Vector4D[] array = new Vector4D[normals.size()];
                normals.toArray(array);
                return array;
            }

            @Override
            public int[] getGeometryElement(int index) {
                return (int[])polygons.get(index);
            }

            @Override
            public int getGeometryElementCount() {
                return polygons.size();
            }

            @Override
            public int[][] getGeometryElements() {
                int[][] array = new int[polygons.size()][];
                polygons.toArray((T[])array);
                return array;
            }

            @Override
            public int getPolygonSideCount() {
                return 3;
            }

            @Override
            public Vector4D getVertex(int index) {
                return (Vector4D)vertices.get(index);
            }

            @Override
            public int getVertexCount() {
                return vertices.size();
            }

            @Override
            public Vector4D[] getVertices() {
                Vector4D[] array = new Vector4D[vertices.size()];
                vertices.toArray(array);
                return array;
            }
        };
    }

    public static Mesh generateCapsule(double radius, double length, int subdivisionsU, int subdivisionsV) {
        return null;
    }

    public static Mesh generateSheet(final Vector4D normal, double uLength, double vLength, int subdivisionsU, int subdivisionsV) {
        int vCounter;
        int uCounter;
        final ArrayList<Vector4D> vertices = new ArrayList<Vector4D>();
        final ArrayList<int[]> polygons = new ArrayList<int[]>();
        normal.normalize();
        Vector4D u = Tools.orthogonal(normal);
        Vector4D v = normal.cross(u);
        u.normalize();
        v.normalize();
        double uIncrement = uLength / (double)subdivisionsU;
        double vIncrement = vLength / (double)subdivisionsV;
        Vector4D start = u.mul(uLength / 2.0 * -1.0).plus(v.mul(vLength / 2.0 * -1.0));
        for (uCounter = 0; uCounter < subdivisionsU + 1; ++uCounter) {
            Vector4D uu = u.mul((double)uCounter * uIncrement);
            for (vCounter = 0; vCounter < subdivisionsV + 1; ++vCounter) {
                Vector4D vv = v.mul((double)vCounter * vIncrement);
                Vector4D vertex = start.plus(vv.plus(uu));
                vertices.add(vertex);
            }
        }
        for (uCounter = 0; uCounter < subdivisionsU; ++uCounter) {
            for (vCounter = 0; vCounter < subdivisionsV; ++vCounter) {
                int subV = subdivisionsV + 1;
                int[] array = new int[]{uCounter * subV + vCounter, (uCounter + 1) * subV + vCounter, (uCounter + 1) * subV + vCounter + 1, uCounter * subV + vCounter + 1};
                polygons.add(array);
            }
        }
        return new Mesh(){

            @Override
            public Vector4D getNormal(int index) {
                return normal;
            }

            @Override
            public Vector4D[] getNormals() {
                Vector4D[] normals = new Vector4D[]{normal};
                return normals;
            }

            @Override
            public int[] getGeometryElement(int index) {
                return (int[])polygons.get(index);
            }

            @Override
            public int getGeometryElementCount() {
                return polygons.size();
            }

            @Override
            public int[][] getGeometryElements() {
                int[][] array = new int[polygons.size()][];
                polygons.toArray((T[])array);
                return array;
            }

            @Override
            public int getPolygonSideCount() {
                return 4;
            }

            @Override
            public Vector4D getVertex(int index) {
                return (Vector4D)vertices.get(index);
            }

            @Override
            public int getVertexCount() {
                return vertices.size();
            }

            @Override
            public Vector4D[] getVertices() {
                Vector4D[] array = new Vector4D[vertices.size()];
                vertices.toArray(array);
                return array;
            }
        };
    }

    public static Mesh generateCone(Vector4D axis, double baseRadius, double height, int subdivisionsU) {
        final ArrayList<Vector4D> vertices = new ArrayList<Vector4D>();
        final ArrayList<Vector4D> normals = new ArrayList<Vector4D>();
        final ArrayList<int[]> triangles = new ArrayList<int[]>();
        Vector4D normal = Tools.orthogonal(axis);
        normal.normalize();
        axis.normalize();
        double incs = Math.PI * 2 / (double)subdivisionsU;
        for (int counter = 0; counter < subdivisionsU; ++counter) {
            Vector4D vertex = normal.mul(baseRadius);
            vertices.add(vertex);
            normals.add(normal);
            normal = Tools.rotate(normal, axis, incs);
        }
        vertices.add(new Vector4D(0.0, 0.0, 0.0, 0.0));
        normals.add(axis.mul(-1.0));
        vertices.add(axis.mul(height));
        normals.add(axis);
        int topIndex = normals.size() - 1;
        int bottomIndex = normals.size() - 2;
        for (int i = 0; i < subdivisionsU + 1; ++i) {
            int[] triangle1 = new int[]{(i + 1) % subdivisionsU, topIndex, i};
            int[] triangle2 = new int[]{i, bottomIndex, (i + 1) % subdivisionsU};
            triangles.add(triangle1);
            triangles.add(triangle2);
        }
        return new Mesh(){

            @Override
            public Vector4D getNormal(int index) {
                return (Vector4D)normals.get(index);
            }

            @Override
            public Vector4D[] getNormals() {
                Vector4D[] array = new Vector4D[normals.size()];
                normals.toArray(array);
                return array;
            }

            @Override
            public int[] getGeometryElement(int index) {
                return (int[])triangles.get(index);
            }

            @Override
            public int getGeometryElementCount() {
                return triangles.size();
            }

            @Override
            public int[][] getGeometryElements() {
                int[][] array = new int[triangles.size()][];
                triangles.toArray((T[])array);
                return array;
            }

            @Override
            public int getPolygonSideCount() {
                return 3;
            }

            @Override
            public Vector4D getVertex(int index) {
                return (Vector4D)vertices.get(index);
            }

            @Override
            public int getVertexCount() {
                return vertices.size();
            }

            @Override
            public Vector4D[] getVertices() {
                Vector4D[] array = new Vector4D[vertices.size()];
                vertices.toArray(array);
                return array;
            }
        };
    }

    public static Mesh generateBox(double xLength, double yLength, double zLength) {
        return null;
    }

    public static Mesh generateTorus(double innerRadius, double outerRadius, int subdivisionsU, int subdivisionsV) {
        return null;
    }

    public static Mesh generatePolygon(int sides) {
        ArrayList<Vector4D> vertices = new ArrayList<Vector4D>();
        ArrayList<int[]> triangles = new ArrayList<int[]>();
        Vector4D v = new Vector4D(1.0, 0.0, 0.0, 0.0);
        double angle = Math.PI * 2 / (double)sides;
        for (int i = 0; i < sides; ++i) {
            vertices.add(v);
            v = Tools.rotate(v, Tools.Y_AXIS, angle);
            int[] triangle = new int[]{i, (i + 1) % sides, sides};
            triangles.add(triangle);
        }
        vertices.add(new Vector4D(0.0, 0.0, 0.0, 0.0));
        ArrayList<Vector4D> normals = new ArrayList<Vector4D>();
        for (int i = 0; i < vertices.size(); ++i) {
            normals.add(new Vector4D(0.0, 1.0, 0.0, 0.0));
        }
        return new DefaultMesh(vertices, normals, triangles, 3);
    }
}

