/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.ITestRunnerFactory;
import org.testng.SuiteResult;
import org.testng.SuiteRunState;
import org.testng.TestListenerAdapter;
import org.testng.TestRunner;
import org.testng.internal.IInvoker;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationConfiguration;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.thread.IPooledExecutor;
import org.testng.internal.thread.ThreadUtil;
import org.testng.reporters.JUnitXMLReporter;
import org.testng.reporters.TestHTMLReporter;
import org.testng.reporters.TextReporter;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteRunner
implements ISuite,
Serializable {
    private static final long serialVersionUID = 5284208932089503131L;
    private static final String DEFAULT_OUTPUT_DIR = "test-output";
    private Map<String, ISuiteResult> m_suiteResults = new HashMap<String, ISuiteResult>();
    private List<TestRunner> m_testRunners = new ArrayList<TestRunner>();
    private transient List<ISuiteListener> m_listeners = new ArrayList<ISuiteListener>();
    private transient TestListenerAdapter m_textReporter = new TestListenerAdapter();
    private String m_outputDir;
    private XmlSuite m_suite;
    private transient List<ITestListener> m_testlisteners = new ArrayList<ITestListener>();
    private transient ITestRunnerFactory m_tmpRunnerFactory;
    private transient ITestRunnerFactory m_runnerFactory;
    private transient boolean m_useDefaultListeners = true;
    private String m_host;
    private SuiteRunState m_suiteState = new SuiteRunState();

    public SuiteRunner(XmlSuite suite, String outputDir) {
        this(suite, outputDir, null, false);
    }

    public SuiteRunner(XmlSuite suite, String outputDir, boolean reportResults) {
        this(suite, outputDir, null, reportResults);
    }

    public SuiteRunner(XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory) {
        this(suite, outputDir, runnerFactory, false);
    }

    public SuiteRunner(XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners) {
        this.m_suite = suite;
        this.m_useDefaultListeners = useDefaultListeners;
        this.m_tmpRunnerFactory = runnerFactory;
        this.setOutputDir(outputDir);
    }

    @Override
    public String getName() {
        return this.m_suite.getName();
    }

    public void setTestListeners(List<ITestListener> testlisteners) {
        this.m_testlisteners = testlisteners;
    }

    public void setReportResults(boolean reportResults) {
        this.m_useDefaultListeners = reportResults;
    }

    private void invokeListeners(boolean start) {
        for (ISuiteListener sl : this.m_listeners) {
            if (start) {
                sl.onStart(this);
                continue;
            }
            sl.onFinish(this);
        }
    }

    private void setOutputDir(String outputdir) {
        if ((null == outputdir || "".equals(outputdir.trim())) && this.m_useDefaultListeners) {
            outputdir = DEFAULT_OUTPUT_DIR;
        }
        this.m_outputDir = null != outputdir ? new File(outputdir).getAbsolutePath() : null;
    }

    private void lazyInit() {
        this.m_runnerFactory = this.buildRunnerFactory(this.m_testlisteners);
    }

    protected ITestRunnerFactory buildRunnerFactory(List testListeners) {
        ITestRunnerFactory factory = null;
        factory = null == this.m_tmpRunnerFactory ? new DefaultTestRunnerFactory(this.m_testlisteners.toArray(new ITestListener[this.m_testlisteners.size()]), this.m_useDefaultListeners) : new ProxyTestRunnerFactory(this.m_testlisteners.toArray(new ITestListener[this.m_testlisteners.size()]), this.m_tmpRunnerFactory);
        return factory;
    }

    @Override
    public String getParallel() {
        return this.m_suite.getParallel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.lazyInit();
        this.invokeListeners(true);
        try {
            this.privateRun();
            Object var2_1 = null;
            this.invokeListeners(false);
            if (this.m_suite.getVerbose() <= 0) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.invokeListeners(false);
            if (this.m_suite.getVerbose() <= 0) throw throwable;
            int total = this.m_textReporter.getAllTestMethods().length;
            List<ITestResult> skipped = this.m_textReporter.getSkippedTests();
            List<ITestResult> failed = this.m_textReporter.getFailedTests();
            String totalTestsRun = this.getName() + "\n" + "Total tests run: " + total + ", Failures: " + failed.size() + ", Skips: " + skipped.size() + "\n";
            System.out.println("\n===============================================\n" + totalTestsRun + "===============================================\n");
            throw throwable;
        }
        int total = this.m_textReporter.getAllTestMethods().length;
        List<ITestResult> skipped = this.m_textReporter.getSkippedTests();
        List<ITestResult> failed = this.m_textReporter.getFailedTests();
        String totalTestsRun = this.getName() + "\n" + "Total tests run: " + total + ", Failures: " + failed.size() + ", Skips: " + skipped.size() + "\n";
        System.out.println("\n===============================================\n" + totalTestsRun + "===============================================\n");
    }

    private void privateRun() {
        LinkedHashMap<Method, ITestNGMethod> beforeSuiteMethods = new LinkedHashMap<Method, ITestNGMethod>();
        LinkedHashMap<Method, ITestNGMethod> afterSuiteMethods = new LinkedHashMap<Method, ITestNGMethod>();
        IInvoker invoker = null;
        for (XmlTest test : this.m_suite.getTests()) {
            TestRunner tr = this.m_runnerFactory.newTestRunner(this, test);
            tr.addTestListener(this.m_textReporter);
            this.m_testRunners.add(tr);
            invoker = tr.getInvoker();
            for (ITestNGMethod m : tr.getBeforeSuiteMethods()) {
                beforeSuiteMethods.put(m.getMethod(), m);
            }
            for (ITestNGMethod m : tr.getAfterSuiteMethods()) {
                afterSuiteMethods.put(m.getMethod(), m);
            }
        }
        invoker.invokeConfigurations(null, beforeSuiteMethods.values().toArray(new ITestNGMethod[beforeSuiteMethods.size()]), this.m_suite, this.m_suite.getParameters(), null);
        Utils.log("[SuiteRunner]", 3, "Created " + this.m_testRunners.size() + " TestRunners");
        boolean testsInParallel = "tests".equals(this.m_suite.getParallel());
        if (!testsInParallel) {
            this.runSequentially();
        } else {
            this.runSuiteInParallel();
        }
        invoker.invokeConfigurations(null, afterSuiteMethods.values().toArray(new ITestNGMethod[afterSuiteMethods.size()]), this.m_suite, this.m_suite.getAllParameters(), null);
    }

    private void runSequentially() {
        for (TestRunner tr : this.m_testRunners) {
            this.runTest(tr);
        }
    }

    private void runTest(TestRunner tr) {
        Map<String, String> parameters = tr.getTest().getParameters();
        tr.getInvoker().invokeConfigurations(null, tr.getBeforeTestConfigurationMethods(), this.m_suite, parameters, null);
        tr.run();
        tr.getInvoker().invokeConfigurations(null, tr.getAfterTestConfigurationMethods(), this.m_suite, parameters, null);
        SuiteResult sr = new SuiteResult(this.m_suite, (ITestContext)tr);
        this.m_suiteResults.put(tr.getName(), sr);
    }

    private void runSuiteInParallel() {
        long maxTimeOut = this.m_suite.getTimeOut(120000L);
        int nPoolSize = this.m_testRunners.size();
        IPooledExecutor executor = ThreadUtil.createPooledExecutor(nPoolSize);
        for (TestRunner tr : this.m_testRunners) {
            executor.execute(new SuiteWorker(tr));
        }
        try {
            executor.shutdown();
            executor.awaitTermination(maxTimeOut);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void addListener(ISuiteListener reporter) {
        this.m_listeners.add(reporter);
    }

    @Override
    public String getOutputDirectory() {
        return this.m_outputDir + File.separatorChar + this.getName();
    }

    @Override
    public Map<String, ISuiteResult> getResults() {
        return this.m_suiteResults;
    }

    @Override
    public String getParameter(String parameterName) {
        return this.m_suite.getParameter(parameterName);
    }

    @Override
    public Map<String, Collection<ITestNGMethod>> getMethodsByGroups() {
        HashMap<String, Collection<ITestNGMethod>> result = new HashMap<String, Collection<ITestNGMethod>>();
        for (TestRunner tr : this.m_testRunners) {
            ITestNGMethod[] methods;
            for (ITestNGMethod m : methods = tr.getTestMethods()) {
                String[] groups;
                for (String groupName : groups = m.getGroups()) {
                    ArrayList<ITestNGMethod> testMethods = (ArrayList<ITestNGMethod>)result.get(groupName);
                    if (null == testMethods) {
                        testMethods = new ArrayList<ITestNGMethod>();
                        result.put(groupName, testMethods);
                    }
                    testMethods.add(m);
                }
            }
        }
        return result;
    }

    @Override
    public Collection<ITestNGMethod> getInvokedMethods() {
        return this.getIncludedOrExcludedMethods(true);
    }

    @Override
    public Collection<ITestNGMethod> getExcludedMethods() {
        return this.getIncludedOrExcludedMethods(false);
    }

    private Collection<ITestNGMethod> getIncludedOrExcludedMethods(boolean included) {
        ArrayList<ITestNGMethod> result = new ArrayList<ITestNGMethod>();
        for (TestRunner tr : this.m_testRunners) {
            Collection<ITestNGMethod> methods = included ? tr.getInvokedMethods() : tr.getExcludedMethods();
            for (ITestNGMethod m : methods) {
                result.add(m);
            }
        }
        return result;
    }

    public static IAnnotationFinder getAnnotationFinder(XmlTest test) {
        int annotationType = "javadoc".equals(test.getAnnotations()) ? 2 : 1;
        return SuiteRunner.getAnnotationFinder(annotationType);
    }

    public static IAnnotationFinder getAnnotationFinder(int annotationType) {
        AnnotationConfiguration annotConfig = AnnotationConfiguration.getInstance();
        annotConfig.initialize(annotationType);
        return annotConfig.getAnnotationFinder();
    }

    public static void ppp(String s) {
        System.out.println("[SuiteRunner] " + s);
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public SuiteRunState getSuiteState() {
        return this.m_suiteState;
    }

    public static class ProxyTestRunnerFactory
    implements ITestRunnerFactory {
        private ITestListener[] m_failureGenerators;
        private ITestRunnerFactory m_target;

        public ProxyTestRunnerFactory(ITestListener[] failureListeners, ITestRunnerFactory target) {
            this.m_failureGenerators = failureListeners;
            this.m_target = target;
        }

        public TestRunner newTestRunner(ISuite suite, XmlTest test) {
            TestRunner testRunner = this.m_target.newTestRunner(suite, test);
            testRunner.addTestListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            for (ITestListener itl : this.m_failureGenerators) {
                testRunner.addTestListener(itl);
            }
            return testRunner;
        }
    }

    public static class DefaultTestRunnerFactory
    implements ITestRunnerFactory {
        private ITestListener[] m_failureGenerators;
        private boolean m_useDefaultListeners;

        public DefaultTestRunnerFactory(ITestListener[] failureListeners, boolean useDefaultListeners) {
            this.m_failureGenerators = failureListeners;
            this.m_useDefaultListeners = useDefaultListeners;
        }

        public TestRunner newTestRunner(ISuite suite, XmlTest test) {
            TestRunner testRunner = new TestRunner(suite, test, suite.getOutputDirectory(), SuiteRunner.getAnnotationFinder(test));
            if (this.m_useDefaultListeners) {
                testRunner.addTestListener(new TestHTMLReporter());
                testRunner.addTestListener(new JUnitXMLReporter());
                testRunner.addTestListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            }
            for (ITestListener itl : this.m_failureGenerators) {
                testRunner.addTestListener(itl);
            }
            return testRunner;
        }
    }

    private class SuiteWorker
    implements Runnable {
        private TestRunner m_testRunner;

        public SuiteWorker(TestRunner tr) {
            this.m_testRunner = tr;
        }

        public void run() {
            Utils.log("[SuiteWorker]", 4, "Running XML Test '" + this.m_testRunner.getTest().getName() + "' in Parallel");
            SuiteRunner.this.runTest(this.m_testRunner);
        }
    }
}

