/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote.strprotocol;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.remote.strprotocol.IStringMessage;
import org.testng.remote.strprotocol.MessageHelper;

public class TestResultMessage
implements IStringMessage {
    protected int m_messageType;
    protected String m_suiteName;
    protected String m_testName;
    protected String m_testClassName;
    protected String m_testMethodName;
    protected String m_stackTrace;
    protected long m_startMillis;
    protected long m_endMillis;

    TestResultMessage(int resultType, String suiteName, String testName, String className, String methodName, long startMillis, long endMillis, String stackTrace) {
        this.init(resultType, suiteName, testName, className, methodName, stackTrace, startMillis, endMillis);
    }

    public TestResultMessage(String suiteName, String testName, ITestResult result) {
        String stackTrace = null;
        if (2 == result.getStatus() || 4 == result.getStatus()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Throwable cause = result.getThrowable();
            if (null != cause) {
                cause.printStackTrace(pw);
                stackTrace = sw.getBuffer().toString();
            } else {
                stackTrace = "unknown stack trace";
            }
        }
        this.init(1000 + result.getStatus(), suiteName, testName, result.getTestClass().getName(), result.getMethod().getMethod().getName(), stackTrace, result.getStartMillis(), result.getEndMillis());
    }

    public TestResultMessage(ITestContext testCtx, ITestResult result) {
        this(testCtx.getSuite().getName(), testCtx.getName(), result);
    }

    private void init(int resultType, String suiteName, String testName, String className, String methodName, String stackTrace, long startMillis, long endMillis) {
        this.m_messageType = resultType;
        this.m_suiteName = suiteName;
        this.m_testName = testName;
        this.m_testClassName = className;
        this.m_testMethodName = methodName;
        this.m_stackTrace = stackTrace;
        this.m_startMillis = startMillis;
        this.m_endMillis = endMillis;
    }

    public int getResult() {
        return this.m_messageType;
    }

    public String getMessageAsString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_messageType).append('\u0001').append(this.m_suiteName).append('\u0001').append(this.m_testName).append('\u0001').append(this.m_testClassName).append('\u0001').append(this.m_testMethodName).append('\u0001').append(this.m_startMillis).append('\u0001').append(this.m_endMillis).append('\u0001').append(MessageHelper.replaceNewLine(this.m_stackTrace));
        return buf.toString();
    }

    public String getSuiteName() {
        return this.m_suiteName;
    }

    public String getTestClass() {
        return this.m_testClassName;
    }

    public String getMethod() {
        return this.m_testMethodName;
    }

    public String getName() {
        return this.m_testName;
    }

    public String getStackTrace() {
        return this.m_stackTrace;
    }

    public long getEndMillis() {
        return this.m_endMillis;
    }

    public long getStartMillis() {
        return this.m_startMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestResultMessage that = (TestResultMessage)o;
        if (this.m_suiteName != null ? !this.m_suiteName.equals(that.m_suiteName) : that.m_suiteName != null) {
            return false;
        }
        if (!this.m_testClassName.equals(that.m_testClassName)) {
            return false;
        }
        if (!this.m_testMethodName.equals(that.m_testMethodName)) {
            return false;
        }
        return !(this.m_testName != null ? !this.m_testName.equals(that.m_testName) : that.m_testName != null);
    }

    public int hashCode() {
        int result = this.m_suiteName != null ? this.m_suiteName.hashCode() : 0;
        result = 29 * result + (this.m_testName != null ? this.m_testName.hashCode() : 0);
        result = 29 * result + this.m_testClassName.hashCode();
        result = 29 * result + this.m_testMethodName.hashCode();
        return result;
    }
}

