/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.testng.IReporter;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.log4testng.Logger;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailableReporter
implements IReporter {
    Logger logger = Logger.getLogger(EmailableReporter.class);
    private PrintWriter out;
    int row;

    @Override
    public void generateReport(List<XmlSuite> xml, List<ISuite> suites, String outdir) {
        try {
            this.out = new PrintWriter(new FileWriter(new File(outdir, "emailable-report.html")));
        }
        catch (IOException e) {
            this.logger.error("output file", e);
            return;
        }
        this.startHtml(this.out);
        for (ISuite suite : suites) {
            this.summarize(suite);
            this.out.println("<a id=summary></a>");
            Map<String, ISuiteResult> r = suite.getResults();
            for (ISuiteResult r2 : r.values()) {
                this.resultSummary(r2.getTestContext().getFailedTests(), "failed");
                this.resultSummary(r2.getTestContext().getPassedTests(), "passed");
                this.resultDetail(r2.getTestContext().getFailedTests(), "failed");
                this.resultDetail(r2.getTestContext().getPassedTests(), "passed");
            }
        }
        this.out.println("</body></html>");
        this.out.close();
    }

    private void resultSummary(IResultMap tests, String style) {
        if (tests.getAllResults().size() > 0) {
            this.tableStart(style);
            this.out.println("<tr><th>Class</th><th>Method</th><th># of<br/>Scenarios</th><th>Time<br/>(Msecs)</th></tr>");
            int row = 0;
            StringBuffer buff = new StringBuffer();
            String lastc = "";
            int mq = 0;
            int cq = 0;
            for (ITestNGMethod method : this.getMethodSet(tests)) {
                ++row;
                String cname = method.getTestClass().getName();
                if (!cname.equalsIgnoreCase(lastc)) {
                    if (mq > 0) {
                        this.out.println("<tr" + (++cq % 2 == 0 ? " class=\"stripe\"" : "") + ">" + "<td rowspan=\"" + mq + "\">" + lastc + buff);
                    }
                    mq = 0;
                    buff.setLength(0);
                    lastc = cname;
                }
                Set<ITestResult> result_set = tests.getResults(method);
                long end = Long.MIN_VALUE;
                long start = Long.MAX_VALUE;
                for (ITestResult ans : tests.getResults(method)) {
                    if (ans.getEndMillis() > end) {
                        end = ans.getEndMillis();
                    }
                    if (ans.getStartMillis() >= start) continue;
                    start = ans.getStartMillis();
                }
                if (++mq > 1) {
                    buff.append("<tr" + (cq % 2 == 1 ? " class=\"stripe\"" : "") + ">");
                }
                buff.append("<td><a href=\"#m" + row + "\">" + this.qualifiedName(method) + "</a></td>" + "<td class=\"numi\">" + result_set.size() + "</td><td class=\"numi\">" + (end - start) + "</td></tr>");
            }
            if (mq > 0) {
                this.out.println("<tr" + (++row % 2 == 0 ? " class=\"stripe\"" : "") + ">" + "<td rowspan=\"" + mq + "\">" + lastc + buff);
            }
            this.out.println("</table>");
        }
    }

    private String qualifiedName(ITestNGMethod method) {
        String addon = "";
        if (method.getGroups().length > 0 && !"basic".equalsIgnoreCase(method.getGroups()[0])) {
            addon = " (" + method.getGroups()[0] + ")";
        }
        return method.getMethodName() + addon;
    }

    private void resultDetail(IResultMap tests, String style) {
        if (tests.getAllResults().size() > 0) {
            int row = 0;
            StringBuffer buff = new StringBuffer();
            for (ITestNGMethod method : this.getMethodSet(tests)) {
                String cname = method.getTestClass().getName();
                this.out.println("<a id=\"m" + ++row + "\"></a><h2>" + cname + ":" + method.getMethodName() + "</h2>");
                int rq = 0;
                Set<ITestResult> result_set = tests.getResults(method);
                for (ITestResult ans : result_set) {
                    List<String> msgs;
                    ++rq;
                    Object[] pset = ans.getParameters();
                    if (pset.length > 0) {
                        if (rq == 1) {
                            this.tableStart("param");
                            this.out.print("<tr>");
                            for (int x = 1; x <= pset.length; ++x) {
                                this.out.print("<th style=\"padding-left:1em;padding-right:1em\">Parameter #" + x + "</th>");
                            }
                            this.out.println("</tr>");
                        }
                        this.out.print("<tr>");
                        for (Object p : pset) {
                            this.out.println("<td style=\"padding-left:.5em;padding-right:2em\">" + p + "</td>");
                        }
                        this.out.println("</tr>");
                        if (rq == result_set.size()) {
                            this.out.println("</table>");
                        }
                    }
                    if ((msgs = Reporter.getOutput(ans)).size() <= 0) continue;
                    this.out.println("<div style=\"padding-left:3em\">");
                    for (String line : msgs) {
                        this.out.println(line + "<br/>");
                    }
                    this.out.println("</div>");
                }
                this.out.println("<p class=\"totop\"><a href=#top>back to summary</a></p>");
            }
        }
    }

    private Collection<ITestNGMethod> getMethodSet(IResultMap tests) {
        TreeSet<ITestNGMethod> r = new TreeSet<ITestNGMethod>(new TestSorter());
        r.addAll(tests.getAllMethods());
        return r;
    }

    private void summarize(ISuite suite) {
        this.tableStart("param");
        Map<String, ISuiteResult> r = suite.getResults();
        for (ISuiteResult r2 : r.values()) {
            ITestContext overview = r2.getTestContext();
            this.tableRow("# of Tests passed", this.getMethodSet(overview.getPassedTests()).size());
            this.tableRow("# of Scenarios passed", overview.getPassedTests().size());
            this.tableRow("# failed", overview.getFailedTests().size());
            this.tableRow("# skipped", overview.getSkippedTests().size());
            DecimalFormat formatter = new DecimalFormat("#,##0.0");
            this.tableRow("Total Time", formatter.format((double)(overview.getEndDate().getTime() - overview.getStartDate().getTime()) / 1000.0) + " seconds");
            this.tableRow("Included Groups", overview.getIncludedGroups());
            this.tableRow("Excluded Groups", overview.getExcludedGroups());
        }
        this.out.println("</table>");
    }

    private void tableStart(String cssclass) {
        this.out.println("<table cellspacing=0 cellpadding=0" + (cssclass != null ? " class=\"" + cssclass + "\"" : " style=\"padding-bottom:2em\"") + ">");
        this.row = 0;
    }

    private void tableRow(String label, String val) {
        ++this.row;
        this.out.println("<tr" + (this.row % 2 == 0 ? " class=\"stripe\"" : "") + "><th style=\"text-align:left;padding-right:2em\">" + label + "</th><td style=\"text-align:right\">" + val + "</td></tr>");
    }

    private void tableRow(String label, long val) {
        this.tableRow(label, String.valueOf(val));
    }

    private void tableRow(String label, String[] val) {
        StringBuffer b = new StringBuffer();
        for (String v : val) {
            b.append(v + " ");
        }
        this.tableRow(label, b.toString().trim());
    }

    private void startHtml(PrintWriter out) {
        out.println("<html>");
        out.println("<head>");
        out.println("<title>TestNG:  Unit Test</title>");
        out.println("<style type=\"text/css\">");
        out.println("table.info_table,table.param,table.passed,table.failed {margin-bottom:10px;border:1px solid #000099;border-collapse:collapse;empty-cells:show;}");
        out.println("table.info_table td,table.info_table th,table.param td,table.param th,table.passed td,table.passed th,table.failed td,table.failed th {");
        out.println("border:1px solid #000099;padding:.25em .5em .25em .5em");
        out.println("}");
        out.println("td.numi {");
        out.println("text-align:right");
        out.println("}");
        out.println("table.passed td {background-color: #00AA00;}");
        out.println("table.passed tr.stripe td {background-color: #33FF33;}");
        out.println("table.failed td {background-color: #DD0000;}");
        out.println("table.failed tr.stripe td {background-color: #FF3333;}");
        out.println("tr.stripe td,tr.stripe th {background-color: #E6EBF9;}");
        out.println("p.totop {font-size:85%;text-align:center;border-bottom:2px black solid}");
        out.println("div.shootout {padding:2em;border:3px #4854A8 solid}");
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestSorter<T extends ITestNGMethod>
    implements Comparator {
        private TestSorter() {
        }

        public int compare(Object o1, Object o2) {
            int r = ((ITestNGMethod)o1).getTestClass().getName().compareTo(((ITestNGMethod)o2).getTestClass().getName());
            if (r == 0) {
                r = ((ITestNGMethod)o1).getMethodName().compareTo(((ITestNGMethod)o2).getMethodName());
            }
            return r;
        }
    }
}

