/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.geometry.spline;

import no.geosoft.cc.geometry.spline.Spline;

class BezierSpline
extends Spline {
    BezierSpline(double[] dArray, int n) {
        this.controlPoints_ = dArray;
        this.nParts_ = n;
    }

    double[] generate() {
        if (this.controlPoints_.length < 9) {
            double[] dArray = new double[this.controlPoints_.length];
            System.arraycopy(this.controlPoints_, 0, dArray, 0, this.controlPoints_.length);
            return dArray;
        }
        int n = this.controlPoints_.length / 3;
        int n2 = (n - 3) * this.nParts_ + 1;
        double[] dArray = new double[n2 * 3];
        this.p(0, 0.0, this.controlPoints_, dArray, 0);
        int n3 = 3;
        int n4 = 0;
        while (n4 < n - 3) {
            int n5 = 1;
            while (n5 <= this.nParts_) {
                this.p(n4, (double)n5 / (double)this.nParts_, this.controlPoints_, dArray, n3);
                n3 += 3;
                ++n5;
            }
            n4 += 3;
        }
        return dArray;
    }

    private void p(int n, double d, double[] dArray, double[] dArray2, int n2) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = n;
        int n4 = 0;
        while (n4 <= 3) {
            double d5 = this.blend(n4, d);
            d2 += d5 * dArray[n3++];
            d3 += d5 * dArray[n3++];
            d4 += d5 * dArray[n3++];
            ++n4;
        }
        dArray2[n2 + 0] = d2;
        dArray2[n2 + 1] = d3;
        dArray2[n2 + 2] = d4;
    }

    private double blend(int n, double d) {
        if (n == 0) {
            return (1.0 - d) * (1.0 - d) * (1.0 - d);
        }
        if (n == 1) {
            return 3.0 * d * (1.0 - d) * (1.0 - d);
        }
        if (n == 2) {
            return 3.0 * d * d * (1.0 - d);
        }
        return d * d * d;
    }
}

