/*
 * Decompiled with CFR 0.152.
 */
package SecondaryStructureDesign;

import generaltools.Namable;
import java.util.logging.Logger;
import rnadesign.rnamodel.PackageConstants;
import rnasecondary.Interaction;
import rnasecondary.SecondaryStructure;
import rnasecondary.SecondaryStructureWriter;
import sequence.Residue;
import sequence.Sequence;

public class SecondaryStructureDebugWriter
implements SecondaryStructureWriter {
    public static final char NO_BASE_PAIR_CHAR = '.';
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean writeSequenceMode = true;
    private boolean purgeMultipleInteractions = true;

    public SecondaryStructureDebugWriter() {
        log.info("Started SecondaryStructureDebugWriter");
    }

    private static String setChar(String s, char c, int pos) {
        if (pos >= s.length()) {
            return s;
        }
        String result = s.substring(0, pos) + c + s.substring(pos + 1, s.length());
        assert (result.length() == s.length());
        return result;
    }

    private String writeSequence(SecondaryStructure structure, int seqId) {
        Sequence sequence = structure.getSequence(seqId);
        String result = sequence.sequenceString();
        return result;
    }

    private int findSequence(Residue res, SecondaryStructure structure) {
        assert (res != null);
        assert (structure != null);
        for (int i = 0; i < structure.getSequenceCount(); ++i) {
            Sequence seq = structure.getSequence(i);
            Residue other = seq.getResidue(0);
            if (!res.isSameSequence(other)) continue;
            return i;
        }
        return -1;
    }

    private void addInteraction(Interaction interaction, Interaction[][] interactionArray, SecondaryStructure structure) {
        Residue res1 = interaction.getResidue1();
        Residue res2 = interaction.getResidue2();
        assert (res1 != null);
        assert (res2 != null);
        int seqId1 = this.findSequence(res1, structure);
        int seqId2 = this.findSequence(res2, structure);
        if (seqId1 >= 0 && seqId2 >= 0) {
            interactionArray[seqId1][res1.getPos()] = interaction;
            interactionArray[seqId2][res2.getPos()] = interaction;
        } else {
            log.warning("could not find: " + res1.getSymbol() + res1.getPos() + " " + res2.getSymbol() + res2.getPos());
        }
    }

    private char incChar(char c) {
        int n = c;
        return (char)(++n);
    }

    private char decChar(char c) {
        int n = c;
        return (char)(--n);
    }

    private double[][] generateInteractionMatrix(Interaction[][] interactionArray, int seqId1, int seqId2, SecondaryStructure structure) {
        int i;
        Sequence sequence1 = structure.getSequence(seqId1);
        Sequence sequence2 = structure.getSequence(seqId2);
        int size1 = sequence1.size();
        int size2 = sequence2.size();
        double[][] matrix = new double[size1][size2];
        for (i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                matrix[i][j] = 0.0;
            }
        }
        for (i = 0; i < size1; ++i) {
            Interaction interaction = interactionArray[seqId1][i];
            if (interaction == null) continue;
            Residue res1 = interaction.getResidue1();
            Residue res2 = interaction.getResidue2();
            int sid1 = this.findSequence(res1, structure);
            int sid2 = this.findSequence(res2, structure);
            if (sid1 == seqId1 && sid2 == seqId2) {
                assert (res1.getPos() < matrix.length);
                assert (res2.getPos() < matrix[res1.getPos()].length);
                matrix[res1.getPos()][res2.getPos()] = 1.0;
                continue;
            }
            if (sid1 != seqId2 || sid2 != seqId1) continue;
            assert (res2.getPos() < matrix.length);
            assert (res1.getPos() < matrix[res2.getPos()].length);
            matrix[res2.getPos()][res1.getPos()] = 1.0;
        }
        return matrix;
    }

    String writeInteraction(Interaction interaction) {
        StringBuffer result = new StringBuffer();
        Residue residue1 = interaction.getResidue1();
        Residue residue2 = interaction.getResidue2();
        String sname1 = null;
        String sname2 = null;
        if (residue1.getParentObject() instanceof Namable) {
            sname1 = ((Namable)residue1.getParentObject()).getName();
            sname2 = ((Namable)residue2.getParentObject()).getName();
        }
        result.append(sname1 + interaction.getResidue1().getPos());
        result.append(":");
        result.append(sname2 + interaction.getResidue2().getPos());
        return result.toString();
    }

    @Override
    public String writeString(SecondaryStructure structure) {
        int i;
        if (structure == null || structure.getSequenceCount() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < structure.getSequenceCount(); ++i) {
            buf.append(structure.getSequence(i).sequenceString());
            buf.append(PackageConstants.NEWLINE);
        }
        for (i = 0; i < structure.getInteractionCount(); ++i) {
            Interaction interaction = structure.getInteraction(i);
            if (interaction.getInteractionType().getSubTypeId() == 6) continue;
            buf.append(this.writeInteraction(interaction) + " ");
        }
        return buf.toString();
    }
}

