/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.PackageConstants;
import commandtools.StringParameter;

public class EchoCommand
extends AbstractCommand
implements Command {
    public static final String COMMAND_NAME = "echo";

    public EchoCommand() {
        super(COMMAND_NAME);
    }

    public EchoCommand(String message) {
        super(COMMAND_NAME);
        this.addParameter(new StringParameter(message));
    }

    public EchoCommand(StringParameter messageParameter) {
        super(COMMAND_NAME);
        this.addParameter(messageParameter);
    }

    @Override
    public Object cloneDeep() {
        EchoCommand result = new EchoCommand();
        for (int i = 0; i < this.getParameterCount(); ++i) {
            result.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return result;
    }

    @Override
    public Command execute() {
        this.executeWithoutUndo();
        return null;
    }

    @Override
    public void executeWithoutUndo() {
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (!(this.getParameter(i) instanceof StringParameter)) continue;
            StringParameter sp = (StringParameter)this.getParameter(i);
            System.out.print(sp.getValue() + " ");
        }
        System.out.println();
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"echo\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " [options]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Echo command echoes strings and values." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    private String helpOutput() {
        return "Correct usage: echo [options]";
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("echo ");
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (!(this.getParameter(i) instanceof StringParameter)) continue;
            StringParameter sp = (StringParameter)this.getParameter(i);
            result.append("" + sp.getValue() + " ");
        }
        return result.toString();
    }
}

