/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.PackageConstants;
import commandtools.StringParameter;
import java.util.Properties;

public class SetCommand
extends AbstractCommand
implements Command {
    public static final String COMMAND_NAME = "set";
    private Properties properties;

    public SetCommand(Properties properties) {
        super(COMMAND_NAME);
        this.properties = properties;
    }

    @Override
    public Object cloneDeep() {
        SetCommand result = new SetCommand(this.properties);
        result.properties = this.properties;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            result.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return result;
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        String varName = null;
        String varValue = null;
        if (this.getParameterCount() != 2) {
            throw new CommandExecutionException("Correct usage of set command: set variablename value");
        }
        if (this.getParameter(0) instanceof StringParameter) {
            varName = ((StringParameter)this.getParameter(0)).getValue();
        } else assert (false);
        if (this.getParameter(1) instanceof StringParameter) {
            varValue = ((StringParameter)this.getParameter(1)).getValue();
        } else assert (false);
        this.properties.setProperty(varName, varValue);
    }

    private String helpOutput() {
        return "Correct usage: set variablename value";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"set\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " VARIABLENAME VALUE" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Set command allows user to set a variable to a value." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("set ");
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (!(this.getParameter(i) instanceof StringParameter)) continue;
            StringParameter sp = (StringParameter)this.getParameter(i);
            result.append("" + sp.getValue() + " ");
        }
        return result.toString();
    }
}

