/*
 * Decompiled with CFR 0.152.
 */
package guitools;

import guitools.TextDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class SimpleTextDialog
implements TextDialog {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    ActionListener externalDoneActionListener;
    JFrame frame;
    Component parentFrame;
    JTextArea textArea;
    String originalText;
    boolean cancelled = false;
    boolean finished = false;

    public SimpleTextDialog(String s, ActionListener externalDoneActionListener, Component parentFrame) {
        this.externalDoneActionListener = externalDoneActionListener;
        this.originalText = s;
        this.parentFrame = parentFrame;
        this.frame = new JFrame();
        Container f = this.frame.getContentPane();
        f.setLayout(new BorderLayout());
        this.textArea = new JTextArea(10, 8);
        if (s != null) {
            this.textArea.setText(s);
        }
        f.add((Component)this.textArea, "Center");
        f.add((Component)new BottomPanel(), "South");
        this.frame.pack();
        this.frame.setVisible(true);
        if (parentFrame != null) {
            parentFrame.setEnabled(false);
        }
        this.frame.requestFocusInWindow();
    }

    @Override
    public String getText() {
        return this.textArea.getText();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    private class BottomPanel
    extends JPanel {
        BottomPanel() {
            this.setLayout(new FlowLayout());
            JButton button = new JButton("Reset");
            button.addActionListener(new ResetActionListener());
            this.add(button);
            button = new JButton("Clear");
            button.addActionListener(new ClearActionListener());
            this.add(button);
            button = new JButton("Cancel");
            button.addActionListener(new CancelActionListener());
            this.add(button);
            button = new JButton("Done");
            button.addActionListener(new DoneActionListener());
            this.add(button);
        }
    }

    private class ResetActionListener
    implements ActionListener {
        private ResetActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleTextDialog.this.textArea.setText(SimpleTextDialog.this.originalText);
        }
    }

    private class ClearActionListener
    implements ActionListener {
        private ClearActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleTextDialog.this.textArea.setText("");
        }
    }

    private class CancelActionListener
    implements ActionListener {
        private CancelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleTextDialog.this.frame.setVisible(false);
            log.fine("SimpleTextDialog cancelled!");
            if (SimpleTextDialog.this.parentFrame != null) {
                SimpleTextDialog.this.parentFrame.setEnabled(true);
                SimpleTextDialog.this.parentFrame.repaint();
            }
            SimpleTextDialog.this.cancelled = true;
            SimpleTextDialog.this.finished = true;
        }
    }

    private class DoneActionListener
    implements ActionListener {
        private DoneActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleTextDialog.this.frame.setVisible(false);
            SimpleTextDialog.this.finished = true;
            log.fine("SimpleTextDialog finished!");
            if (SimpleTextDialog.this.externalDoneActionListener != null) {
                SimpleTextDialog.this.externalDoneActionListener.actionPerformed(e);
            }
            if (SimpleTextDialog.this.parentFrame != null) {
                SimpleTextDialog.this.parentFrame.setEnabled(true);
                SimpleTextDialog.this.parentFrame.repaint();
            }
        }
    }
}

