/*
 * Decompiled with CFR 0.152.
 */
package launchtools;

import java.util.ArrayList;
import java.util.List;
import launchtools.Job;
import launchtools.JobFinishedEvent;
import launchtools.JobFinishedListener;
import launchtools.ProcessRunInfo;
import launchtools.RunCommand;

public class JobImp
implements Job {
    private List<JobFinishedListener> listeners = new ArrayList<JobFinishedListener>();
    private boolean started = false;
    private boolean running = false;
    private boolean finished = false;
    private int jobId = 0;
    private List<Exception> exceptions = new ArrayList<Exception>();
    private RunCommand command = null;
    private ProcessRunInfo runInfo = null;

    JobImp(RunCommand command) {
        this.command = command;
    }

    @Override
    public void addException(Exception e) {
        this.exceptions.add(e);
    }

    @Override
    public void addJobFinishedListener(JobFinishedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void fireJobFinished() {
        JobFinishedEvent event = new JobFinishedEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            JobFinishedListener listener = this.getJobFinishedListener(i);
            listener.jobFinished(event);
        }
    }

    public JobFinishedListener getJobFinishedListener(int n) {
        return this.listeners.get(n);
    }

    @Override
    public int getJobId() {
        return this.jobId;
    }

    @Override
    public RunCommand getCommand() {
        return this.command;
    }

    @Override
    public ProcessRunInfo getRunInfo() {
        return this.runInfo;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void removeJobFinishedListener(JobFinishedListener listener) {
        this.listeners.remove(listener);
    }

    public void setFinished(boolean b) {
        this.finished = b;
    }

    @Override
    public void setJobId(int n) {
        this.jobId = n;
    }

    @Override
    public void setRunInfo(ProcessRunInfo runInfo) {
        this.runInfo = runInfo;
    }

    @Override
    public void setFinished() {
        this.finished = true;
        this.running = false;
    }

    @Override
    public void start() {
        this.started = true;
        this.running = true;
    }

    @Override
    public void stop() {
        this.running = false;
        this.finished = true;
    }

    public String toString() {
        String result = "job " + this.getJobId() + " : " + this.getCommand();
        return result;
    }
}

