/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.io.PrintStream;
import java.util.Properties;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.MoleculeTools;
import tools3d.objects3d.Object3D;

public class CharacterizeCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "characterize";
    private Object3DGraphController controller;
    private PrintStream ps;
    private String name;
    private String firstValue;

    public CharacterizeCommand(PrintStream ps, Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        assert (ps != null);
        this.ps = ps;
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        CharacterizeCommand command = new CharacterizeCommand(this.ps, this.controller);
        command.name = this.name;
        command.firstValue = this.firstValue;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: characterize [strands|atoms|helixends|residues][allowed=<CLASSNAME>][forbidden=<CLASSNAME>][name=<OBJECTNAME>]" + PackageConstants.NEWLINE + " with typical CLASSNAME values of Atom3D, RnaStrand3D and object names of root.A or 1.1.5";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"characterize\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.helpOutput();
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Tree command displays list of objects in tree." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        helpText = helpText + "     allowed=OBJECT" + PackageConstants.NEWLINE + "          Atom3D, Nucleotide3D. Show only this type." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     forbidden=OBJECT" + PackageConstants.NEWLINE + "          RnaStrand3D. Do not show this type." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     name=OBJECT" + PackageConstants.NEWLINE + "          Only print the sub-tree from node with this name." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        Properties prop = new Properties();
        Object3D obj = this.controller.getGraph().getGraph();
        if (this.name != null && (obj = this.controller.getGraph().findByFullName(this.name)) == null) {
            throw new CommandExecutionException("Could not find object: " + this.name);
        }
        prop = MoleculeTools.characterize(obj);
        this.ps.println("Result of characterization: ");
        this.ps.println(prop.toString());
        this.resultProperties = prop;
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter nameParameter;
        StringParameter firstParameter;
        if (this.getParameterCount() > 0 && (firstParameter = (StringParameter)this.getParameter(0)) != null) {
            this.firstValue = firstParameter.getValue();
        }
        if ((nameParameter = (StringParameter)this.getParameter("name")) != null) {
            this.name = nameParameter.getValue();
        }
    }
}

