/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.ParsingException;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import tools3d.Vector3D;

public class GenShapeCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "genshape";
    private Object3DGraphController controller;
    private String name;
    private String geomName;
    private double length = 100.0;
    private Vector3D startPos = new Vector3D(0.0, 0.0, 0.0);
    private boolean addStemsFlag = false;
    private char sequenceChar = (char)78;
    private boolean onlyFirstPathMode = false;
    private int geometryCode = 103;
    private int tilerAlgorithm = -1;
    private String childNameBase = "p";

    public GenShapeCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        GenShapeCommand command = new GenShapeCommand(this.controller);
        command.name = this.name;
        command.geomName = this.geomName;
        command.length = this.length;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: genshape ringN|prismN|tetrahedron|cube|dodecahedron|icosahedron|octahedron [name=objectname][length=value]" + PackageConstants.NEWLINE;
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"genshape\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.helpOutput();
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     genshape command generates 3D object of specified type." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        helpText = helpText + "     name=OBJECT" + PackageConstants.NEWLINE + "          Name of generated object." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     length=VALUE" + PackageConstants.NEWLINE + "          Side length of 3D object." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            this.controller.addGeometry(this.startPos, this.length, this.name, this.childNameBase, this.addStemsFlag, this.sequenceChar, this.onlyFirstPathMode, this.geometryCode, this.tilerAlgorithm);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException("Error in genshape command: " + e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private int parseGeometryCode(String geomName) throws ParsingException {
        if (geomName == null) {
            throw new ParsingException("No geometry name specified!");
        }
        try {
            if (geomName.equals("cube")) {
                return 11;
            }
            if (geomName.equals("tetrahedron")) {
                return 10;
            }
            if (geomName.equals("dodecahedron")) {
                return 13;
            }
            if (geomName.equals("octahedron")) {
                return 12;
            }
            if (geomName.equals("icosahedron")) {
                return 14;
            }
            if (geomName.startsWith("ring")) {
                int geomCode = 100 + Integer.parseInt(geomName.substring("ring".length()));
                return geomCode;
            }
            if (geomName.startsWith("prism")) {
                int geomCode = 200 + Integer.parseInt(geomName.substring("prism".length()));
                return geomCode;
            }
            if (!geomName.equals("pink_polarbear")) {
                throw new ParsingException("Error in parsing geometry code: unknown geometry name " + geomName);
            }
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Error parsing geometry code number: " + e.getMessage());
        }
        return -1;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() == 0) {
            throw new CommandExecutionException("genshape command has to have at least one parameter! Try help genshape or man genshape.");
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        assert (p0 != null);
        this.geomName = p0.getValue();
        try {
            this.geometryCode = this.parseGeometryCode(this.geomName);
            StringParameter nameParameter = (StringParameter)this.getParameter("name");
            this.name = nameParameter != null ? nameParameter.getValue() : this.geomName;
            StringParameter lengthParameter = (StringParameter)this.getParameter("length");
            if (lengthParameter != null) {
                this.length = Double.parseDouble(lengthParameter.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException(nfe.getMessage());
        }
        catch (ParsingException pe) {
            throw new CommandExecutionException(pe.getMessage());
        }
    }
}

