/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class MoveToClosestCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "movetoclosest";
    private Object3DGraphController controller;
    private String origName;
    private String newParentName;
    private String distClassName;
    private String assignClassName;
    double distCutoff = 3.0;

    public MoveToClosestCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        MoveToClosestCommand command = new MoveToClosestCommand(this.controller);
        command.origName = this.origName;
        command.newParentName = this.newParentName;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: movetoclosest originalname newparentname";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"movetoclosest\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " ORIGINALNAME NEWPARENTNAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Move command moves an object within a tree." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        log.info("Starting movetoclosest with " + this.origName + " " + this.newParentName + " " + this.distClassName + " " + this.assignClassName + " " + this.distCutoff);
        try {
            this.controller.getGraph().moveToClosestObject(this.origName, this.newParentName, this.distClassName, this.assignClassName, this.distCutoff);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() != 5) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        this.origName = p0.getValue();
        StringParameter p1 = (StringParameter)this.getParameter(1);
        this.newParentName = p1.getValue();
        StringParameter p2 = (StringParameter)this.getParameter(2);
        this.distClassName = p2.getValue();
        StringParameter p3 = (StringParameter)this.getParameter(3);
        this.assignClassName = p3.getValue();
        StringParameter p4 = (StringParameter)this.getParameter(4);
        this.distCutoff = Double.parseDouble(p4.getValue());
    }
}

