/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.util.Properties;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.objects3d.Object3D;

public class PropertiesCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "properties";
    private Object3DGraphController controller;
    private String origName;
    String key;
    String value;

    public PropertiesCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        PropertiesCommand command = new PropertiesCommand(this.controller);
        command.origName = this.origName;
        command.key = this.key;
        command.value = this.value;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: properties objectname";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"properties\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " OBJECTNAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     properties command returns the defined properties of an object" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        Object3D obj = this.controller.getGraph().findByFullName(this.origName);
        if (obj == null) {
            throw new CommandExecutionException("Command error");
        }
        Properties properties = obj.getProperties();
        if (this.key != null && this.key.length() > 0 && this.value != null && this.value.length() > 0) {
            obj.setProperty(this.key, this.value);
        }
        if (properties == null) {
            properties = new Properties();
        }
        System.out.println("" + properties);
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() != 1) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        this.origName = p0.getValue();
    }
}

