/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;

public class TreeCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "tree";
    private Object3DGraphController controller;
    private PrintStream ps;
    private String name;
    private Set<String> allowedNames;
    private Set<String> forbiddenNames;
    private String firstValue;

    public TreeCommand(PrintStream ps, Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        assert (ps != null);
        this.ps = ps;
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        TreeCommand command = new TreeCommand(this.ps, this.controller);
        command.name = this.name;
        command.allowedNames = this.allowedNames;
        command.forbiddenNames = this.forbiddenNames;
        command.firstValue = this.firstValue;
        log.finest("Copying " + this.getParameterCount() + " parameters!");
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: tree [strand|atom|helixend|residue][allowed=[<CLASSNAME>[,<CLASSNAME>][...]][forbidden=<CLASSNAME>[,<CLASSNAME>[...]][name=<OBJECTNAME>]" + PackageConstants.NEWLINE + " with typical CLASSNAME values of Atom3D, RnaStrand3D, Nucleotide3D, BranchDescriptor3D and object names of root.A or 1.1.5";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"tree\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.helpOutput() + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Tree command displays list of objects in tree." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        helpText = helpText + "     allowed=<CLASSNAME>[,<CLASSNAME>[,...]]" + PackageConstants.NEWLINE + "      Show only objects that belong to the specified class or classes." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     forbidden=<CLASSNAME[,<CLASSNAME[,...]]" + PackageConstants.NEWLINE + "          Do not show objects of this class; also do not show child nodes of objects that belong to this class. Default: forbidden=Atom3D" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     name=OBJECT" + PackageConstants.NEWLINE + "          Only print the sub-tree from node with this name." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "Examples:" + PackageConstants.NEWLINE + "tree strand    : only show RNA strand objects." + PackageConstants.NEWLINE + "tree atom      : only show atoms." + PackageConstants.NEWLINE + "tree forbidden= : show all objects (including atoms)" + PackageConstants.NEWLINE + "tree forbidden=Nucleotide3D : show all objects except nucleotides and their child nodes." + PackageConstants.NEWLINE + "tree allowed=Nucleotide3D,Atom3D    : only show nucleotide or atom objects." + PackageConstants.NEWLINE + "tree name=root.import.A             : show all objects that are part of imported strand A." + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        if (this.firstValue != null) {
            if (this.firstValue.equals("atom")) {
                this.allowedNames = new HashSet<String>();
                this.allowedNames.add("Atom3D");
            } else if (this.firstValue.equals("strand")) {
                this.allowedNames = new HashSet<String>();
                this.allowedNames.add("RnaStrand");
                this.forbiddenNames.add("Nucleotide3D");
            } else if (this.firstValue.equals("helixend")) {
                this.allowedNames = new HashSet<String>();
                this.allowedNames.add("BranchDescriptor3D");
            } else if (this.firstValue.equals("hxend")) {
                this.allowedNames = new HashSet<String>();
                this.allowedNames.add("BranchDescriptor3D");
            } else if (this.firstValue.equals("residue")) {
                this.allowedNames = new HashSet<String>();
                this.allowedNames.add("Nucleotide3D");
            }
        }
        if (this.name != null) {
            this.controller.getGraph().printTree(this.ps, this.name, this.allowedNames, this.forbiddenNames);
        } else {
            this.controller.getGraph().printTree(this.ps, this.allowedNames, this.forbiddenNames);
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter forbiddenParameter;
        StringParameter allowedParameter;
        this.forbiddenNames = new HashSet<String>();
        if (this.getParameterCount() > 0) {
            StringParameter firstParameter = (StringParameter)this.getParameter(0);
            if (firstParameter != null) {
                this.firstValue = firstParameter.getValue();
                if (this.firstValue.indexOf(61) >= 0) {
                    this.firstValue = null;
                }
            }
        } else {
            this.forbiddenNames.add("Atom3D");
        }
        StringParameter nameParameter = (StringParameter)this.getParameter("name");
        if (nameParameter != null) {
            this.name = nameParameter.getValue();
        }
        if ((allowedParameter = (StringParameter)this.getParameter("allowed")) != null) {
            String[] allowedNamesRaw = allowedParameter.getValue().split(",");
            this.allowedNames = new HashSet<String>();
            for (String s : allowedNamesRaw) {
                this.allowedNames.add(s);
            }
        }
        if ((forbiddenParameter = (StringParameter)this.getParameter("forbidden")) != null) {
            String[] forbiddenNamesRaw = forbiddenParameter.getValue().split(",");
            this.forbiddenNames = new HashSet<String>();
            for (String s : forbiddenNamesRaw) {
                this.forbiddenNames.add(s);
            }
        }
    }
}

