/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rnadesign.designapp.AbstractDesigner;
import rnadesign.designapp.NanoTilerInterpreter;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.RnaTools;
import tools3d.objects3d.Object3D;

public class ElasticWizard
implements GeneralWizard {
    private static final int COL_SIZE_NAME = 25;
    private static final String FRAME_TITLE = "Elastic Wizard";
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean finished = false;
    private JFrame frame = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private CommandApplication application;
    private Object3DGraphController graphController;
    private NanoTilerInterpreter interpreter;
    private JTextField rootField;
    private JTextField classField;
    private JTextField cutoffField;
    private JTextField maxField;
    private JLabel label;
    private Vector<String> tree;
    private String[] allowedNames = RnaTools.getRnaClassNames();
    private String[] forbiddenNames;
    private JPanel treePanel;
    private JButton treeButton;
    private JList treeList;
    private JScrollPane treeScroll;

    public ElasticWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
        this.interpreter = (NanoTilerInterpreter)application.getInterpreter();
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void addComponents() {
        Container f = this.frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        JPanel westCenterPanel = new JPanel();
        westCenterPanel.setLayout(new BorderLayout());
        this.label = new JLabel("Root: ");
        westCenterPanel.add((Component)this.label, "North");
        this.rootField = new JTextField(this.getSelectionText(), 25);
        this.rootField.setText("root");
        westCenterPanel.add((Component)this.rootField, "Center");
        westCenterPanel.add((Component)new TreePanel(this.rootField), "South");
        centerPanel.add((Component)westCenterPanel, "West");
        JPanel eastCenterPanel = new JPanel();
        eastCenterPanel.setLayout(new BoxLayout(eastCenterPanel, 1));
        JPanel temp = new JPanel();
        temp.add(new JLabel("Class:"));
        this.classField = new JTextField(25);
        this.classField.setText("Atom3D");
        temp.add(this.classField);
        eastCenterPanel.add(temp);
        JPanel temp2 = new JPanel();
        temp2.add(new JLabel("Cutoff:"));
        this.cutoffField = new JTextField(25);
        this.cutoffField.setText("15.0");
        temp2.add(this.cutoffField);
        eastCenterPanel.add(temp2);
        JPanel temp3 = new JPanel();
        temp3.add(new JLabel("Max:"));
        this.maxField = new JTextField(25);
        this.maxField.setText("20");
        temp3.add(this.maxField);
        eastCenterPanel.add(temp3);
        centerPanel.add((Component)eastCenterPanel, "East");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton button = new JButton("Close");
        button.addActionListener(new CancelListener());
        buttonPanel.add(button);
        button = new JButton("Done");
        button.addActionListener(new ElasticListener());
        buttonPanel.add(button);
        f.add((Component)centerPanel, "Center");
        f.add((Component)buttonPanel, "South");
    }

    private String getSelectionText() {
        Object3DGraphController graphController = ((AbstractDesigner)this.application).getGraphController();
        Object3DController gControl = graphController.getGraph();
        Object3D selection = gControl.getSelectionRoot();
        if (selection == null) {
            return "";
        }
        String selectionName = selection.getName();
        Object3D curr = selection;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            selectionName = curr.getName() + "." + selectionName;
        }
        return selectionName;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController controller, Component parentFrame) {
        this.frame = new JFrame(FRAME_TITLE);
        if (controller == null) {
            log.info("GraphController received by lauchWizard is null!");
        }
        this.graphController = controller;
        this.addComponents();
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTextField field;

        public SelectionListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                String text = (String)ElasticWizard.this.tree.get(e.getFirstIndex());
                if ((text = text.substring(0, text.indexOf(" "))).equals(this.field.getText())) {
                    text = (String)ElasticWizard.this.tree.get(e.getLastIndex());
                    text = text.substring(0, text.indexOf(" "));
                }
                this.field.setText(text);
            }
        }
    }

    private class TreePanel
    extends JPanel {
        public TreePanel(JTextField field) {
            Object3DGraphController controller = ((AbstractDesigner)ElasticWizard.this.application).getGraphController();
            ElasticWizard.this.tree = controller.getGraph().getTree(ElasticWizard.this.allowedNames, ElasticWizard.this.forbiddenNames);
            this.setLayout(new BorderLayout());
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 1));
            labelPanel.add(new JLabel("Tree:"));
            this.add(labelPanel);
            ElasticWizard.this.treePanel = new JPanel();
            ElasticWizard.this.treeList = new JList(ElasticWizard.this.tree);
            ElasticWizard.this.treeList.addListSelectionListener(new SelectionListener(field));
            ElasticWizard.this.treeScroll = new JScrollPane(ElasticWizard.this.treeList);
            ElasticWizard.this.treeScroll.setVerticalScrollBarPolicy(20);
            ElasticWizard.this.treeScroll.setHorizontalScrollBarPolicy(30);
            ElasticWizard.this.treeScroll.setPreferredSize(new Dimension(300, 200));
            ElasticWizard.this.treePanel.add(ElasticWizard.this.treeScroll);
            this.add((Component)ElasticWizard.this.treePanel, "South");
        }
    }

    private class ElasticListener
    implements ActionListener {
        private ElasticListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = "elastic root=" + ElasticWizard.this.rootField.getText().trim() + " class=" + ElasticWizard.this.classField.getText().trim() + " cutoff=" + ElasticWizard.this.cutoffField.getText().trim() + " max=" + ElasticWizard.this.maxField.getText().trim();
            try {
                ElasticWizard.this.application.runScriptLine(command);
            }
            catch (CommandException ce) {
                JOptionPane.showMessageDialog(ElasticWizard.this.frame, ce + ": " + ce.getMessage());
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ElasticWizard.this.frame.setVisible(false);
            ElasticWizard.this.frame = null;
            ElasticWizard.this.finished = true;
        }
    }
}

