/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import rnadesign.designapp.NanoTilerInterpreter;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;

public class GraphicsManualWizard
implements GeneralWizard {
    private static final int WIDTH = 500;
    private static final int HEIGHT = 400;
    private boolean finished = false;
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private JFrame frame = null;
    private JTextArea helpText;
    private JButton close;
    private JTabbedPane helpTabs;
    private JScrollPane scroller;
    private CommandApplication application;
    private NanoTilerInterpreter interpreter;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private Object3DGraphController graphController;
    public static final String FRAME_TITLE = "Graphics Manual";

    public GraphicsManualWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
        this.interpreter = (NanoTilerInterpreter)application.getInterpreter();
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        if (graphController == null) {
            log.info("GraphController received by launchWizard is null!");
        }
        this.graphController = graphController;
        this.frame = new JFrame(FRAME_TITLE);
        this.addComponents(this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void addComponents(JFrame _frame) {
        Font bold = new Font("Bold", 1, 14);
        Font standard = new Font("Plain", 0, 10);
        this.helpTabs = new JTabbedPane();
        this.helpTabs.setPreferredSize(new Dimension(500, 400));
        Container f = _frame.getContentPane();
        f.setLayout(new BorderLayout());
        this.helpText = new JTextArea();
        this.helpText.setEditable(false);
        this.helpText.setPreferredSize(new Dimension(500, 400));
        this.helpText.append("Perspective:  \n");
        this.helpText.append("     View a molecule on screen and have the options\nof rotating, translating, and zooming in and out to change \nthe viewing perspective. The Perspective view is the most \nversatile of all the viewing options.\n\n");
        this.helpText.append("Top,Bottom,Right,Left,Front,Back:\n");
        this.helpText.append("     View a molecule from the chosen side with only \nthe options to zoom in and out and translate the image.\nThere is no rotating option in any like\nperspective mode.");
        this.helpTabs.add("Views", this.helpText);
        this.helpText = new JTextArea();
        this.helpText.setEditable(false);
        this.helpText.setPreferredSize(new Dimension(500, 400));
        this.helpText.append("Onscreen Mouse Clicking:\n");
        this.helpText.append("     If an object, such as an atom, is clicked on screen, \nthat object will become one of the selected objects. Click\nthe object again to deselect it.\n\n");
        this.helpText.append("Onscreen Mouse Dragging(left click):\n");
        this.helpText.append("     Dragging the mouse within the display area will translate\nthe molecule in the opposite direction to which the mouse\nwas dragged\n\n");
        this.helpText.append("Onscreen Mouse Dragging(right click):\n");
        this.helpText.append("     Dragging the mouse up or down within the display area \nwill rotate the camera clockwise and counterclockwise, \nrespectively.\n\n");
        this.helpText.append("Using the Buttons:\n");
        this.helpText.append("     In the upper right hand corner of the viewing panel(s), \nthere are three buttons which can be used to manipulate the camera\nview. The left button is used for basic translation.\nThe center button is used to rotate the camera.\nThe right button is used for zooming in and out.\nThe buttons are used by clicking the desired button \nand then dragging the mouse in a certain direction.\n\n");
        this.scroller = new JScrollPane(this.helpText);
        this.scroller.setVerticalScrollBarPolicy(20);
        this.helpTabs.add("Camera Controls", this.scroller);
        this.helpText = new JTextArea();
        this.helpText.setEditable(false);
        this.helpText.setPreferredSize(new Dimension(500, 400));
        this.helpText.append("Solid: \n");
        this.helpText.append("     Object are rendered with filled bodies.\n\n");
        this.helpText.append("Wireframe: \n");
        this.helpText.append("     Objects are rendered using wires to represent the body.\n\n");
        this.helpTabs.add("Modes", this.helpText);
        this.helpText = new JTextArea();
        this.helpText.setEditable(false);
        this.helpText.setPreferredSize(new Dimension(500, 400));
        this.helpText.append("Ball: \n");
        this.helpText.append("     All objects within the current molecule are rendered using a\nspherical representation.\n\n");
        this.helpText.append("Ball and Stick: \n");
        this.helpText.append("     Typical ball and stick representation.\n\n");
        this.helpText.append("Cartoon: \n");
        this.helpText.append("     Renders the molecule as a cartoon model.\n\n");
        this.helpText.append("Ribbon: \n");
        this.helpText.append("     The backbone of the molecule is represented as a ribbon.\n\n");
        this.helpTabs.add("Renderers", this.helpText);
        this.helpText = new JTextArea();
        this.helpText.setEditable(false);
        this.helpText.setPreferredSize(new Dimension(500, 400));
        this.helpText.append("Strand: \n");
        this.helpText.append("     Each strand is colored an individual color. Strand 1=red.\nStrand n=blue.\n\n");
        this.helpText.append("Rainbow: \n");
        this.helpText.append("     The rainbow color model colors each strand a variety\nof viewing colors from red to blue.\n\n");
        this.helpText.append("Atom: \n");
        this.helpText.append("     The atom color model colors atoms based on their type. The colors\ncan be configured by the user to meet their needs \nand/or preferences.\n\n");
        this.helpText.append("White: \n");
        this.helpText.append("     Everthing is colored white.\n\n");
        this.helpTabs.add("Color Models", this.helpText);
        this.helpText = new JTextArea();
        this.helpText.setEditable(false);
        this.helpText.setPreferredSize(new Dimension(500, 400));
        this.helpText.append("Deselect                                     Ctrl + D\n");
        this.helpText.append("Reset Camera to Default                      Ctrl + R\n");
        this.helpText.append("Translation Mode(object must be selected)    Ctrl + T\n");
        this.helpText.append("Rotation Mode(object must be selected)       Ctrl + Y\n");
        this.helpText.append("Cancel                                       Ctrl + C or Esc\n");
        this.helpText.append("Find                                         Ctrl + F\n");
        this.helpText.append("Move Camera(translation)                     Left Click\n");
        this.helpText.append("Rotate Camera                                Right Click\n");
        this.helpText.append("Zoom Camera                                  Left & Right Click\n");
        this.helpTabs.add("Shortcuts", this.helpText);
        JPanel buttonPanel = new JPanel();
        this.close = new JButton("Close");
        this.close.addActionListener(new CloseListener());
        buttonPanel.add(this.close);
        f.add((Component)buttonPanel, "South");
        f.add((Component)this.helpTabs, "North");
    }

    private class CloseListener
    implements ActionListener {
        private CloseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphicsManualWizard.this.frame.setVisible(false);
            GraphicsManualWizard.this.frame = null;
            GraphicsManualWizard.this.finished = true;
        }
    }
}

